/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.types;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.casperix.math.color.rgba.RgbaColor4f;
import ru.casperix.math.vector.float32.Vector3f;
import ru.casperix.math.vector.float32.Vector4f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\b\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B+\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\nB\u001b\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0011J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u0011R\u0011\u0010\u001f\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0011R\u0011\u0010!\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0011R\u0011\u0010#\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0011R\u0011\u0010%\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0011\u00a8\u0006("}, d2={"Lru/casperix/map_improvements/types/ABGRColor;", "", "", "value", "<init>", "(I)V", "red", "green", "blue", "alpha", "(IIII)V", "bgr", "(II)V", "Lru/casperix/math/vector/float32/Vector4f;", "toVector4f", "()Lru/casperix/math/vector/float32/Vector4f;", "component1", "()I", "copy", "(I)Lru/casperix/map_improvements/types/ABGRColor;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getValue", "getR", "r", "getG", "g", "getB", "b", "getA", "a", "getBgr", "Companion", "map_improvements-mc1.20.1"})
public final class ABGRColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int value;
    @NotNull
    private static final ABGRColor WHITE = new ABGRColor(255, 255, 255, 255);
    @NotNull
    private static final ABGRColor BLACK = new ABGRColor(0, 0, 0, 255);
    @NotNull
    private static final ABGRColor EMPTY = new ABGRColor(0, 0, 0, 0);

    public ABGRColor(int value) {
        this.value = value;
    }

    public final int getValue() {
        return this.value;
    }

    public ABGRColor(int red, int green, int blue, int alpha) {
        this((alpha & 0xFF) << 24 | (blue & 0xFF) << 16 | (green & 0xFF) << 8 | red & 0xFF);
    }

    public /* synthetic */ ABGRColor(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = 255;
        }
        this(n, n2, n3, n4);
    }

    public final int getR() {
        return this.value >> 0 & 0xFF;
    }

    public final int getG() {
        return this.value >> 8 & 0xFF;
    }

    public final int getB() {
        return this.value >> 16 & 0xFF;
    }

    public final int getA() {
        return this.value >> 24 & 0xFF;
    }

    public final int getBgr() {
        return (this.getB() & 0xFF) << 16 | (this.getG() & 0xFF) << 8 | this.getR() & 0xFF;
    }

    public ABGRColor(int bgr, int alpha) {
        this(bgr >> 0 & 0xFF, bgr >> 8 & 0xFF, bgr >> 16 & 0xFF, alpha);
    }

    public /* synthetic */ ABGRColor(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 255;
        }
        this(n, n2);
    }

    @NotNull
    public final Vector4f toVector4f() {
        return new Vector4f((float)this.getR() / 255.0f, (float)this.getG() / 255.0f, (float)this.getB() / 255.0f, (float)this.getA() / 255.0f);
    }

    public final int component1() {
        return this.value;
    }

    @NotNull
    public final ABGRColor copy(int value) {
        return new ABGRColor(value);
    }

    public static /* synthetic */ ABGRColor copy$default(ABGRColor aBGRColor, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = aBGRColor.value;
        }
        return aBGRColor.copy(n);
    }

    @NotNull
    public String toString() {
        return "ABGRColor(value=" + this.value + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ABGRColor)) {
            return false;
        }
        ABGRColor aBGRColor = (ABGRColor)other;
        return this.value == aBGRColor.value;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\n\u001a\u00020\u0006*\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000f\u001a\u00020\t*\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u000f\u001a\u00020\u0011*\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0012J\u001f\u0010\u000f\u001a\u00020\u0013*\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0014J\u001c\u0010\u0016\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\rH\u0086\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0019\u0010\u001d\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001c\u001a\u00020\r\u00a2\u0006\u0004\b\u001d\u0010\u001aJ%\u0010 \u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\r\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\"\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b&\u0010#\u001a\u0004\b'\u0010%R\u0017\u0010(\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b(\u0010#\u001a\u0004\b)\u0010%\u00a8\u0006*"}, d2={"Lru/casperix/map_improvements/types/ABGRColor$Companion;", "", "<init>", "()V", "", "abgr", "Lru/casperix/map_improvements/types/ABGRColor;", "of", "(I)Lru/casperix/map_improvements/types/ABGRColor;", "Lru/casperix/math/vector/float32/Vector4f;", "toRGBA", "(Lru/casperix/math/vector/float32/Vector4f;)Lru/casperix/map_improvements/types/ABGRColor;", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "range", "coerceIn", "(Lru/casperix/math/vector/float32/Vector4f;Lkotlin/ranges/ClosedFloatingPointRange;)Lru/casperix/math/vector/float32/Vector4f;", "Lru/casperix/math/vector/float32/Vector3f;", "(Lru/casperix/math/vector/float32/Vector3f;Lkotlin/ranges/ClosedFloatingPointRange;)Lru/casperix/math/vector/float32/Vector3f;", "Lru/casperix/math/color/rgba/RgbaColor4f;", "(Lru/casperix/math/color/rgba/RgbaColor4f;Lkotlin/ranges/ClosedFloatingPointRange;)Lru/casperix/math/color/rgba/RgbaColor4f;", "factor", "times", "(Lru/casperix/math/color/rgba/RgbaColor4f;F)Lru/casperix/math/color/rgba/RgbaColor4f;", "color", "mulRGBA", "(Lru/casperix/map_improvements/types/ABGRColor;F)Lru/casperix/map_improvements/types/ABGRColor;", "mulAlpha", "alpha", "withAlpha", "background", "foreground", "blendRGB", "(Lru/casperix/map_improvements/types/ABGRColor;Lru/casperix/map_improvements/types/ABGRColor;F)Lru/casperix/map_improvements/types/ABGRColor;", "WHITE", "Lru/casperix/map_improvements/types/ABGRColor;", "getWHITE", "()Lru/casperix/map_improvements/types/ABGRColor;", "BLACK", "getBLACK", "EMPTY", "getEMPTY", "map_improvements-mc1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ABGRColor getWHITE() {
            return WHITE;
        }

        @NotNull
        public final ABGRColor getBLACK() {
            return BLACK;
        }

        @NotNull
        public final ABGRColor getEMPTY() {
            return EMPTY;
        }

        @JvmName(name="of")
        @NotNull
        public final ABGRColor of(int abgr) {
            return new ABGRColor(abgr);
        }

        @NotNull
        public final ABGRColor toRGBA(@NotNull Vector4f $this$toRGBA) {
            Intrinsics.checkNotNullParameter((Object)$this$toRGBA, (String)"<this>");
            return new ABGRColor((int)($this$toRGBA.getX().floatValue() * (float)255), (int)($this$toRGBA.getY().floatValue() * (float)255), (int)($this$toRGBA.getZ().floatValue() * (float)255), (int)($this$toRGBA.getW().floatValue() * (float)255));
        }

        @NotNull
        public final Vector4f coerceIn(@NotNull Vector4f $this$coerceIn, @NotNull ClosedFloatingPointRange<Float> range) {
            Intrinsics.checkNotNullParameter((Object)$this$coerceIn, (String)"<this>");
            Intrinsics.checkNotNullParameter(range, (String)"range");
            return new Vector4f(((Number)((Object)RangesKt.coerceIn((Comparable)$this$coerceIn.getX(), range))).floatValue(), ((Number)((Object)RangesKt.coerceIn((Comparable)$this$coerceIn.getY(), range))).floatValue(), ((Number)((Object)RangesKt.coerceIn((Comparable)$this$coerceIn.getZ(), range))).floatValue(), ((Number)((Object)RangesKt.coerceIn((Comparable)$this$coerceIn.getW(), range))).floatValue());
        }

        @NotNull
        public final Vector3f coerceIn(@NotNull Vector3f $this$coerceIn, @NotNull ClosedFloatingPointRange<Float> range) {
            Intrinsics.checkNotNullParameter((Object)$this$coerceIn, (String)"<this>");
            Intrinsics.checkNotNullParameter(range, (String)"range");
            return new Vector3f(((Number)((Object)RangesKt.coerceIn((Comparable)$this$coerceIn.getX(), range))).floatValue(), ((Number)((Object)RangesKt.coerceIn((Comparable)$this$coerceIn.getY(), range))).floatValue(), ((Number)((Object)RangesKt.coerceIn((Comparable)$this$coerceIn.getZ(), range))).floatValue());
        }

        @NotNull
        public final RgbaColor4f coerceIn(@NotNull RgbaColor4f $this$coerceIn, @NotNull ClosedFloatingPointRange<Float> range) {
            Intrinsics.checkNotNullParameter((Object)$this$coerceIn, (String)"<this>");
            Intrinsics.checkNotNullParameter(range, (String)"range");
            return new RgbaColor4f(((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf($this$coerceIn.getRed()), range))).floatValue(), ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf($this$coerceIn.getGreen()), range))).floatValue(), ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf($this$coerceIn.getBlue()), range))).floatValue(), ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf($this$coerceIn.getAlpha()), range))).floatValue());
        }

        @NotNull
        public final RgbaColor4f times(@NotNull RgbaColor4f $this$times, float factor) {
            Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
            return new RgbaColor4f($this$times.getRed() * factor, $this$times.getGreen() * factor, $this$times.getBlue() * factor, $this$times.getAlpha() * factor);
        }

        @NotNull
        public final ABGRColor mulRGBA(@NotNull ABGRColor color, float factor) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            Vector4f source = color.toVector4f();
            return this.toRGBA(this.coerceIn(source.times(factor), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.0f, (float)1.0f)));
        }

        @NotNull
        public final ABGRColor mulAlpha(@NotNull ABGRColor color, float factor) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            Vector4f source = color.toVector4f();
            Vector4f result = Vector4f.copy$default((Vector4f)source, (float)0.0f, (float)0.0f, (float)0.0f, (float)(source.getW().floatValue() * factor), (int)7, null);
            return this.toRGBA(this.coerceIn(result, (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.0f, (float)1.0f)));
        }

        @NotNull
        public final ABGRColor withAlpha(@NotNull ABGRColor $this$withAlpha, float alpha) {
            Intrinsics.checkNotNullParameter((Object)$this$withAlpha, (String)"<this>");
            return new ABGRColor($this$withAlpha.getR(), $this$withAlpha.getG(), $this$withAlpha.getB(), MathKt.roundToInt((float)(alpha * (float)255)));
        }

        @NotNull
        public final ABGRColor blendRGB(@NotNull ABGRColor background, @NotNull ABGRColor foreground, float alpha) {
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
            Vector3f backgroundRGB = background.toVector4f().getXYZ();
            Vector3f foregroundRGB = foreground.toVector4f().getXYZ();
            float foregroundWeight = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(alpha), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
            float backgroundWeight = 1.0f - foregroundWeight;
            return this.toRGBA(this.coerceIn(foregroundRGB.times(foregroundWeight).plus(backgroundRGB.times(backgroundWeight)), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.0f, (float)1.0f)).expand(alpha));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

