/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.composite.effect;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import ru.casperix.map_improvements.MinecraftBlockAnalyze;
import ru.casperix.map_improvements.composite.ColumnBlock;
import ru.casperix.map_improvements.composite.RGBAMapDrawerContext;
import ru.casperix.map_improvements.composite.effect.SurfaceColorEffect;
import ru.casperix.map_improvements.config.BlockRenderConfig;
import ru.casperix.map_improvements.config.TerrainShadingConfig;
import ru.casperix.map_improvements.types.ABGRColor;
import ru.casperix.map_improvements.types.TypeExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lru/casperix/map_improvements/composite/effect/AddTransparentColor;", "Lru/casperix/map_improvements/composite/effect/SurfaceColorEffect;", "Lru/casperix/map_improvements/config/TerrainShadingConfig;", "terrainShading", "Lru/casperix/map_improvements/config/BlockRenderConfig;", "blockRenderConfig", "<init>", "(Lru/casperix/map_improvements/config/TerrainShadingConfig;Lru/casperix/map_improvements/config/BlockRenderConfig;)V", "Lru/casperix/map_improvements/composite/RGBAMapDrawerContext;", "context", "Lru/casperix/map_improvements/types/ABGRColor;", "source", "calculate", "(Lru/casperix/map_improvements/composite/RGBAMapDrawerContext;Lru/casperix/map_improvements/types/ABGRColor;)Lru/casperix/map_improvements/types/ABGRColor;", "Lnet/minecraft/class_2680;", "blockState", "", "getAlpha", "(Lnet/minecraft/class_2680;)F", "Lru/casperix/map_improvements/config/BlockRenderConfig;", "getBlockRenderConfig", "()Lru/casperix/map_improvements/config/BlockRenderConfig;", "map_improvements-mc1.21.1"})
public final class AddTransparentColor
extends SurfaceColorEffect {
    @NotNull
    private final BlockRenderConfig blockRenderConfig;

    public AddTransparentColor(@NotNull TerrainShadingConfig terrainShading, @NotNull BlockRenderConfig blockRenderConfig) {
        Intrinsics.checkNotNullParameter((Object)terrainShading, (String)"terrainShading");
        Intrinsics.checkNotNullParameter((Object)blockRenderConfig, (String)"blockRenderConfig");
        super(terrainShading);
        this.blockRenderConfig = blockRenderConfig;
    }

    @NotNull
    public final BlockRenderConfig getBlockRenderConfig() {
        return this.blockRenderConfig;
    }

    @Override
    @NotNull
    public ABGRColor calculate(@NotNull RGBAMapDrawerContext context, @NotNull ABGRColor source) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        RGBAMapDrawerContext $this$calculate_u24lambda_u240 = context;
        boolean bl = false;
        if ($this$calculate_u24lambda_u240.getColumn().getTransparentList().isEmpty()) {
            return source;
        }
        ColumnBlock topBlock = (ColumnBlock)CollectionsKt.first($this$calculate_u24lambda_u240.getColumn().getTransparentList());
        float depthFactor = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf((float)(topBlock.getHeight() - 1 - $this$calculate_u24lambda_u240.getColumn().getSolid().getHeight()) / (float)this.blockRenderConfig.getMaxTranslucentDepth()), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        ABGRColor originalBlockColor = this.calculateColor($this$calculate_u24lambda_u240.getColumn().getWorldPos(), topBlock, $this$calculate_u24lambda_u240.getTransparentOrSolidHeightMap());
        ABGRColor blockColor = ABGRColor.Companion.blendRGB(originalBlockColor, ABGRColor.Companion.getBLACK(), depthFactor * (float)this.blockRenderConfig.getMaxDarkeningIntensity());
        float baseAlpha = this.getAlpha(topBlock.getState());
        float targetAlpha = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(baseAlpha * (1.0f - depthFactor) + (float)this.blockRenderConfig.getMaxDarkeningAlpha() * depthFactor), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        ABGRColor targetColor = ABGRColor.Companion.blendRGB(source, blockColor, targetAlpha);
        return ABGRColor.Companion.withAlpha(targetColor, 1.0f);
    }

    public final float getAlpha(@NotNull class_2680 blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        String string = TypeExtensionsKt.identifier(blockState).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String name = string;
        Double customAlpha = this.blockRenderConfig.getBlockAlphaMap().get(name);
        if (customAlpha != null) {
            return (float)customAlpha.doubleValue();
        }
        if (MinecraftBlockAnalyze.INSTANCE.isLiquid(blockState)) {
            return (float)this.blockRenderConfig.getLiquidAlpha();
        }
        if (MinecraftBlockAnalyze.INSTANCE.isLeaves(blockState)) {
            return (float)this.blockRenderConfig.getLeavesAlpha();
        }
        if (MinecraftBlockAnalyze.INSTANCE.isFlowers(blockState)) {
            return (float)this.blockRenderConfig.getFlowersAlpha();
        }
        if (MinecraftBlockAnalyze.INSTANCE.isGrass(blockState)) {
            return (float)this.blockRenderConfig.getGrassAlpha();
        }
        return (float)this.blockRenderConfig.getDefaultAlpha();
    }
}

