/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.composite.effect;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_3620;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.casperix.map_improvements.VanillaColorConverter;
import ru.casperix.map_improvements.composite.ColumnBlock;
import ru.casperix.map_improvements.composite.LightShadingFactory;
import ru.casperix.map_improvements.composite.effect.MapColorEffect;
import ru.casperix.map_improvements.config.TerrainShadingConfig;
import ru.casperix.map_improvements.types.ABGRColor;
import ru.casperix.math.vector.int32.Vector2i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u00002\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J1\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ3\u0010\u0011\u001a\u00020\r2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lru/casperix/map_improvements/composite/effect/SurfaceColorEffect;", "Lru/casperix/map_improvements/composite/effect/MapColorEffect;", "Lru/casperix/map_improvements/config/TerrainShadingConfig;", "config", "<init>", "(Lru/casperix/map_improvements/config/TerrainShadingConfig;)V", "Lru/casperix/math/vector/int32/Vector2i;", "worldPos", "Lru/casperix/map_improvements/composite/ColumnBlock;", "block", "", "", "heightMap", "Lru/casperix/map_improvements/types/ABGRColor;", "calculateColor", "(Lru/casperix/math/vector/int32/Vector2i;Lru/casperix/map_improvements/composite/ColumnBlock;Ljava/util/Map;)Lru/casperix/map_improvements/types/ABGRColor;", "baseColor", "applyShading", "(Ljava/util/Map;Lru/casperix/map_improvements/types/ABGRColor;Lru/casperix/math/vector/int32/Vector2i;)Lru/casperix/map_improvements/types/ABGRColor;", "Lru/casperix/map_improvements/config/TerrainShadingConfig;", "getConfig", "()Lru/casperix/map_improvements/config/TerrainShadingConfig;", "UNKNOWN_SOLID_COLOR", "Lru/casperix/map_improvements/types/ABGRColor;", "getUNKNOWN_SOLID_COLOR", "()Lru/casperix/map_improvements/types/ABGRColor;", "Config", "map_improvements-mc1.21.1"})
public abstract class SurfaceColorEffect
implements MapColorEffect {
    @NotNull
    private final TerrainShadingConfig config;
    @NotNull
    private final ABGRColor UNKNOWN_SOLID_COLOR;

    public SurfaceColorEffect(@NotNull TerrainShadingConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.UNKNOWN_SOLID_COLOR = new ABGRColor(255, 0, 255, 255);
    }

    @NotNull
    public final TerrainShadingConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final ABGRColor getUNKNOWN_SOLID_COLOR() {
        return this.UNKNOWN_SOLID_COLOR;
    }

    @NotNull
    public final ABGRColor calculateColor(@NotNull Vector2i worldPos, @NotNull ColumnBlock block, @NotNull Map<Vector2i, Integer> heightMap) {
        ABGRColor baseColor;
        Intrinsics.checkNotNullParameter((Object)worldPos, (String)"worldPos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(heightMap, (String)"heightMap");
        class_3620 mapColor = block.getState().field_23171;
        Intrinsics.checkNotNull((Object)mapColor);
        ABGRColor aBGRColor = VanillaColorConverter.INSTANCE.mapColorToRgba(mapColor);
        if (aBGRColor == null) {
            aBGRColor = baseColor = this.UNKNOWN_SOLID_COLOR;
        }
        if (!this.config.getEnabled()) {
            return baseColor;
        }
        ABGRColor targetRgba = this.applyShading(heightMap, baseColor, worldPos);
        return targetRgba;
    }

    private final ABGRColor applyShading(Map<Vector2i, Integer> heightMap, ABGRColor baseColor, Vector2i worldPos) {
        float lightFactor = LightShadingFactory.INSTANCE.getDirectionalShading(worldPos, 1, this.config.getMaxHeightDifference(), heightMap);
        ClosedFloatingPointRange lightRange = RangesKt.rangeTo((float)(1.0f - this.config.getContrast()), (float)(1.0f + this.config.getContrast()));
        float lightNormalized = (lightFactor + 1.0f) * 0.5f;
        float multiplier = lightNormalized * (((Number)((Object)lightRange.getEndInclusive())).floatValue() - ((Number)((Object)lightRange.getStart())).floatValue()) + ((Number)((Object)lightRange.getStart())).floatValue();
        return ABGRColor.Companion.withAlpha(ABGRColor.Companion.mulRGBA(baseColor, ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(multiplier), (ClosedFloatingPointRange)lightRange))).floatValue()), (float)baseColor.getA() / 255.0f);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\fJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0011\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001c\u0010\fR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001b\u001a\u0004\b\u001d\u0010\f\u00a8\u0006\u001e"}, d2={"Lru/casperix/map_improvements/composite/effect/SurfaceColorEffect$Config;", "", "", "shading", "", "maxHeightDiff", "contrast", "<init>", "(ZFF)V", "component1", "()Z", "component2", "()F", "component3", "copy", "(ZFF)Lru/casperix/map_improvements/composite/effect/SurfaceColorEffect$Config;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Z", "getShading", "F", "getMaxHeightDiff", "getContrast", "map_improvements-mc1.21.1"})
    public static final class Config {
        private final boolean shading;
        private final float maxHeightDiff;
        private final float contrast;

        public Config(boolean shading, float maxHeightDiff, float contrast) {
            this.shading = shading;
            this.maxHeightDiff = maxHeightDiff;
            this.contrast = contrast;
        }

        public /* synthetic */ Config(boolean bl, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                f = 6.0f;
            }
            if ((n & 4) != 0) {
                f2 = 0.8f;
            }
            this(bl, f, f2);
        }

        public final boolean getShading() {
            return this.shading;
        }

        public final float getMaxHeightDiff() {
            return this.maxHeightDiff;
        }

        public final float getContrast() {
            return this.contrast;
        }

        public final boolean component1() {
            return this.shading;
        }

        public final float component2() {
            return this.maxHeightDiff;
        }

        public final float component3() {
            return this.contrast;
        }

        @NotNull
        public final Config copy(boolean shading, float maxHeightDiff, float contrast) {
            return new Config(shading, maxHeightDiff, contrast);
        }

        public static /* synthetic */ Config copy$default(Config config, boolean bl, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = config.shading;
            }
            if ((n & 2) != 0) {
                f = config.maxHeightDiff;
            }
            if ((n & 4) != 0) {
                f2 = config.contrast;
            }
            return config.copy(bl, f, f2);
        }

        @NotNull
        public String toString() {
            return "Config(shading=" + this.shading + ", maxHeightDiff=" + this.maxHeightDiff + ", contrast=" + this.contrast + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.shading);
            result = result * 31 + Float.hashCode(this.maxHeightDiff);
            result = result * 31 + Float.hashCode(this.contrast);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            if (this.shading != config.shading) {
                return false;
            }
            if (Float.compare(this.maxHeightDiff, config.maxHeightDiff) != 0) {
                return false;
            }
            return Float.compare(this.contrast, config.contrast) == 0;
        }

        public Config() {
            this(false, 0.0f, 0.0f, 7, null);
        }
    }
}

