/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.map_improvements.misc;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;
import ru.casperix.map_improvements.types.ABGRColor;
import ru.casperix.math.array.ArrayAccessND;
import ru.casperix.math.vector.int32.Vector2i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u0010J\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\f\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lru/casperix/map_improvements/misc/PixelMap;", "", "Lru/casperix/math/vector/int32/Vector2i;", "size", "<init>", "(Lru/casperix/math/vector/int32/Vector2i;)V", "position", "Lru/casperix/map_improvements/types/ABGRColor;", "argb", "", "setColor", "(Lru/casperix/math/vector/int32/Vector2i;Lru/casperix/map_improvements/types/ABGRColor;)V", "getColor", "(Lru/casperix/math/vector/int32/Vector2i;)Lru/casperix/map_improvements/types/ABGRColor;", "", "index", "(ILru/casperix/map_improvements/types/ABGRColor;)V", "(I)Lru/casperix/map_improvements/types/ABGRColor;", "Lru/casperix/math/vector/int32/Vector2i;", "getSize", "()Lru/casperix/math/vector/int32/Vector2i;", "Ljava/nio/ByteBuffer;", "byteBuffer", "Ljava/nio/ByteBuffer;", "getByteBuffer", "()Ljava/nio/ByteBuffer;", "Ljava/nio/IntBuffer;", "intView", "Ljava/nio/IntBuffer;", "getIntView", "()Ljava/nio/IntBuffer;", "map_improvements-mc1.21.1"})
public final class PixelMap {
    @NotNull
    private final Vector2i size;
    @NotNull
    private final ByteBuffer byteBuffer;
    @NotNull
    private final IntBuffer intView;

    public PixelMap(@NotNull Vector2i size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.size = size;
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(4 * this.size.volume()));
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"memAlloc(...)");
        this.byteBuffer = byteBuffer;
        IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"asIntBuffer(...)");
        this.intView = intBuffer;
    }

    @NotNull
    public final Vector2i getSize() {
        return this.size;
    }

    @NotNull
    public final ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @NotNull
    public final IntBuffer getIntView() {
        return this.intView;
    }

    @JvmName(name="setColor")
    public final void setColor(@NotNull Vector2i position, @NotNull ABGRColor argb) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)argb, (String)"argb");
        int index = ArrayAccessND.INSTANCE.index2D(this.size, position);
        this.setColor(index, argb);
    }

    @JvmName(name="getColor")
    @NotNull
    public final ABGRColor getColor(@NotNull Vector2i position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        int index = ArrayAccessND.INSTANCE.index2D(this.size, position);
        return this.getColor(index);
    }

    @JvmName(name="setColor")
    public final void setColor(int index, @NotNull ABGRColor argb) {
        Intrinsics.checkNotNullParameter((Object)argb, (String)"argb");
        this.intView.put(index, argb.getValue());
    }

    @JvmName(name="getColor")
    @NotNull
    public final ABGRColor getColor(int index) {
        return new ABGRColor(this.intView.get(index));
    }
}

