/*
 * Decompiled with CFR 0.152.
 */
package ru.casperix.mixin;

import java.nio.ByteBuffer;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.casperix.RGBAMapFeature;
import ru.casperix.map_improvements.LoggerKt;
import ru.casperix.map_improvements.MinecraftExtension;
import ru.casperix.map_improvements.codec.MapDTOCodec;
import ru.casperix.map_improvements.types.MapDTO;

@Mixin(value={class_22.class})
public abstract class MapStateVersionSpecific
implements RGBAMapFeature {
    @Unique
    private static Logger logger = LoggerKt.getLogger();

    @Inject(method={"method_75(Lnet/minecraft/class_2487;Lnet/minecraft/class_7225$class_7874;)Lnet/minecraft/class_2487;"}, at={@At(value="HEAD")})
    public void saveToNbt(class_2487 nbt, class_7225.class_7874 registryLookup, CallbackInfoReturnable<class_2487> cir) {
        try {
            MapDTO dto = this.mi_getMapDto();
            byte[] bytes = MapDTOCodec.INSTANCE.encode(dto);
            nbt.method_10570("MapImprovements_MapDTO", bytes);
        }
        catch (Throwable t) {
            logger.warn("Can't save map", t);
        }
    }

    @Inject(method={"method_32371(Lnet/minecraft/class_2487;Lnet/minecraft/class_7225$class_7874;)Lnet/minecraft/class_22;"}, at={@At(value="RETURN")})
    private static void loadFromNbt(class_2487 nbt, class_7225.class_7874 registryLookup, CallbackInfoReturnable<class_22> cir) {
        class_22 mapData = (class_22)cir.getReturnValue();
        if (!(mapData instanceof RGBAMapFeature)) {
            return;
        }
        RGBAMapFeature rgbaMapData = (RGBAMapFeature)mapData;
        if (!nbt.method_10545("MapImprovements_MapDTO")) {
            return;
        }
        try {
            byte[] bytes = MinecraftExtension.INSTANCE.getByteArrayFromTag(nbt, "MapImprovements_MapDTO");
            MapDTO dto = MapDTOCodec.INSTANCE.decode(ByteBuffer.wrap(bytes));
            rgbaMapData.mi_setMapDto(dto);
        }
        catch (Throwable t) {
            logger.warn("Can't load map", t);
        }
    }
}

