/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.util;

import com.belgie.copper_age_plus.core.BlockRegistry;
import com.belgie.copper_age_plus.core.ItemRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ModEvents {
    public static void onItemTick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos blockpos = event.getPos();
        BlockState blockstate = level.getBlockState(blockpos);
        if (event.getItemStack().is(ItemRegistry.COPPER_DUST) && (blockstate.getBlock() instanceof SoulFireBlock || blockstate.getBlock() instanceof FireBlock && !((Boolean)blockstate.getValue((Property)FireBlock.NORTH)).booleanValue() && !((Boolean)blockstate.getValue((Property)FireBlock.EAST)).booleanValue() && !((Boolean)blockstate.getValue((Property)FireBlock.WEST)).booleanValue() && !((Boolean)blockstate.getValue((Property)FireBlock.SOUTH)).booleanValue() && !((Boolean)blockstate.getValue((Property)FireBlock.UP)).booleanValue())) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverplayer, blockpos, event.getItemStack());
            }
            event.getItemStack().consume(1, (LivingEntity)player);
            player.swing(player.getUsedItemHand());
            level.setBlock(blockpos, ((Block)BlockRegistry.GREEN_FIRE.get()).defaultBlockState(), 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
            level.levelEvent((Entity)player, 3003, blockpos, 0);
        }
    }

    public static void onBrushTick(LivingEntityUseItemEvent.Tick event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        ItemStack stack = event.getItem();
        if (!stack.is(Items.BRUSH)) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (level.isClientSide()) {
            return;
        }
        if (event.getDuration() == event.getItem().getUseDuration((LivingEntity)player) - 60) {
            HitResult hit = player.pick(5.0, 0.0f, false);
            if (!(hit instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult blockHit = (BlockHitResult)hit;
            BlockPos pos = blockHit.getBlockPos();
            BlockState state = level.getBlockState(pos);
            if (state.getBlock() instanceof WeatheringCopper) {
                WeatheringCopper.getPrevious((BlockState)state).ifPresent(previous -> {
                    level.setBlockAndUpdate(pos, previous);
                    level.playSound(null, pos, SoundEvents.BRUSH_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.levelEvent(3005, pos, 0);
                    ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.325, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.325, new ItemStack((ItemLike)ItemRegistry.COPPER_DUST.get(), 2));
                    itementity.setDeltaMovement(0.05 + level.random.nextDouble() * 0.02, 0.05, 0.05 + level.random.nextDouble() * 0.02);
                    level.addFreshEntity((Entity)itementity);
                    stack.hurtAndBreak(4, (LivingEntity)player, EquipmentSlot.MAINHAND);
                });
            }
        }
    }
}

