/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.blockentities;

import com.belgie.copper_age_plus.common.blocks.CopperCampfireBlock;
import com.belgie.copper_age_plus.core.BlockEntityRegistry;
import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public class CopperCampfireBlockEntity
extends BlockEntity
implements Clearable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final int[] cookingProgress = new int[4];
    private final int[] cookingTime = new int[4];

    public CopperCampfireBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityRegistry.COPPER_CAMPFIRE.get(), pos, blockState);
    }

    public static void cookTick(ServerLevel level, BlockPos pos, BlockState state, CopperCampfireBlockEntity campfire, RecipeManager.CachedCheck<SingleRecipeInput, BlastingRecipe> check) {
        boolean flag = false;
        for (int i = 0; i < campfire.items.size(); ++i) {
            SingleRecipeInput singlerecipeinput;
            ItemStack itemstack1;
            ItemStack itemstack = (ItemStack)campfire.items.get(i);
            if (itemstack.isEmpty()) continue;
            flag = true;
            int n = i;
            campfire.cookingProgress[n] = campfire.cookingProgress[n] + 1;
            if (campfire.cookingProgress[i] < campfire.cookingTime[i] || !(itemstack1 = check.getRecipeFor((RecipeInput)(singlerecipeinput = new SingleRecipeInput(itemstack)), level).map(p_425492_ -> ((BlastingRecipe)p_425492_.value()).assemble(singlerecipeinput, (HolderLookup.Provider)level.registryAccess())).orElse(itemstack)).isItemEnabled(level.enabledFeatures())) continue;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemstack1);
            campfire.items.set(i, (Object)ItemStack.EMPTY);
            level.sendBlockUpdated(pos, state, state, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        }
        if (flag) {
            CopperCampfireBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void cooldownTick(Level level, BlockPos pos, BlockState state, CopperCampfireBlockEntity blockEntity) {
        boolean flag = false;
        for (int i = 0; i < blockEntity.items.size(); ++i) {
            if (blockEntity.cookingProgress[i] <= 0) continue;
            flag = true;
            blockEntity.cookingProgress[i] = Mth.clamp((int)(blockEntity.cookingProgress[i] - 2), (int)0, (int)blockEntity.cookingTime[i]);
        }
        if (flag) {
            CopperCampfireBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, CopperCampfireBlockEntity blockEntity) {
        int l;
        RandomSource randomsource = level.random;
        if (randomsource.nextFloat() < 0.11f) {
            for (l = 0; l < randomsource.nextInt(2) + 2; ++l) {
                CopperCampfireBlock.makeParticles(level, pos, (Boolean)state.getValue((Property)CopperCampfireBlock.SIGNAL_FIRE), false);
            }
        }
        l = ((Direction)state.getValue(CopperCampfireBlock.FACING)).get2DDataValue();
        for (int j = 0; j < blockEntity.items.size(); ++j) {
            if (((ItemStack)blockEntity.items.get(j)).isEmpty() || !(randomsource.nextFloat() < 0.2f)) continue;
            Direction direction = Direction.from2DDataValue((int)Math.floorMod(j + l, 4));
            float f = 0.3125f;
            double d0 = (double)pos.getX() + 0.5 - (double)((float)direction.getStepX() * 0.3125f) + (double)((float)direction.getClockWise().getStepX() * 0.3125f);
            double d1 = (double)pos.getY() + 0.5;
            double d2 = (double)pos.getZ() + 0.5 - (double)((float)direction.getStepZ() * 0.3125f) + (double)((float)direction.getClockWise().getStepZ() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void loadAdditional(ValueInput p_421552_) {
        super.loadAdditional(p_421552_);
        this.items.clear();
        ContainerHelper.loadAllItems((ValueInput)p_421552_, this.items);
        p_421552_.getIntArray("CookingTimes").ifPresentOrElse(p_409480_ -> System.arraycopy(p_409480_, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, ((int[])p_409480_).length)), () -> Arrays.fill(this.cookingProgress, 0));
        p_421552_.getIntArray("CookingTotalTimes").ifPresentOrElse(p_409481_ -> System.arraycopy(p_409481_, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, ((int[])p_409481_).length)), () -> Arrays.fill(this.cookingTime, 0));
    }

    protected void saveAdditional(ValueOutput p_422604_) {
        super.saveAdditional(p_422604_);
        ContainerHelper.saveAllItems((ValueOutput)p_422604_, this.items, (boolean)true);
        p_422604_.putIntArray("CookingTimes", this.cookingProgress);
        p_422604_.putIntArray("CookingTotalTimes", this.cookingTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_324612_) {
        CompoundTag compoundtag;
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            TagValueOutput tagvalueoutput = TagValueOutput.createWithContext((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)p_324612_);
            ContainerHelper.saveAllItems((ValueOutput)tagvalueoutput, this.items, (boolean)true);
            compoundtag = tagvalueoutput.buildResult();
        }
        return compoundtag;
    }

    public boolean placeFood(ServerLevel level, @Nullable LivingEntity entity, ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.isEmpty()) continue;
            Optional optional = level.recipeAccess().getRecipeFor(RecipeType.BLASTING, (RecipeInput)new SingleRecipeInput(stack), (Level)level);
            if (optional.isEmpty()) {
                return false;
            }
            this.cookingTime[i] = ((BlastingRecipe)((RecipeHolder)optional.get()).value()).cookingTime() + 300;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)stack.consumeAndReturn(1, entity));
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void clearContent() {
        this.items.clear();
    }

    public void preRemoveSideEffects(BlockPos p_394031_, BlockState p_394253_) {
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)p_394031_, this.getItems());
        }
    }

    protected void applyImplicitComponents(DataComponentGetter p_397891_) {
        super.applyImplicitComponents(p_397891_);
        ((ItemContainerContents)p_397891_.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder p_338620_) {
        super.collectImplicitComponents(p_338620_);
        p_338620_.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
    }

    public void removeComponentsFromTag(ValueOutput p_422231_) {
        p_422231_.discard("Items");
    }
}

