/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.blockentities;

import com.belgie.copper_age_plus.common.blocks.FilterBlock;
import com.belgie.copper_age_plus.core.BlockEntityRegistry;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.ticks.ContainerSingleItem;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.item.ContainerOrHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaInventoryCodeHooks;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class FilterBlockEntity
extends BlockEntity
implements RandomizableContainer,
ContainerSingleItem.BlockContainerSingleItem {
    private ItemStack item = ItemStack.EMPTY;
    public ItemStack filterItem = ItemStack.EMPTY;
    @Nullable
    protected ResourceKey<LootTable> lootTable;
    protected long lootTableSeed;
    private static final int[][] CACHED_SLOTS = new int[54][];

    public FilterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.FILTER.get(), pos, state);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.filterItem);
    }

    protected void saveAdditional(ValueOutput p_421506_) {
        super.saveAdditional(p_421506_);
        if (!this.trySaveLootTable(p_421506_) && !this.item.isEmpty()) {
            p_421506_.store("item", ItemStack.CODEC, (Object)this.item);
        }
        if (!this.filterItem.isEmpty()) {
            p_421506_.store("filter_item", ItemStack.CODEC, (Object)this.filterItem);
        }
    }

    protected void loadAdditional(ValueInput p_421562_) {
        super.loadAdditional(p_421562_);
        this.item = !this.tryLoadLootTable(p_421562_) ? p_421562_.read("item", ItemStack.CODEC).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        this.filterItem = p_421562_.read("filter_item", ItemStack.CODEC).orElse(ItemStack.EMPTY);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_324359_) {
        return this.saveCustomOnly(p_324359_);
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> p_336080_) {
        this.lootTable = p_336080_;
    }

    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setLootTableSeed(long p_309580_) {
        this.lootTableSeed = p_309580_;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder p_338608_) {
        super.collectImplicitComponents(p_338608_);
        p_338608_.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(List.of(this.item)));
    }

    protected void applyImplicitComponents(DataComponentGetter p_397357_) {
        super.applyImplicitComponents(p_397357_);
        this.item = ((ItemContainerContents)p_397357_.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyOne();
    }

    public void removeComponentsFromTag(ValueOutput p_421737_) {
        super.removeComponentsFromTag(p_421737_);
        p_421737_.discard("item");
    }

    public ItemStack getTheItem() {
        this.unpackLootTable(null);
        return this.item;
    }

    public ItemStack getFilterItem() {
        return this.filterItem;
    }

    public void setFilterItem(ItemStack p_305817_) {
        this.filterItem = p_305817_;
    }

    public ItemStack splitTheItem(int p_305991_) {
        this.unpackLootTable(null);
        ItemStack itemstack = this.item.split(p_305991_);
        if (this.item.isEmpty()) {
            this.item = ItemStack.EMPTY;
        }
        return itemstack;
    }

    public void setTheItem(ItemStack p_305817_) {
        this.unpackLootTable(null);
        this.item = p_305817_;
    }

    public void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public BlockEntity getContainerBlockEntity() {
        return this;
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, FilterBlockEntity blockEntity) {
        FilterBlockEntity.tryMoveItems(level, pos, state, blockEntity, () -> FilterBlockEntity.suckInItems(level, blockEntity));
    }

    private static boolean tryMoveItems(Level level, BlockPos pos, BlockState state, FilterBlockEntity blockEntity, BooleanSupplier validator) {
        if (level.isClientSide()) {
            return false;
        }
        if (state.getBlock() instanceof FilterBlock) {
            boolean flag = false;
            if (!blockEntity.isEmpty()) {
                flag = FilterBlockEntity.ejectItems(level, pos, blockEntity);
            }
            if (!blockEntity.inventoryFull()) {
                flag |= validator.getAsBoolean();
            }
            if (flag) {
                FilterBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
        }
        return false;
    }

    private boolean inventoryFull() {
        return this.item.getCount() == this.item.getMaxStackSize();
    }

    private static boolean ejectItems(Level level, BlockPos pos, FilterBlockEntity blockEntity) {
        ContainerOrHandler containerOrHandler = FilterBlockEntity.getContainerOrHandlerAt(level, pos.relative(Direction.UP), Direction.UP.getOpposite());
        if (containerOrHandler.isEmpty()) {
            return false;
        }
        if (containerOrHandler.container() != null) {
            Direction direction;
            Container container = containerOrHandler.container();
            if (FilterBlockEntity.isFullContainer(container, direction = Direction.UP.getOpposite())) {
                return false;
            }
            for (int i = 0; i < blockEntity.getContainerSize(); ++i) {
                ItemStack itemstack = blockEntity.getItem(i);
                if (itemstack.isEmpty()) continue;
                int j = itemstack.getCount();
                ItemStack itemstack1 = FilterBlockEntity.addItem((Container)blockEntity, container, blockEntity.removeItem(i, 1), direction);
                if (itemstack1.isEmpty()) {
                    container.setChanged();
                    return true;
                }
                itemstack.setCount(j);
                if (j != 1) continue;
                blockEntity.setItem(i, itemstack);
            }
            return false;
        }
        return FilterBlockEntity.insertHook(blockEntity, (ResourceHandler<ItemResource>)containerOrHandler.itemHandler());
    }

    public static boolean insertHook(FilterBlockEntity hopper, ResourceHandler<ItemResource> itemHandler) {
        boolean var8;
        block9: {
            if (ResourceHandlerUtil.isFull(itemHandler)) {
                return false;
            }
            try (Transaction tx = Transaction.open((TransactionContext)null);){
                int size = hopper.getContainerSize();
                for (int i = 0; i < size; ++i) {
                    ItemStack hopperItem = hopper.getItem(i);
                    if (hopperItem.isEmpty()) continue;
                    ItemStack originalSlotContents = hopperItem.copy();
                    ItemStack insertStack = hopper.removeItem(i, 1);
                    if (itemHandler.insert((Resource)ItemResource.of((ItemStack)insertStack), 1, (TransactionContext)tx) == 1) {
                        tx.commit();
                        var8 = true;
                        break block9;
                    }
                    hopper.setItem(i, originalSlotContents);
                }
            }
            return false;
        }
        return var8;
    }

    public static boolean suckInItems(Level level, FilterBlockEntity hopper) {
        BlockState blockstate;
        BlockPos blockpos = BlockPos.containing((double)hopper.getBlockPos().getX(), (double)((double)hopper.getBlockPos().getY() + 1.0), (double)hopper.getBlockPos().getZ());
        ContainerOrHandler containerOrHandler = FilterBlockEntity.getSourceContainerOrHandler(level, hopper, blockpos, blockstate = level.getBlockState(blockpos));
        if (containerOrHandler.container() != null) {
            Container container = containerOrHandler.container();
            Direction direction = Direction.DOWN;
            for (int i : FilterBlockEntity.getSlots(container, direction)) {
                if (!FilterBlockEntity.tryTakeInItemFromSlot(hopper, container, i, direction)) continue;
                return true;
            }
            return false;
        }
        if (containerOrHandler.itemHandler() != null) {
            return FilterBlockEntity.extractHook(hopper, (ResourceHandler<ItemResource>)containerOrHandler.itemHandler());
        }
        return false;
    }

    public static boolean extractHook(FilterBlockEntity dest, ResourceHandler<ItemResource> handler) {
        int size = handler.size();
        block5: for (int index = 0; index < size; ++index) {
            boolean var11;
            ItemResource itemResource = (ItemResource)handler.getResource(index);
            try (Transaction tx = Transaction.open((TransactionContext)null);){
                int extracted = handler.extract(index, (Resource)itemResource, 1, (TransactionContext)tx);
                if (extracted == 0) continue;
                ItemStack extractedStack = itemResource.toStack();
                int destSize = dest.getContainerSize();
                int j = 0;
                while (true) {
                    if (j >= destSize) {
                        continue block5;
                    }
                    ItemStack destStack = dest.getItem(j);
                    if (dest.canPlaceItem(j, extractedStack) && (destStack.isEmpty() || destStack.getCount() < destStack.getMaxStackSize() && destStack.getCount() < dest.getMaxStackSize() && itemResource.matches(destStack))) {
                        if (destStack.isEmpty()) {
                            dest.setItem(j, extractedStack);
                        } else {
                            destStack.grow(1);
                            dest.setItem(j, destStack);
                        }
                        dest.setChanged();
                        tx.commit();
                        var11 = true;
                        break;
                    }
                    ++j;
                }
            }
            return var11;
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(FilterBlockEntity hopper, Container container, int slot, Direction direction) {
        ItemStack itemstack = container.getItem(slot);
        if (!itemstack.isEmpty() && FilterBlockEntity.canTakeItemFromContainer((Container)hopper, container, itemstack, slot, direction)) {
            int i = itemstack.getCount();
            ItemStack itemstack1 = FilterBlockEntity.addItem(container, (Container)hopper, container.removeItem(slot, 1), null);
            if (itemstack1.isEmpty()) {
                container.setChanged();
                return true;
            }
            itemstack.setCount(i);
            if (i == 1) {
                container.setItem(slot, itemstack);
            }
        }
        return false;
    }

    private static boolean canTakeItemFromContainer(Container source, Container destination, ItemStack stack, int slot, Direction direction) {
        boolean var10000;
        if (!destination.canTakeItem(source, slot, stack)) {
            var10000 = false;
        } else {
            WorldlyContainer worldlycontainer;
            if (destination instanceof WorldlyContainer && !(worldlycontainer = (WorldlyContainer)destination).canTakeItemThroughFace(slot, stack, direction)) {
                boolean var100002 = false;
                return var100002;
            }
            var10000 = true;
        }
        return var10000;
    }

    public static boolean addItem(Container container, ItemEntity item) {
        boolean flag = false;
        ItemStack itemstack = item.getItem().copy();
        ItemStack itemstack1 = FilterBlockEntity.addItem(null, container, itemstack, null);
        if (itemstack1.isEmpty()) {
            flag = true;
            item.setItem(ItemStack.EMPTY);
            item.discard();
        } else {
            item.setItem(itemstack1);
        }
        return flag;
    }

    public static ItemStack addItem(@Nullable Container source, Container destination, ItemStack stack, @Nullable Direction direction) {
        if (destination instanceof WorldlyContainer) {
            WorldlyContainer worldlycontainer = (WorldlyContainer)destination;
            if (direction != null) {
                int[] aint = worldlycontainer.getSlotsForFace(direction);
                for (int k = 0; k < aint.length && !stack.isEmpty(); ++k) {
                    stack = FilterBlockEntity.tryMoveInItem(source, destination, stack, aint[k], direction);
                }
                return stack;
            }
        }
        int i = destination.getContainerSize();
        for (int k = 0; k < i && !stack.isEmpty(); ++k) {
            stack = FilterBlockEntity.tryMoveInItem(source, destination, stack, k, direction);
        }
        return stack;
    }

    private static ItemStack tryMoveInItem(@Nullable Container source, Container destination, ItemStack stack, int slot, @Nullable Direction direction) {
        ItemStack itemstack = destination.getItem(slot);
        if (FilterBlockEntity.canPlaceItemInContainer(destination, stack, slot, direction)) {
            boolean flag = false;
            boolean flag1 = destination.isEmpty();
            if (itemstack.isEmpty()) {
                destination.setItem(slot, stack);
                stack = ItemStack.EMPTY;
                flag = true;
            } else if (FilterBlockEntity.canMergeItems(itemstack, stack)) {
                int i = stack.getMaxStackSize() - itemstack.getCount();
                int j = Math.min(stack.getCount(), i);
                stack.shrink(j);
                itemstack.grow(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                if (!flag1 || destination instanceof FilterBlockEntity) {
                    // empty if block
                }
                destination.setChanged();
            }
        }
        return stack;
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        return stack1.getCount() <= stack1.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    private static boolean canPlaceItemInContainer(Container container, ItemStack stack, int slot, @Nullable Direction direction) {
        boolean var10000;
        if (!container.canPlaceItem(slot, stack)) {
            var10000 = false;
        } else {
            WorldlyContainer worldlycontainer;
            if (container instanceof WorldlyContainer && !(worldlycontainer = (WorldlyContainer)container).canPlaceItemThroughFace(slot, stack, direction)) {
                boolean var100002 = false;
                return var100002;
            }
            var10000 = true;
        }
        return var10000;
    }

    private static int[] getSlots(Container container, Direction direction) {
        if (container instanceof WorldlyContainer) {
            WorldlyContainer worldlycontainer = (WorldlyContainer)container;
            return worldlycontainer.getSlotsForFace(direction);
        }
        int i = container.getContainerSize();
        if (i < CACHED_SLOTS.length) {
            int[] aint = CACHED_SLOTS[i];
            if (aint != null) {
                return aint;
            }
            int[] aint1 = FilterBlockEntity.createFlatSlots(i);
            FilterBlockEntity.CACHED_SLOTS[i] = aint1;
            return aint1;
        }
        return FilterBlockEntity.createFlatSlots(i);
    }

    private static ContainerOrHandler getSourceContainerOrHandler(Level p_155597_, FilterBlockEntity p_155598_, BlockPos p_326315_, BlockState p_326093_) {
        return FilterBlockEntity.getContainerOrHandlerAt(p_155597_, p_326315_, p_326093_, p_155598_.getBlockPos().getX(), (double)p_155598_.getBlockPos().getY() + 1.0, p_155598_.getBlockPos().getZ(), Direction.DOWN);
    }

    public static ContainerOrHandler getContainerOrHandlerAt(Level level, BlockPos pos, @Nullable Direction side) {
        return FilterBlockEntity.getContainerOrHandlerAt(level, pos, level.getBlockState(pos), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, side);
    }

    private static int[] createFlatSlots(int size) {
        int[] aint = new int[size];
        int i = 0;
        while (i < aint.length) {
            aint[i] = i++;
        }
        return aint;
    }

    private static boolean isFullContainer(Container container, Direction direction) {
        int[] aint;
        int[] var3 = aint = FilterBlockEntity.getSlots(container, direction);
        int var4 = aint.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            int i = var3[var5];
            ItemStack itemstack = container.getItem(i);
            if (itemstack.getCount() >= itemstack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    private static ContainerOrHandler getContainerOrHandlerAt(Level level, BlockPos pos, BlockState state, double x, double y, double z, @Nullable Direction side) {
        Container container = FilterBlockEntity.getBlockContainer(level, pos, state);
        if (container != null) {
            return new ContainerOrHandler(container, null);
        }
        ResourceHandler blockItemHandler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, pos, state, null, (Object)side);
        if (blockItemHandler != null) {
            return new ContainerOrHandler(null, blockItemHandler);
        }
        return VanillaInventoryCodeHooks.getEntityContainerOrHandler((Level)level, (double)x, (double)y, (double)z, (Direction)side);
    }

    @Nullable
    private static Container getBlockContainer(Level level, BlockPos pos, BlockState state) {
        BlockEntity var5;
        Block block = state.getBlock();
        if (block instanceof WorldlyContainerHolder) {
            return ((WorldlyContainerHolder)block).getContainer(state, (LevelAccessor)level, pos);
        }
        if (state.hasBlockEntity() && (var5 = level.getBlockEntity(pos)) instanceof Container) {
            Container container = (Container)var5;
            if (container instanceof ChestBlockEntity && block instanceof ChestBlock) {
                container = ChestBlock.getContainer((ChestBlock)((ChestBlock)block), (BlockState)state, (Level)level, (BlockPos)pos, (boolean)true);
            }
            return container;
        }
        return null;
    }
}

