/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.blockentities;

import com.belgie.copper_age_plus.common.blocks.TuffGolemStatueBlock;
import com.belgie.copper_age_plus.common.entity.tuffgolem.TuffGolemEntity;
import com.belgie.copper_age_plus.core.BlockEntityRegistry;
import com.belgie.copper_age_plus.core.EntityRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;

public class TuffGolemStatueBlockEntity
extends BlockEntity
implements ItemOwner,
RandomizableContainer,
ContainerSingleItem.BlockContainerSingleItem {
    public static final String TAG_ITEM = "item";
    private ItemStack item = ItemStack.EMPTY;
    @Nullable
    protected ResourceKey<LootTable> lootTable;
    protected long lootTableSeed;

    public TuffGolemStatueBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.TUFF_GOLEM.get(), pos, state);
    }

    protected void saveAdditional(ValueOutput p_421506_) {
        super.saveAdditional(p_421506_);
        if (!this.trySaveLootTable(p_421506_) && !this.item.isEmpty()) {
            p_421506_.store(TAG_ITEM, ItemStack.CODEC, (Object)this.item);
        }
    }

    public void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), (BlockState)this.getBlockState().setValue((Property)TuffGolemStatueBlock.HAS_ITEM, (Comparable)Boolean.valueOf(true)), 3);
    }

    protected void loadAdditional(ValueInput p_421562_) {
        super.loadAdditional(p_421562_);
        this.item = !this.tryLoadLootTable(p_421562_) ? p_421562_.read(TAG_ITEM, ItemStack.CODEC).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_324359_) {
        return this.saveCustomOnly(p_324359_);
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> p_336080_) {
        this.lootTable = p_336080_;
    }

    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setLootTableSeed(long p_309580_) {
        this.lootTableSeed = p_309580_;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder p_338608_) {
        super.collectImplicitComponents(p_338608_);
        p_338608_.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(List.of(this.item)));
    }

    protected void applyImplicitComponents(DataComponentGetter p_397357_) {
        super.applyImplicitComponents(p_397357_);
        this.item = ((ItemContainerContents)p_397357_.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyOne();
    }

    public void removeComponentsFromTag(ValueOutput p_421737_) {
        super.removeComponentsFromTag(p_421737_);
        p_421737_.discard(TAG_ITEM);
    }

    public ItemStack getTheItem() {
        this.unpackLootTable(null);
        return this.item;
    }

    public ItemStack splitTheItem(int p_305991_) {
        this.unpackLootTable(null);
        ItemStack itemstack = this.item.split(p_305991_);
        if (this.item.isEmpty()) {
            this.item = ItemStack.EMPTY;
        }
        return itemstack;
    }

    public void setTheItem(ItemStack p_305817_) {
        this.unpackLootTable(null);
        this.item = p_305817_;
    }

    public BlockEntity getContainerBlockEntity() {
        return this;
    }

    public Level level() {
        return this.level;
    }

    public Vec3 position() {
        return this.getBlockPos().getCenter();
    }

    public float getVisualRotationYInDegrees() {
        return ((Direction)this.getBlockState().getValue(TuffGolemStatueBlock.FACING)).getOpposite().toYRot();
    }

    public void createStatue(TuffGolemEntity p_435939_) {
        this.setComponents(DataComponentMap.builder().addAll(this.components()).set(DataComponents.CUSTOM_NAME, (Object)p_435939_.getCustomName()).build());
        super.setChanged();
    }

    @Nullable
    public TuffGolemEntity removeStatue(BlockState p_435095_) {
        TuffGolemEntity coppergolem = (TuffGolemEntity)EntityRegistry.TUFF_GOLEM.get().create(this.level, EntitySpawnReason.TRIGGERED);
        if (coppergolem != null) {
            coppergolem.setCustomName((Component)this.components().get(DataComponents.CUSTOM_NAME));
            return this.initCopperGolem(p_435095_, coppergolem);
        }
        return null;
    }

    private TuffGolemEntity initCopperGolem(BlockState p_434526_, TuffGolemEntity p_434271_) {
        BlockPos blockpos = this.getBlockPos();
        p_434271_.snapTo(blockpos.getCenter().x, blockpos.getY(), blockpos.getCenter().z, ((Direction)p_434526_.getValue(TuffGolemStatueBlock.FACING)).toYRot(), 0.0f);
        p_434271_.yHeadRot = p_434271_.getYRot();
        p_434271_.yBodyRot = p_434271_.getYRot();
        return p_434271_;
    }
}

