/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.blocks;

import com.belgie.copper_age_plus.common.blockentities.CopperCampfireBlockEntity;
import com.belgie.copper_age_plus.core.BlockEntityRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CopperCampfireBlock
extends CampfireBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty SIGNAL_FIRE = BlockStateProperties.SIGNAL_FIRE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE = Block.column((double)16.0, (double)0.0, (double)7.0);
    private static final VoxelShape SHAPE_VIRTUAL_POST = Block.column((double)4.0, (double)0.0, (double)16.0);
    private final boolean spawnParticles;
    private final int fireDamage;

    public CopperCampfireBlock(boolean spawnParticles, int fireDamage, BlockBehaviour.Properties properties) {
        super(spawnParticles, fireDamage, properties);
        this.spawnParticles = spawnParticles;
        this.fireDamage = fireDamage;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected InteractionResult useItemOn(ItemStack p_316347_, BlockState p_51274_, Level p_51275_, BlockPos p_51276_, Player p_51277_, InteractionHand p_51278_, BlockHitResult p_51279_) {
        BlockEntity var9 = p_51275_.getBlockEntity(p_51276_);
        if (var9 instanceof CopperCampfireBlockEntity) {
            CopperCampfireBlockEntity campfireblockentity = (CopperCampfireBlockEntity)var9;
            ItemStack itemstack = p_51277_.getItemInHand(p_51278_);
            if (p_51275_.recipeAccess().propertySet(RecipePropertySet.BLAST_FURNACE_INPUT).test(itemstack)) {
                ServerLevel serverlevel;
                if (p_51275_ instanceof ServerLevel && campfireblockentity.placeFood(serverlevel = (ServerLevel)p_51275_, (LivingEntity)p_51277_, itemstack)) {
                    p_51277_.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
                    return InteractionResult.SUCCESS_SERVER;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    protected void entityInside(BlockState p_51269_, Level p_51270_, BlockPos p_51271_, Entity p_51272_, InsideBlockEffectApplier p_405507_) {
        if (((Boolean)p_51269_.getValue((Property)LIT)).booleanValue() && p_51272_ instanceof LivingEntity) {
            p_51272_.hurt(p_51270_.damageSources().campfire(), (float)this.fireDamage);
        }
        super.entityInside(p_51269_, p_51270_, p_51271_, p_51272_, p_405507_);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos;
        Level levelaccessor = context.getLevel();
        boolean flag = levelaccessor.getFluidState(blockpos = context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isSmokeSource(levelaccessor.getBlockState(blockpos.below()))))).setValue((Property)LIT, (Comparable)Boolean.valueOf(!flag))).setValue(FACING, (Comparable)context.getHorizontalDirection());
    }

    protected BlockState updateShape(BlockState p_51298_, LevelReader p_374562_, ScheduledTickAccess p_374439_, BlockPos p_51302_, Direction p_51299_, BlockPos p_51303_, BlockState p_51300_, RandomSource p_374147_) {
        if (((Boolean)p_51298_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374439_.scheduleTick(p_51302_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374562_));
        }
        return p_51299_ == Direction.DOWN ? (BlockState)p_51298_.setValue((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isSmokeSource(p_51300_))) : super.updateShape(p_51298_, p_374562_, p_374439_, p_51302_, p_51299_, p_51303_, p_51300_, p_374147_);
    }

    private boolean isSmokeSource(BlockState state) {
        return state.is(Blocks.HAY_BLOCK);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void animateTick(BlockState p_220918_, Level p_220919_, BlockPos p_220920_, RandomSource p_220921_) {
        if (((Boolean)p_220918_.getValue((Property)LIT)).booleanValue() && p_220921_.nextInt(10) == 0) {
            p_220919_.playLocalSound((double)p_220920_.getX() + 0.5, (double)p_220920_.getY() + 0.5, (double)p_220920_.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + p_220921_.nextFloat(), p_220921_.nextFloat() * 0.7f + 0.6f, false);
        }
    }

    public static void dowse(@Nullable Entity entity, LevelAccessor level, BlockPos pos, BlockState state) {
        if (level.isClientSide()) {
            for (int i = 0; i < 20; ++i) {
                CopperCampfireBlock.makeParticles((Level)level, pos, (Boolean)state.getValue((Property)SIGNAL_FIRE), true);
            }
        }
        level.gameEvent(entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidState.getType() == Fluids.WATER) {
            boolean flag = (Boolean)state.getValue((Property)LIT);
            if (flag) {
                if (!level.isClientSide()) {
                    level.playSound((Entity)null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                CopperCampfireBlock.dowse(null, level, pos, state);
            }
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
            return true;
        }
        return false;
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos = hit.getBlockPos();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (projectile.isOnFire() && projectile.mayInteract(serverlevel, blockpos) && !((Boolean)state.getValue((Property)LIT)).booleanValue() && !((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                level.setBlock(blockpos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 11);
            }
        }
    }

    public static void makeParticles(Level level, BlockPos pos, boolean isSignalFire, boolean spawnExtraSmoke) {
        RandomSource randomsource = level.getRandom();
        SimpleParticleType simpleparticletype = isSignalFire ? ParticleTypes.CAMPFIRE_SIGNAL_SMOKE : ParticleTypes.CAMPFIRE_COSY_SMOKE;
        level.addAlwaysVisibleParticle((ParticleOptions)simpleparticletype, true, (double)pos.getX() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)pos.getY() + randomsource.nextDouble() + randomsource.nextDouble(), (double)pos.getZ() + 0.5 + randomsource.nextDouble() / 3.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (spawnExtraSmoke) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, SIGNAL_FIRE, WATERLOGGED, FACING});
    }

    public BlockEntity newBlockEntity(BlockPos p_152759_, BlockState p_152760_) {
        return new CopperCampfireBlockEntity(p_152759_, p_152760_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_152755_, BlockState p_152756_, BlockEntityType<T> p_152757_) {
        if (p_152755_ instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)p_152755_;
            if (((Boolean)p_152756_.getValue((Property)LIT)).booleanValue()) {
                RecipeManager.CachedCheck cachedcheck = RecipeManager.createCheck((RecipeType)RecipeType.BLASTING);
                return CopperCampfireBlock.createTickerHelper(p_152757_, BlockEntityRegistry.COPPER_CAMPFIRE.get(), (p_379259_, p_379260_, p_379261_, p_379262_) -> CopperCampfireBlockEntity.cookTick(serverlevel, p_379260_, p_379261_, p_379262_, (RecipeManager.CachedCheck<SingleRecipeInput, BlastingRecipe>)cachedcheck));
            }
            return CopperCampfireBlock.createTickerHelper(p_152757_, BlockEntityRegistry.COPPER_CAMPFIRE.get(), CopperCampfireBlockEntity::cooldownTick);
        }
        return (Boolean)p_152756_.getValue((Property)LIT) != false ? CopperCampfireBlock.createTickerHelper(p_152757_, BlockEntityRegistry.COPPER_CAMPFIRE.get(), CopperCampfireBlockEntity::particleTick) : null;
    }

    protected boolean isPathfindable(BlockState p_51264_, PathComputationType p_51267_) {
        return false;
    }
}

