/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.blocks;

import com.belgie.copper_age_plus.core.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CopperFireBlock
extends Block {
    private final float fireDamage;
    protected static final VoxelShape SHAPE = Block.column((double)16.0, (double)0.0, (double)1.0);

    public CopperFireBlock(BlockBehaviour.Properties properties, float fireDamage) {
        super(properties);
        this.fireDamage = fireDamage;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return CopperFireBlock.getState((BlockGetter)context.getLevel(), context.getClickedPos());
    }

    public static BlockState getState(BlockGetter reader, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = reader.getBlockState(blockpos);
        if (CopperFireBlock.canSurviveOnBlock(blockstate)) {
            return ((Block)BlockRegistry.GREEN_FIRE.get()).defaultBlockState();
        }
        return ((Block)BlockRegistry.GREEN_FIRE.get()).defaultBlockState();
    }

    protected BlockState updateShape(BlockState p_56659_, LevelReader p_374511_, ScheduledTickAccess p_374567_, BlockPos p_56663_, Direction p_56660_, BlockPos p_56664_, BlockState p_56661_, RandomSource p_374480_) {
        return this.canSurvive(p_56659_, p_374511_, p_56663_) ? this.defaultBlockState() : Blocks.AIR.defaultBlockState();
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return CopperFireBlock.canSurviveOnBlock(level.getBlockState(pos.below()));
    }

    public static boolean canSurviveOnBlock(BlockState state) {
        return state.isSolidRender();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void animateTick(BlockState p_220763_, Level p_220764_, BlockPos p_220765_, RandomSource p_220766_) {
        block12: {
            block11: {
                double d17;
                double d12;
                double d7;
                int j1;
                BlockPos blockpos;
                BlockState blockstate;
                if (p_220766_.nextInt(24) == 0) {
                    p_220764_.playLocalSound((double)p_220765_.getX() + 0.5, (double)p_220765_.getY() + 0.5, (double)p_220765_.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + p_220766_.nextFloat(), p_220766_.nextFloat() * 0.7f + 0.3f, false);
                }
                if (this.canBurn(blockstate = p_220764_.getBlockState(blockpos = p_220765_.below())) || blockstate.isFaceSturdy((BlockGetter)p_220764_, blockpos, Direction.UP)) break block11;
                if (this.canBurn(p_220764_.getBlockState(p_220765_.west()))) {
                    for (j1 = 0; j1 < 2; ++j1) {
                        d7 = (double)p_220765_.getX() + p_220766_.nextDouble() * (double)0.1f;
                        d12 = (double)p_220765_.getY() + p_220766_.nextDouble();
                        d17 = (double)p_220765_.getZ() + p_220766_.nextDouble();
                        p_220764_.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, d7, d12, d17, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(p_220764_.getBlockState(p_220765_.east()))) {
                    for (j1 = 0; j1 < 2; ++j1) {
                        d7 = (double)(p_220765_.getX() + 1) - p_220766_.nextDouble() * (double)0.1f;
                        d12 = (double)p_220765_.getY() + p_220766_.nextDouble();
                        d17 = (double)p_220765_.getZ() + p_220766_.nextDouble();
                        p_220764_.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, d7, d12, d17, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(p_220764_.getBlockState(p_220765_.north()))) {
                    for (j1 = 0; j1 < 2; ++j1) {
                        d7 = (double)p_220765_.getX() + p_220766_.nextDouble();
                        d12 = (double)p_220765_.getY() + p_220766_.nextDouble();
                        d17 = (double)p_220765_.getZ() + p_220766_.nextDouble() * (double)0.1f;
                        p_220764_.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, d7, d12, d17, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(p_220764_.getBlockState(p_220765_.south()))) {
                    for (j1 = 0; j1 < 2; ++j1) {
                        d7 = (double)p_220765_.getX() + p_220766_.nextDouble();
                        d12 = (double)p_220765_.getY() + p_220766_.nextDouble();
                        d17 = (double)(p_220765_.getZ() + 1) - p_220766_.nextDouble() * (double)0.1f;
                        p_220764_.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, d7, d12, d17, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.canBurn(p_220764_.getBlockState(p_220765_.above()))) break block12;
                for (j1 = 0; j1 < 2; ++j1) {
                    d7 = (double)p_220765_.getX() + p_220766_.nextDouble();
                    d12 = (double)(p_220765_.getY() + 1) - p_220766_.nextDouble() * (double)0.1f;
                    d17 = (double)p_220765_.getZ() + p_220766_.nextDouble();
                    p_220764_.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, d7, d12, d17, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int j1 = 0; j1 < 3; ++j1) {
                double d7 = (double)p_220765_.getX() + p_220766_.nextDouble();
                double d12 = (double)p_220765_.getY() + p_220766_.nextDouble() * 0.5 + 0.5;
                double d17 = (double)p_220765_.getZ() + p_220766_.nextDouble();
                p_220764_.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, d7, d12, d17, 0.0, 0.0, 0.0);
            }
        }
    }

    protected boolean canBurn(BlockState var1) {
        return true;
    }

    protected void entityInside(BlockState p_49260_, Level p_49261_, BlockPos p_49262_, Entity p_49263_, InsideBlockEffectApplier p_404795_) {
        if (p_49263_ instanceof LivingEntity) {
            p_404795_.apply(InsideBlockEffectType.FIRE_IGNITE);
            p_404795_.runAfter(InsideBlockEffectType.FIRE_IGNITE, p_405041_ -> p_405041_.hurt(p_405041_.level().damageSources().inFire(), this.fireDamage));
        }
    }

    protected void spawnDestroyParticles(Level p_152139_, Player p_152140_, BlockPos p_152141_, BlockState p_152142_) {
    }

    public BlockState playerWillDestroy(Level p_49251_, BlockPos p_49252_, BlockState p_49253_, Player p_49254_) {
        if (!p_49251_.isClientSide()) {
            p_49251_.levelEvent((Entity)null, 1009, p_49252_, 0);
        }
        return super.playerWillDestroy(p_49251_, p_49252_, p_49253_, p_49254_);
    }
}

