/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.blocks;

import com.belgie.copper_age_plus.common.blocks.TuffGolemStatueBlock;
import com.belgie.copper_age_plus.core.BlockRegistry;
import com.mojang.serialization.MapCodec;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DefaultTuffStatueBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static MapCodec<DefaultTuffStatueBlock> CODEC = DefaultTuffStatueBlock.simpleCodec(DefaultTuffStatueBlock::new);
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal((VoxelShape)Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)16.0, (double)9.0));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public DefaultTuffStatueBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends DefaultTuffStatueBlock> codec() {
        return CODEC;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    protected FluidState getFluidState(BlockState p_154479_) {
        return (Boolean)p_154479_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_154479_);
    }

    protected BlockState updateShape(BlockState p_154457_, LevelReader p_374292_, ScheduledTickAccess p_374575_, BlockPos p_154461_, Direction p_154458_, BlockPos p_154462_, BlockState p_154459_, RandomSource p_374248_) {
        if (((Boolean)p_154457_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374575_.scheduleTick(p_154461_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374292_));
        }
        return super.updateShape(p_154457_, p_374292_, p_374575_, p_154461_, p_154458_, p_154462_, p_154459_, p_374248_);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        FluidState fluidstate = context.getLevel().getFluidState(blockpos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER))).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(((Direction)state.getValue(FACING)).getOpposite());
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.getItemInHand(hand);
        if (!held.is(ItemTags.WOOL_CARPETS)) {
            return InteractionResult.PASS;
        }
        Item item = held.getItem();
        BlockState newState = this.getByColor(item);
        if (newState != null && newState != Blocks.AIR.defaultBlockState()) {
            if (!level.isClientSide()) {
                level.setBlock(pos, (BlockState)newState.setValue(TuffGolemStatueBlock.FACING, (Comparable)((Direction)state.getValue(FACING))), 3);
                if (!player.isCreative()) {
                    held.shrink(1);
                }
                level.playSound(null, pos, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        LocalDate localdate = LocalDate.now();
        int i = localdate.get(ChronoField.DAY_OF_MONTH);
        int j = localdate.get(ChronoField.MONTH_OF_YEAR);
        if ((level.getMoonBrightness() >= 0.9f || j == 10 && i == 31) && random.nextInt(DefaultTuffStatueBlock.getMoveChance()) == 0 && level.getBlockState(pos.relative((Direction)state.getValue(FACING))).isAir()) {
            level.destroyBlock(pos, false);
            level.setBlock(pos.relative((Direction)state.getValue(FACING)), (BlockState)state.setValue(FACING, (Comparable)((Direction)state.getValue(FACING))), 2);
        }
        super.randomTick(state, level, pos, random);
    }

    public static int getMoveChance() {
        LocalDate localdate = LocalDate.now();
        int i = localdate.get(ChronoField.DAY_OF_MONTH);
        int j = localdate.get(ChronoField.MONTH_OF_YEAR);
        boolean halloween = j == 10 && i == 31;
        return halloween ? 500 : 5000;
    }

    public BlockState getByColor(Item color) {
        if (color == Items.WHITE_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_WHITE.get()).defaultBlockState();
        }
        if (color == Items.ORANGE_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_ORANGE.get()).defaultBlockState();
        }
        if (color == Items.MAGENTA_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_MAGENTA.get()).defaultBlockState();
        }
        if (color == Items.LIGHT_BLUE_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_LIGHT_BLUE.get()).defaultBlockState();
        }
        if (color == Items.YELLOW_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_YELLOW.get()).defaultBlockState();
        }
        if (color == Items.LIME_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_LIME.get()).defaultBlockState();
        }
        if (color == Items.PINK_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_PINK.get()).defaultBlockState();
        }
        if (color == Items.GRAY_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_GRAY.get()).defaultBlockState();
        }
        if (color == Items.LIGHT_GRAY_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_LIGHT_GRAY.get()).defaultBlockState();
        }
        if (color == Items.CYAN_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_CYAN.get()).defaultBlockState();
        }
        if (color == Items.BLUE_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_BLUE.get()).defaultBlockState();
        }
        if (color == Items.BROWN_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_BROWN.get()).defaultBlockState();
        }
        if (color == Items.GREEN_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_GREEN.get()).defaultBlockState();
        }
        if (color == Items.RED_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_RED.get()).defaultBlockState();
        }
        if (color == Items.BLACK_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_BLACK.get()).defaultBlockState();
        }
        if (color == Items.PURPLE_CARPET) {
            return ((Block)BlockRegistry.TUFF_GOLEM_PURPLE.get()).defaultBlockState();
        }
        return this.defaultBlockState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_323673_) {
        p_323673_.add(new Property[]{FACING, WATERLOGGED});
    }
}

