/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ExperimentalButtonBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final MapCodec<ExperimentalButtonBlock> CODEC = RecordCodecBuilder.mapCodec(p_432634_ -> p_432634_.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(p_304607_ -> p_304607_.type), (App)ExperimentalButtonBlock.propertiesCodec()).apply((Applicative)p_432634_, ExperimentalButtonBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private final BlockSetType type;
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<ExperimentalButtonBlock> codec() {
        return CODEC;
    }

    public ExperimentalButtonBlock(BlockSetType type, BlockBehaviour.Properties properties) {
        super(properties.sound(type.soundType()));
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACE, (Comparable)AttachFace.WALL));
        this.shapes = this.makeShapes();
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        VoxelShape voxelshape = Block.cube((double)14.0);
        VoxelShape voxelshape1 = Block.cube((double)12.0);
        Map map = Shapes.rotateAttachFace((VoxelShape)Block.boxZ((double)6.0, (double)4.0, (double)8.0, (double)16.0));
        return this.getShapeForEachState(p_393345_ -> Shapes.join((VoxelShape)((VoxelShape)((Map)map.get(p_393345_.getValue((Property)FACE))).get(p_393345_.getValue((Property)FACING))), (VoxelShape)((Boolean)p_393345_.getValue((Property)POWERED) != false ? voxelshape : voxelshape1), (BooleanOp)BooleanOp.ONLY_FIRST));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes.apply(state);
    }

    protected InteractionResult useWithoutItem(BlockState p_316833_, Level p_316124_, BlockPos p_316184_, Player p_316845_, BlockHitResult p_316247_) {
        if (((Boolean)p_316833_.getValue((Property)POWERED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        this.press(p_316833_, p_316124_, p_316184_, p_316845_);
        return InteractionResult.SUCCESS;
    }

    protected void onExplosionHit(BlockState p_312395_, ServerLevel p_364251_, BlockPos p_311817_, Explosion p_312150_, BiConsumer<ItemStack, BlockPos> p_311898_) {
        if (p_312150_.canTriggerBlocks() && !((Boolean)p_312395_.getValue((Property)POWERED)).booleanValue()) {
            this.press(p_312395_, (Level)p_364251_, p_311817_, null);
        }
        super.onExplosionHit(p_312395_, p_364251_, p_311817_, p_312150_, p_311898_);
    }

    public void press(BlockState state, Level level, BlockPos pos, @Nullable Player player) {
        level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbours(state, level, pos);
        level.scheduleTick(pos, (Block)this, 5);
        this.playSound(player, (LevelAccessor)level, pos, true);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
    }

    protected void playSound(@Nullable Player player, LevelAccessor level, BlockPos pos, boolean hitByArrow) {
        level.playSound((Entity)(hitByArrow ? player : null), pos, this.getSound(hitByArrow), SoundSource.BLOCKS);
    }

    protected SoundEvent getSound(boolean isOn) {
        return isOn ? this.type.buttonClickOn() : this.type.buttonClickOff();
    }

    protected void affectNeighborsAfterRemoval(BlockState p_394009_, ServerLevel p_394160_, BlockPos p_394096_, boolean p_393730_) {
        if (!p_393730_ && ((Boolean)p_394009_.getValue((Property)POWERED)).booleanValue()) {
            this.updateNeighbours(p_394009_, (Level)p_394160_, p_394096_);
        }
    }

    protected int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.getValue((Property)POWERED) != false && ExperimentalButtonBlock.getConnectedDirection((BlockState)blockState) == side ? 15 : 0;
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    protected void tick(BlockState p_220903_, ServerLevel p_220904_, BlockPos p_220905_, RandomSource p_220906_) {
        if (((Boolean)p_220903_.getValue((Property)POWERED)).booleanValue()) {
            this.checkPressed(p_220903_, (Level)p_220904_, p_220905_);
        }
    }

    protected void entityInside(BlockState p_51083_, Level p_51084_, BlockPos p_51085_, Entity p_51086_, InsideBlockEffectApplier p_405475_) {
        if (!p_51084_.isClientSide() && this.type.canButtonBeActivatedByArrows() && !((Boolean)p_51083_.getValue((Property)POWERED)).booleanValue()) {
            this.checkPressed(p_51083_, p_51084_, p_51085_);
        }
    }

    protected void checkPressed(BlockState state, Level level, BlockPos pos) {
        boolean flag1;
        AbstractArrow abstractarrow = this.type.canButtonBeActivatedByArrows() ? (AbstractArrow)level.getEntitiesOfClass(AbstractArrow.class, state.getShape((BlockGetter)level, pos).bounds().move(pos)).stream().findFirst().orElse(null) : null;
        boolean flag = abstractarrow != null;
        if (flag != (flag1 = ((Boolean)state.getValue((Property)POWERED)).booleanValue())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
            this.updateNeighbours(state, level, pos);
            this.playSound(null, (LevelAccessor)level, pos, flag);
            level.gameEvent((Entity)abstractarrow, (Holder)(flag ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
        }
        if (flag) {
            level.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, 5);
        }
    }

    private void updateNeighbours(BlockState state, Level level, BlockPos pos) {
        Direction direction;
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation((Level)level, (Direction)direction, (Direction)((direction = ExperimentalButtonBlock.getConnectedDirection((BlockState)state).getOpposite()).getAxis().isHorizontal() ? Direction.UP : (Direction)state.getValue((Property)FACING)));
        level.updateNeighborsAt(pos, (Block)this, orientation);
        level.updateNeighborsAt(pos.relative(direction), (Block)this, orientation);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, FACE});
    }
}

