/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.blocks;

import com.belgie.copper_age_plus.common.blockentities.FilterBlockEntity;
import com.belgie.copper_age_plus.core.BlockEntityRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;

public class FilterBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<FilterBlock> CODEC = FilterBlock.simpleCodec(FilterBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public MapCodec<FilterBlock> codec() {
        return CODEC;
    }

    public FilterBlock(BlockBehaviour.Properties p_273064_) {
        super(p_273064_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockState updateShape(BlockState p_276307_, LevelReader p_374037_, ScheduledTickAccess p_374267_, BlockPos p_276270_, Direction p_276322_, BlockPos p_276312_, BlockState p_276280_, RandomSource p_374464_) {
        if (((Boolean)p_276307_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374267_.scheduleTick(p_276270_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374037_));
        }
        return super.updateShape(p_276307_, p_374037_, p_374267_, p_276270_, p_276322_, p_276312_, p_276280_, p_374464_);
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_272711_) {
        FluidState fluidstate = p_272711_.getLevel().getFluidState(p_272711_.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    protected InteractionResult useItemOn(ItemStack p_316569_, BlockState p_316562_, Level p_316177_, BlockPos p_316898_, Player p_316632_, InteractionHand p_316424_, BlockHitResult p_316345_) {
        BlockEntity var9 = p_316177_.getBlockEntity(p_316898_);
        if (var9 instanceof FilterBlockEntity) {
            FilterBlockEntity decoratedpotblockentity = (FilterBlockEntity)var9;
            if (p_316177_.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstack1 = decoratedpotblockentity.getFilterItem();
            if (p_316569_.isEmpty() || !itemstack1.isEmpty()) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            if (itemstack1.isEmpty()) {
                p_316632_.awardStat(Stats.ITEM_USED.get((Object)p_316569_.getItem()));
                ItemStack itemstack = p_316569_.copyWithCount(1);
                decoratedpotblockentity.setFilterItem(itemstack);
                p_316177_.setBlockAndUpdate(p_316898_, p_316562_);
                p_316177_.playSound((Entity)((Player)null), p_316898_, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 1.2f);
                decoratedpotblockentity.markUpdated();
                p_316177_.gameEvent((Entity)p_316632_, (Holder)GameEvent.BLOCK_CHANGE, p_316898_);
                return InteractionResult.SUCCESS;
            }
        } else {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity var9 = level.getBlockEntity(pos);
        if (var9 instanceof FilterBlockEntity) {
            FilterBlockEntity decoratedpotblockentity = (FilterBlockEntity)var9;
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            ItemStack itemstack1 = decoratedpotblockentity.getFilterItem();
            if (itemstack1.isEmpty()) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            decoratedpotblockentity.setFilterItem(ItemStack.EMPTY);
            level.setBlockAndUpdate(pos, state);
            level.playSound((Entity)((Player)null), pos, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 1.2f);
            decoratedpotblockentity.markUpdated();
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_153378_, BlockState p_153379_, BlockEntityType<T> p_153380_) {
        return p_153378_.isClientSide() ? null : FilterBlock.createTickerHelper(p_153380_, BlockEntityRegistry.FILTER.get(), FilterBlockEntity::pushItemsTick);
    }

    protected boolean isPathfindable(BlockState p_276295_, PathComputationType p_276303_) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_273169_) {
        p_273169_.add(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_273396_, BlockState p_272674_) {
        return new FilterBlockEntity(p_273396_, p_272674_);
    }

    protected FluidState getFluidState(BlockState p_272593_) {
        return (Boolean)p_272593_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_272593_);
    }

    protected boolean hasAnalogOutputSignal(BlockState p_305995_) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction p_435855_) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }
}

