/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.blocks;

import com.belgie.copper_age_plus.common.blockentities.TuffGolemStatueBlockEntity;
import com.belgie.copper_age_plus.core.BlockRegistry;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.Nullable;

public class TuffGolemStatueBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
IShearable {
    public static final BooleanProperty EYES_OPEN = BooleanProperty.create((String)"eyes_open");
    public static final BooleanProperty HAS_ITEM = BooleanProperty.create((String)"has_item");
    public static final EnumProperty<ItemPose> ITEM_POSE = EnumProperty.create((String)"item_pose", ItemPose.class);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static MapCodec<TuffGolemStatueBlock> CODEC = TuffGolemStatueBlock.simpleCodec(TuffGolemStatueBlock::new);
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal((VoxelShape)Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)16.0, (double)9.0));
    private static final Map<Direction, VoxelShape> SHAPES_ITEM = Shapes.rotateHorizontal((VoxelShape)TuffGolemStatueBlock.makeShape());
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public TuffGolemStatueBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false))).setValue((Property)EYES_OPEN, (Comparable)Boolean.valueOf(false))).setValue(ITEM_POSE, (Comparable)((Object)ItemPose.SMALL_ITEM)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HAS_ITEM) != false ? SHAPES_ITEM.get(((Direction)state.getValue(FACING)).getOpposite()) : SHAPES.get(((Direction)state.getValue(FACING)).getOpposite());
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        FluidState fluidstate = context.getLevel().getFluidState(blockpos);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER))).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)EYES_OPEN, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    protected FluidState getFluidState(BlockState p_154479_) {
        return (Boolean)p_154479_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_154479_);
    }

    protected BlockState updateShape(BlockState p_154457_, LevelReader p_374292_, ScheduledTickAccess p_374575_, BlockPos p_154461_, Direction p_154458_, BlockPos p_154462_, BlockState p_154459_, RandomSource p_374248_) {
        if (((Boolean)p_154457_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374575_.scheduleTick(p_154461_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374292_));
        }
        return super.updateShape(p_154457_, p_374292_, p_374575_, p_154461_, p_154458_, p_154462_, p_154459_, p_374248_);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction p_435855_) {
        return (Boolean)state.getValue((Property)HAS_ITEM) == false ? 0 : TuffGolemStatueBlock.getPower(state);
    }

    public static int getPower(BlockState state) {
        if (state.getValue(ITEM_POSE) == ItemPose.BIG_ITEM) {
            return 15;
        }
        if (state.getValue(ITEM_POSE) == ItemPose.SMALL_ITEM) {
            return 12;
        }
        if (state.getValue(ITEM_POSE) == ItemPose.FLAT_BIG_ITEM) {
            return 8;
        }
        if (state.getValue(ITEM_POSE) == ItemPose.FLAT_SMALL_ITEM) {
            return 5;
        }
        return 0;
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Block.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)7.0, (double)15.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    protected void neighborChanged(BlockState p_55666_, Level p_55667_, BlockPos p_55668_, Block p_55669_, @javax.annotation.Nullable Orientation p_364297_, boolean p_55671_) {
        boolean flag;
        if (!p_55667_.isClientSide() && (flag = ((Boolean)p_55666_.getValue((Property)EYES_OPEN)).booleanValue()) != p_55667_.hasNeighborSignal(p_55668_)) {
            if (flag) {
                p_55667_.scheduleTick(p_55668_, (Block)this, 4);
            } else {
                p_55667_.setBlock(p_55668_, (BlockState)p_55666_.cycle((Property)EYES_OPEN), 2);
                p_55667_.playSound(null, p_55668_, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, -1.0f);
            }
        }
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void tick(BlockState p_221937_, ServerLevel p_221938_, BlockPos p_221939_, RandomSource p_221940_) {
        if (((Boolean)p_221937_.getValue((Property)EYES_OPEN)).booleanValue() && !p_221938_.hasNeighborSignal(p_221939_)) {
            p_221938_.setBlock(p_221939_, (BlockState)p_221937_.cycle((Property)EYES_OPEN), 2);
        }
    }

    protected InteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TuffGolemStatueBlockEntity) {
            TuffGolemStatueBlockEntity statue = (TuffGolemStatueBlockEntity)blockEntity;
            ItemStack currentItem = statue.getTheItem();
            if (currentItem.isEmpty()) {
                if (heldStack.is(Items.SHEARS)) {
                    player.awardStat(Stats.ITEM_USED.get((Object)heldStack.getItem()));
                    heldStack.hurtAndBreak(1, (LivingEntity)player, hand);
                    this.popOutTheItem(level, pos);
                    level.setBlockAndUpdate(pos, (BlockState)((Block)BlockRegistry.TUFF_STATUE.get()).defaultBlockState().setValue(FACING, (Comparable)((Direction)state.getValue(FACING))));
                    level.playSound(null, pos, SoundEvents.SHEARS_SNIP, SoundSource.BLOCKS, 1.0f, 1.2f);
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    return InteractionResult.SUCCESS;
                }
                if (!heldStack.isEmpty()) {
                    player.awardStat(Stats.ITEM_USED.get((Object)heldStack.getItem()));
                    ItemStack remaining = heldStack.consumeAndReturn(1, (LivingEntity)player);
                    statue.setTheItem(remaining);
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_ITEM, (Comparable)Boolean.valueOf(true)));
                    level.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 1.2f);
                    statue.markUpdated();
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public void popOutTheItem(Level level, BlockPos blockPos) {
        ItemStack itemstack;
        if (level != null && !level.isClientSide() && !(itemstack = this.getByColor(this.defaultBlockState())).isEmpty()) {
            Vec3 vec3 = Vec3.atLowerCornerWithOffset((Vec3i)blockPos, (double)0.5, (double)1.01, (double)0.5).offsetRandom(level.random, 0.7f);
            ItemStack itemstack1 = itemstack.copy();
            ItemEntity itementity = new ItemEntity(level, vec3.x(), vec3.y(), vec3.z(), itemstack1);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
    }

    public ItemStack getByColor(BlockState color) {
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_WHITE.get()).defaultBlockState()) {
            return Items.WHITE_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_ORANGE.get()).defaultBlockState()) {
            return Items.ORANGE_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_MAGENTA.get()).defaultBlockState()) {
            return Items.MAGENTA_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_LIGHT_BLUE.get()).defaultBlockState()) {
            return Items.LIGHT_BLUE_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_YELLOW.get()).defaultBlockState()) {
            return Items.YELLOW_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_LIME.get()).defaultBlockState()) {
            return Items.LIME_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_PINK.get()).defaultBlockState()) {
            return Items.PINK_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_GRAY.get()).defaultBlockState()) {
            return Items.GRAY_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_LIGHT_GRAY.get()).defaultBlockState()) {
            return Items.LIGHT_GRAY_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_CYAN.get()).defaultBlockState()) {
            return Items.CYAN_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_BLUE.get()).defaultBlockState()) {
            return Items.BLUE_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_BROWN.get()).defaultBlockState()) {
            return Items.BROWN_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_GREEN.get()).defaultBlockState()) {
            return Items.GREEN_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_RED.get()).defaultBlockState()) {
            return Items.RED_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_BLACK.get()).defaultBlockState()) {
            return Items.BLACK_CARPET.getDefaultInstance();
        }
        if (color == ((Block)BlockRegistry.TUFF_GOLEM_PURPLE.get()).defaultBlockState()) {
            return Items.PURPLE_CARPET.getDefaultInstance();
        }
        return ItemStack.EMPTY;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity var9 = level.getBlockEntity(pos);
        if (var9 instanceof TuffGolemStatueBlockEntity) {
            TuffGolemStatueBlockEntity decoratedpotblockentity = (TuffGolemStatueBlockEntity)var9;
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)state.getValue((Property)HAS_ITEM)).booleanValue() && player.isCrouching()) {
                level.playSound((Entity)((Player)null), pos, SoundEvents.VAULT_CLOSE_SHUTTER, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                level.setBlockAndUpdate(pos, (BlockState)state.cycle(ITEM_POSE));
                return InteractionResult.SUCCESS_SERVER;
            }
            ItemStack itemstack1 = decoratedpotblockentity.getTheItem();
            if (itemstack1.isEmpty()) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            decoratedpotblockentity.setTheItem(ItemStack.EMPTY);
            ItemStack itemstack = itemstack1.copyWithCount(1);
            player.addItem(itemstack);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false)));
            level.playSound((Entity)((Player)null), pos, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 1.2f);
            decoratedpotblockentity.markUpdated();
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_323673_) {
        p_323673_.add(new Property[]{FACING, ITEM_POSE, HAS_ITEM, EYES_OPEN, WATERLOGGED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TuffGolemStatueBlockEntity(blockPos, blockState);
    }

    public static enum ItemPose implements StringRepresentable
    {
        BIG_ITEM("big_item"),
        SMALL_ITEM("small_item"),
        FLAT_BIG_ITEM("flat_big_item"),
        FLAT_SMALL_ITEM("flat_small_item");

        public String name;

        private ItemPose(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

