/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.blocks;

import com.belgie.copper_age_plus.CopperAgePlus;
import com.belgie.copper_age_plus.common.blocks.ExperimentalButtonBlock;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;

public class WeatheringCopperButtonBlock
extends ExperimentalButtonBlock
implements WeatheringCopper {
    public static final MapCodec<WeatheringCopperButtonBlock> CODEC = RecordCodecBuilder.mapCodec(p_368403_ -> p_368403_.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(p_304607_ -> p_304607_.type), (App)WeatheringCopper.WeatherState.CODEC.fieldOf("weathering_state").forGetter(WeatheringCopperButtonBlock::getAge), (App)WeatheringCopperButtonBlock.propertiesCodec()).apply((Applicative)p_368403_, WeatheringCopperButtonBlock::new));
    private final WeatheringCopper.WeatherState weatherState;
    private final BlockSetType type;

    public WeatheringCopperButtonBlock(BlockSetType type, WeatheringCopper.WeatherState state, BlockBehaviour.Properties properties) {
        super(type, properties);
        this.weatherState = state;
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACE, (Comparable)AttachFace.WALL));
    }

    protected void randomTick(BlockState p_309138_, ServerLevel p_309005_, BlockPos p_309123_, RandomSource p_309094_) {
        this.changeOverTime(p_309138_, p_309005_, p_309123_, p_309094_);
    }

    @Override
    public void press(BlockState state, Level level, BlockPos pos, @Nullable Player player) {
        level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbours(state, level, pos);
        level.scheduleTick(pos, (Block)this, this.getPressedDuration(level));
        this.playSound(player, (LevelAccessor)level, pos, true);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
    }

    @Override
    protected void checkPressed(BlockState state, Level level, BlockPos pos) {
        boolean flag1;
        AbstractArrow abstractarrow = this.type.canButtonBeActivatedByArrows() ? (AbstractArrow)level.getEntitiesOfClass(AbstractArrow.class, state.getShape((BlockGetter)level, pos).bounds().move(pos)).stream().findFirst().orElse(null) : null;
        boolean flag = abstractarrow != null;
        if (flag != (flag1 = ((Boolean)state.getValue((Property)POWERED)).booleanValue())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
            this.updateNeighbours(state, level, pos);
            this.playSound(null, (LevelAccessor)level, pos, flag);
            level.gameEvent((Entity)abstractarrow, (Holder)(flag ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
        }
        if (flag) {
            level.scheduleTick(new BlockPos((Vec3i)pos), (Block)this, this.getPressedDuration(level));
        }
    }

    private void updateNeighbours(BlockState state, Level level, BlockPos pos) {
        Direction direction;
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation((Level)level, (Direction)direction, (Direction)((direction = WeatheringCopperButtonBlock.getConnectedDirection((BlockState)state).getOpposite()).getAxis().isHorizontal() ? Direction.UP : (Direction)state.getValue((Property)FACING)));
        level.updateNeighborsAt(pos, (Block)this, orientation);
        level.updateNeighborsAt(pos.relative(direction), (Block)this, orientation);
    }

    public int getPressedDuration(Level level) {
        if (WeatheringCopperButtonBlock.useExperimentalEvaluator(level)) {
            switch (this.weatherState) {
                case OXIDIZED: {
                    return 20;
                }
                case WEATHERED: {
                    return 15;
                }
                case EXPOSED: {
                    return 10;
                }
                case UNAFFECTED: {
                    return 5;
                }
            }
        }
        return 5;
    }

    private static boolean useExperimentalEvaluator(Level level) {
        return level.enabledFeatures().contains(CopperAgePlus.COPPER_DURATION);
    }

    protected boolean isRandomlyTicking(BlockState p_309078_) {
        return WeatheringCopper.getNext((Block)p_309078_.getBlock()).isPresent();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }
}

