/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.entity.tuffgolem;

import com.belgie.copper_age_plus.common.entity.tuffgolem.TuffGolemEntity;
import com.belgie.copper_age_plus.common.entity.tuffgolem.TuffGolemGoHome;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;

public class TuffGolemAI {
    protected static Brain<?> makeBrain(Brain<TuffGolemEntity> brain) {
        TuffGolemAI.initCoreActivity(brain);
        TuffGolemAI.initIdleActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<TuffGolemEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new AnimalPanic(1.2f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<TuffGolemEntity> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)GoToWantedItem.create(p_218428_ -> true, (float)1.0f, (boolean)true, (int)32)), (Object)Pair.of((Object)1, TuffGolemGoHome.create((MemoryModuleType<GlobalPos>)MemoryModuleType.HOME, 1.0f, 0, 100)), (Object)Pair.of((Object)2, (Object)StrollAroundPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)1.0f, (int)32)), (Object)Pair.of((Object)3, (Object)SetEntityLookTargetSometimes.create((float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)4, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of());
    }

    private static Optional<PositionTracker> getHomePosition(LivingEntity entity) {
        Brain brain = entity.getBrain();
        Optional optional = brain.getMemory(MemoryModuleType.HOME);
        if (optional.isPresent()) {
            GlobalPos globalpos = (GlobalPos)optional.get();
            return Optional.of(new BlockPosTracker(globalpos.pos()));
        }
        return Optional.empty();
    }

    protected static void pickUpItem(ServerLevel level, TuffGolemEntity piglin, ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.getItem();
        if (piglin.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
            piglin.take((Entity)itemEntity, itemEntity.getItem().getCount());
            level.broadcastEntityEvent((Entity)piglin, (byte)66);
            piglin.setItemInHand(InteractionHand.MAIN_HAND, itemstack);
            itemEntity.discard();
        }
    }

    public static void updateActivity(TuffGolemEntity allay) {
        allay.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.IDLE, (Object)Activity.INVESTIGATE));
    }
}

