/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.entity.tuffgolem;

import com.belgie.copper_age_plus.common.blockentities.TuffGolemStatueBlockEntity;
import com.belgie.copper_age_plus.common.blocks.TuffGolemStatueBlock;
import com.belgie.copper_age_plus.common.entity.tuffgolem.TuffGolemAI;
import com.belgie.copper_age_plus.core.BlockRegistry;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class TuffGolemEntity
extends AbstractGolem
implements Shearable {
    private static final float TURN_TO_STATUE_CHANCE = 0.0058f;
    @Nullable
    private BlockPos homePos;
    public final AnimationState pickupItem = new AnimationState();
    public final AnimationState dropItem = new AnimationState();
    public final AnimationState holdItem = new AnimationState();
    public static final EquipmentSlot EQUIPMENT_SLOT_CAPE;
    private static final Vec3i ITEM_PICKUP_REACH;
    private static final EntityDataAccessor<Boolean> CAN_MOVE;
    protected static final ImmutableList<SensorType<? extends Sensor<? super TuffGolemEntity>>> SENSOR_TYPES;
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES;

    public TuffGolemEntity(EntityType<? extends AbstractGolem> p_433093_, Level p_433055_) {
        super(p_433093_, p_433055_);
        this.getNavigation().setRequiredPathLength(48.0f);
        this.getNavigation().setCanOpenDoors(true);
        this.setPersistenceRequired();
        this.lookControl = new CreakingLookControl(this);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DANGER_OTHER, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.MAX_HEALTH, 12.0);
    }

    protected Brain.Provider<TuffGolemEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> p_435315_) {
        return TuffGolemAI.makeBrain((Brain<TuffGolemEntity>)this.brainProvider().makeBrain(p_435315_));
    }

    public Brain<TuffGolemEntity> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep(ServerLevel p_435023_) {
        ProfilerFiller profilerfiller = Profiler.get();
        profilerfiller.push("tuffGolemBrain");
        this.getBrain().tick(p_435023_, (LivingEntity)this);
        profilerfiller.pop();
        profilerfiller.push("copperGolemActivityUpdate");
        TuffGolemAI.updateActivity(this);
        profilerfiller.pop();
        super.customServerAiStep(p_435023_);
    }

    public InteractionResult mobInteract(Player p_434985_, InteractionHand p_435758_) {
        ItemStack itemstack1;
        ItemStack itemstack = p_434985_.getItemInHand(p_435758_);
        if (itemstack.isEmpty() && !(itemstack1 = this.getMainHandItem()).isEmpty()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)67);
            BehaviorUtils.throwItem((LivingEntity)this, (ItemStack)itemstack1, (Vec3)p_434985_.position());
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.is(ItemTags.WOOL_CARPETS) && (itemstack1 = this.getBodyArmorItem()).isEmpty()) {
            this.setItemSlot(EQUIPMENT_SLOT_CAPE, itemstack.copyWithCount(1));
            return InteractionResult.SUCCESS;
        }
        Level level = this.level();
        if (itemstack.is(Items.SHEARS) && this.readyForShearing()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                this.shear(serverlevel, SoundSource.PLAYERS, itemstack);
                this.gameEvent((Holder)GameEvent.SHEAR, (Entity)p_434985_);
                itemstack.hurtAndBreak(1, (LivingEntity)p_434985_, p_435758_);
            }
            return InteractionResult.SUCCESS;
        }
        if (level.isClientSide()) {
            return InteractionResult.PASS;
        }
        return super.mobInteract(p_434985_, p_435758_);
    }

    private boolean canTurnToStatue(Level p_435326_) {
        boolean correctBlock = p_435326_.getBlockState(this.blockPosition().below()).is(BlockTags.BASE_STONE_OVERWORLD) || p_435326_.getBlockState(this.blockPosition().below()).is(BlockTags.DIRT);
        return correctBlock && p_435326_.getBlockState(this.blockPosition()).is(Blocks.AIR) && p_435326_.random.nextFloat() <= 0.0058f;
    }

    private void turnToStatue(ServerLevel p_435227_, boolean item) {
        BlockPos blockpos = this.blockPosition();
        BlockState state = item ? (BlockState)this.getBlockFromCarpet(this.getItemBySlot(EquipmentSlot.BODY).getItem()).setValue(TuffGolemStatueBlock.FACING, (Comparable)Direction.fromYRot((double)this.getYRot())) : (BlockState)((BlockState)this.getBlockFromCarpet(this.getItemBySlot(EquipmentSlot.BODY).getItem()).setValue((Property)TuffGolemStatueBlock.HAS_ITEM, (Comparable)Boolean.valueOf(this.hasItemInHand()))).setValue(TuffGolemStatueBlock.FACING, (Comparable)Direction.fromYRot((double)this.getYRot()));
        p_435227_.setBlock(blockpos, state, 3);
        BlockEntity var4 = p_435227_.getBlockEntity(blockpos);
        this.discard();
        if (var4 instanceof TuffGolemStatueBlockEntity) {
            TuffGolemStatueBlockEntity coppergolemstatueblockentity = (TuffGolemStatueBlockEntity)var4;
            coppergolemstatueblockentity.createStatue(this);
            this.dropPreservedEquipment(p_435227_);
            this.playSound(SoundEvents.COPPER_GOLEM_BECOME_STATUE);
            if (this.isLeashed()) {
                if (p_435227_.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    this.dropLeash();
                } else {
                    this.removeLeash();
                }
            }
            if (this.hasItemInHand()) {
                coppergolemstatueblockentity.setTheItem(this.getMainHandItem());
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_434296_, DifficultyInstance p_435487_, EntitySpawnReason p_433436_, @Nullable SpawnGroupData p_433449_) {
        this.getBrain().setMemory(MemoryModuleType.HOME, (Object)GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)this.blockPosition()));
        return super.finalizeSpawn(p_434296_, p_435487_, p_433436_, p_433449_);
    }

    protected SoundEvent getHurtSound(DamageSource p_435524_) {
        return SoundEvents.TUFF_BREAK;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.TUFF_BREAK;
    }

    protected void playStepSound(BlockPos p_435764_, BlockState p_435424_) {
        this.playSound(SoundEvents.COPPER_GOLEM_OXIDIZED_STEP, 1.0f, 1.0f);
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.75f * this.getEyeHeight()), 0.0);
    }

    public void shear(ServerLevel p_437195_, SoundSource p_437404_, ItemStack p_437417_) {
        p_437195_.playSound((Entity)null, (Entity)this, SoundEvents.COPPER_GOLEM_SHEAR, p_437404_, 1.0f, 1.0f);
        ItemStack itemstack = this.getItemBySlot(EQUIPMENT_SLOT_CAPE);
        this.setItemSlot(EQUIPMENT_SLOT_CAPE, ItemStack.EMPTY);
        this.spawnAtLocation(p_437195_, itemstack, 1.5f);
    }

    public boolean readyForShearing() {
        return this.isAlive() && this.getItemBySlot(EQUIPMENT_SLOT_CAPE).is(ItemTags.WOOL_CARPETS) && !this.hasItemInHand();
    }

    protected void dropEquipment(ServerLevel p_437389_) {
        super.dropEquipment(p_437389_);
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        ItemStack itemstack1 = this.getItemBySlot(EquipmentSlot.BODY);
        if (!itemstack.isEmpty()) {
            this.spawnAtLocation(p_437389_, itemstack);
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        if (!itemstack1.isEmpty()) {
            this.spawnAtLocation(p_437389_, itemstack1);
            this.setItemSlot(EquipmentSlot.BODY, ItemStack.EMPTY);
        }
    }

    protected void actuallyHurt(ServerLevel p_442580_, DamageSource p_443112_, float p_443064_) {
        super.actuallyHurt(p_442580_, p_443112_, p_443064_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_379982_) {
        super.defineSynchedData(p_379982_);
        p_379982_.define(CAN_MOVE, (Object)true);
    }

    public boolean canMove() {
        return (Boolean)this.entityData.get(CAN_MOVE);
    }

    public boolean isPushable() {
        return super.isPushable() && this.canMove();
    }

    public void push(double p_388562_, double p_388936_, double p_387604_) {
        if (this.canMove()) {
            super.push(p_388562_, p_388936_, p_387604_);
        }
    }

    public boolean wantsToPickUp(ServerLevel p_376111_, ItemStack p_218387_) {
        ItemStack itemstack = this.getItemInHand(InteractionHand.MAIN_HAND);
        return itemstack.isEmpty() && EventHooks.canEntityGrief((ServerLevel)p_376111_, (Entity)this) && !this.getItemBySlot(EquipmentSlot.BODY).isEmpty();
    }

    public void tick() {
        if (this.hasItemInHand()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)66);
        }
        super.tick();
    }

    public void aiStep() {
        if (!this.level().isClientSide()) {
            ServerLevel level = (ServerLevel)this.level();
            int light = level.getBrightness(LightLayer.BLOCK, this.blockPosition());
            if (light == 0 && !this.canMove() && this.canTurnToStatue((Level)level)) {
                this.turnToStatue(level, this.getItemBySlot(EquipmentSlot.BODY).isEmpty());
            }
            boolean flag1 = this.checkCanMove(this.level());
            this.setRequiresPrecisePosition(!this.canMove());
            if (!flag1) {
                Vec3 mobPos;
                double distSq;
                Optional home = this.getBrain().getMemory(MemoryModuleType.HOME);
                if (home.isPresent() && (distSq = (mobPos = this.position()).distanceToSqr((double)((GlobalPos)home.get()).pos().getX() + 0.5, (double)((GlobalPos)home.get()).pos().getY(), (double)((GlobalPos)home.get()).pos().getZ() + 0.5)) < 0.1) {
                    this.stopInPlace();
                    this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
                    level.getChunkSource().chunkMap.sendToTrackingPlayers((Entity)this, (Packet)ClientboundEntityPositionSyncPacket.of((Entity)this));
                    this.entityData.set(CAN_MOVE, (Object)false);
                }
            } else {
                this.entityData.set(CAN_MOVE, (Object)true);
            }
        }
        super.aiStep();
    }

    public boolean canUseSlot(EquipmentSlot p_416032_) {
        return true;
    }

    public BlockState getBlockFromCarpet(Item item) {
        BlockState state = ((Block)BlockRegistry.TUFF_STATUE.get()).defaultBlockState();
        if (item == Items.WHITE_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_WHITE.get()).defaultBlockState();
        } else if (item == Items.BLACK_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_BLACK.get()).defaultBlockState();
        } else if (item == Items.GRAY_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_GRAY.get()).defaultBlockState();
        } else if (item == Items.LIGHT_GRAY_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_LIGHT_GRAY.get()).defaultBlockState();
        } else if (item == Items.BROWN_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_BROWN.get()).defaultBlockState();
        } else if (item == Items.RED_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_RED.get()).defaultBlockState();
        } else if (item == Items.YELLOW_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_YELLOW.get()).defaultBlockState();
        } else if (item == Items.ORANGE_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_ORANGE.get()).defaultBlockState();
        } else if (item == Items.GREEN_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_GREEN.get()).defaultBlockState();
        } else if (item == Items.LIME_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_LIME.get()).defaultBlockState();
        } else if (item == Items.BLUE_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_BLUE.get()).defaultBlockState();
        } else if (item == Items.LIGHT_BLUE_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_LIGHT_BLUE.get()).defaultBlockState();
        } else if (item == Items.CYAN_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_CYAN.get()).defaultBlockState();
        } else if (item == Items.PINK_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_PINK.get()).defaultBlockState();
        } else if (item == Items.PURPLE_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_PURPLE.get()).defaultBlockState();
        } else if (item == Items.MAGENTA_CARPET) {
            state = ((Block)BlockRegistry.TUFF_GOLEM_MAGENTA.get()).defaultBlockState();
        }
        return state;
    }

    public boolean checkCanMove(Level level) {
        boolean isNight = level.isMoonVisible();
        return !isNight;
    }

    public boolean canPickUpLoot() {
        return !this.hasItemInHand() && !this.getItemBySlot(EquipmentSlot.BODY).isEmpty();
    }

    public boolean hasItemInHand() {
        return !this.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() || !this.getItemInHand(InteractionHand.OFF_HAND).isEmpty();
    }

    protected boolean canShearEquipment(Player player) {
        return !this.hasItemInHand();
    }

    protected boolean canDispenserEquipIntoSlot(EquipmentSlot p_371819_) {
        return false;
    }

    protected Vec3i getPickupReach() {
        return ITEM_PICKUP_REACH;
    }

    protected void pickUpItem(ServerLevel p_376166_, ItemEntity p_34743_) {
        this.onItemPickup(p_34743_);
        TuffGolemAI.pickUpItem(p_376166_, this, p_34743_);
    }

    public void handleEntityEvent(byte p_21375_) {
        if (p_21375_ == 66) {
            this.pickupItem.startIfStopped(this.tickCount);
            this.dropItem.stop();
            this.holdItem.stop();
        }
        if (p_21375_ == 67) {
            this.pickupItem.stop();
            this.dropItem.startIfStopped(this.tickCount);
            this.holdItem.stop();
        }
        super.handleEntityEvent(p_21375_);
    }

    protected PathNavigation createNavigation(Level p_389684_) {
        return new CreakingPathNavigation(this, p_389684_);
    }

    public void knockback(double p_379489_, double p_380324_, double p_379735_) {
        if (this.canMove()) {
            super.knockback(p_379489_, p_380324_, p_379735_);
        }
    }

    public float getWalkTargetValue(BlockPos p_379756_, LevelReader p_380102_) {
        return 0.0f;
    }

    static {
        ITEM_PICKUP_REACH = new Vec3i(1, 1, 1);
        EQUIPMENT_SLOT_CAPE = EquipmentSlot.BODY;
        CAN_MOVE = SynchedEntityData.defineId(TuffGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_ITEMS);
        MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.PATH, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)MemoryModuleType.HOME, (Object)MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_PANICKING);
    }

    class CreakingLookControl
    extends LookControl {
        public CreakingLookControl(TuffGolemEntity creaking) {
            super((Mob)creaking);
        }

        public void tick() {
            if (!TuffGolemEntity.this.canMove()) {
                float f = CreakingLookControl.wrapDegrees90(TuffGolemEntity.this.getYRot());
                TuffGolemEntity.this.setYRot(TuffGolemEntity.this.getYRot() - f);
                TuffGolemEntity.this.setYHeadRot(TuffGolemEntity.this.getYRot());
            } else {
                super.tick();
            }
        }

        public static float wrapDegrees90(float degrees) {
            float f = degrees % 90.0f;
            if (f >= 45.0f) {
                f -= 90.0f;
            }
            if (f < -45.0f) {
                f += 90.0f;
            }
            return f;
        }
    }

    class CreakingPathNavigation
    extends GroundPathNavigation {
        CreakingPathNavigation(TuffGolemEntity creaking, Level level) {
            super((Mob)creaking, level);
        }

        public void tick() {
            if (TuffGolemEntity.this.canMove()) {
                super.tick();
            }
        }
    }

    class CreakingJumpControl
    extends JumpControl {
        public CreakingJumpControl(TuffGolemEntity creaking) {
            super((Mob)creaking);
        }

        public void tick() {
            if (TuffGolemEntity.this.canMove()) {
                super.tick();
            } else {
                TuffGolemEntity.this.setJumping(false);
            }
        }
    }

    class CreakingMoveControl
    extends MoveControl {
        public CreakingMoveControl(TuffGolemEntity creaking) {
            super((Mob)creaking);
        }

        public void tick() {
            if (TuffGolemEntity.this.canMove()) {
                super.tick();
            }
        }
    }
}

