/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.common.entity.tuffgolem;

import com.belgie.copper_age_plus.common.entity.tuffgolem.TuffGolemAnimations;
import com.belgie.copper_age_plus.common.entity.tuffgolem.TuffGolemRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class TuffGolemModel
extends EntityModel<TuffGolemRenderState>
implements HeadedModel {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart carpet;
    private final ModelPart carpet2;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final KeyframeAnimation walkAnimation;
    private final KeyframeAnimation HoldingwalkAnimation;
    private final KeyframeAnimation pickUpAnimation;
    private final KeyframeAnimation DropAnimation;
    private final KeyframeAnimation holdingAnimation;

    public TuffGolemModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.carpet = this.body.getChild("carpet");
        this.carpet2 = this.body.getChild("carpet2");
        this.left_arm = this.body.getChild("left_arm");
        this.right_arm = this.body.getChild("right_arm");
        this.left_leg = this.root.getChild("left_leg");
        this.right_leg = this.root.getChild("right_leg");
        this.walkAnimation = TuffGolemAnimations.WALK.bake(root);
        this.HoldingwalkAnimation = TuffGolemAnimations.WALK_HOLD.bake(root);
        this.pickUpAnimation = TuffGolemAnimations.HOLD_START.bake(root);
        this.DropAnimation = TuffGolemAnimations.HOLD_END.bake(root);
        this.holdingAnimation = TuffGolemAnimations.HOLD.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 20).addBox(-5.0f, -12.0f, -4.0f, 10.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 40).addBox(-1.0f, -7.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition carpet = body.addOrReplaceChild("carpet", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -14.0f, 10.0f, 6.0f, 14.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)4.0f));
        PartDefinition carpet2 = body.addOrReplaceChild("carpet2", CubeListBuilder.create().texOffs(6, 6).addBox(-5.0f, 0.0f, -8.0f, 10.0f, 6.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)4.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(37, 20).addBox(-1.5f, -2.0f, -2.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.5f, (float)-4.0f, (float)0.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(37, 20).addBox(-1.5f, -2.0f, -2.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.5f, (float)-4.0f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(36, 33).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-4.0f, (float)0.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(36, 33).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-4.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(TuffGolemRenderState state) {
        super.setupAnim((Object)state);
        boolean flag = state.rightHandItem.isEmpty() && state.leftHandItem.isEmpty();
        this.carpet.visible = !flag;
        this.carpet2.visible = flag;
        if (flag) {
            this.walkAnimation.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 2.0f, 2.5f);
        } else {
            this.HoldingwalkAnimation.applyWalk(state.walkAnimationPos, state.walkAnimationSpeed, 2.0f, 2.5f);
        }
        this.holdingAnimation.apply(state.holdAnimationState, state.ageInTicks);
        this.DropAnimation.apply(state.dropAnimationState, state.ageInTicks);
        this.pickUpAnimation.apply(state.pickupAnimationState, state.ageInTicks);
    }

    public ModelPart getHead() {
        return this.body;
    }
}

