/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.copper_age_plus.util;

import com.belgie.copper_age_plus.common.entity.tuffgolem.TuffGolemEntity;
import com.belgie.copper_age_plus.core.BlockRegistry;
import com.belgie.copper_age_plus.core.EntityRegistry;
import com.belgie.copper_age_plus.core.ItemRegistry;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class ModEvents {
    public static BlockPattern MY_GOLEM_PATTERN = BlockPatternBuilder.start().aisle(new String[]{"^", "#"}).where('^', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.CARVED_PUMPKIN))).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.TUFF))).build();

    public static void onItemTick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos blockpos = event.getPos();
        BlockState blockstate = level.getBlockState(blockpos);
        if (event.getItemStack().is(ItemRegistry.COPPER_DUST) && (blockstate.getBlock() instanceof SoulFireBlock || blockstate.getBlock() instanceof FireBlock && !((Boolean)blockstate.getValue((Property)FireBlock.NORTH)).booleanValue() && !((Boolean)blockstate.getValue((Property)FireBlock.EAST)).booleanValue() && !((Boolean)blockstate.getValue((Property)FireBlock.WEST)).booleanValue() && !((Boolean)blockstate.getValue((Property)FireBlock.SOUTH)).booleanValue() && !((Boolean)blockstate.getValue((Property)FireBlock.UP)).booleanValue())) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverplayer, blockpos, event.getItemStack());
            }
            event.getItemStack().consume(1, (LivingEntity)player);
            player.swing(player.getUsedItemHand());
            level.setBlock(blockpos, ((Block)BlockRegistry.GREEN_FIRE.get()).defaultBlockState(), 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
            level.levelEvent((Entity)player, 3003, blockpos, 0);
        }
    }

    public static void onPumpkinPlaced(BlockEvent.EntityPlaceEvent event) {
        BlockPos pos;
        ServerLevel level;
        BlockPattern.BlockPatternMatch match;
        LevelAccessor levelAccessor;
        if (event.getPlacedBlock().is(Blocks.CARVED_PUMPKIN) && (levelAccessor = event.getLevel()) instanceof ServerLevel && (match = MY_GOLEM_PATTERN.find((LevelReader)(level = (ServerLevel)levelAccessor), pos = event.getPos())) != null) {
            for (int i = 0; i < MY_GOLEM_PATTERN.getWidth(); ++i) {
                for (int j = 0; j < MY_GOLEM_PATTERN.getHeight(); ++j) {
                    for (int k = 0; k < MY_GOLEM_PATTERN.getDepth(); ++k) {
                        BlockInWorld blockInWorld = match.getBlock(i, j, k);
                        level.setBlock(blockInWorld.getPos(), Blocks.AIR.defaultBlockState(), 2);
                        level.levelEvent(2001, blockInWorld.getPos(), Block.getId((BlockState)blockInWorld.getState()));
                    }
                }
            }
            TuffGolemEntity golem = (TuffGolemEntity)EntityRegistry.TUFF_GOLEM.get().create((Level)level, EntitySpawnReason.TRIGGERED);
            if (golem != null) {
                BlockPos spawnPos = match.getBlock(0, 1, 0).getPos();
                golem.snapTo((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
                golem.getBrain().setMemory(MemoryModuleType.HOME, (Object)GlobalPos.of((ResourceKey)golem.level().dimension(), (BlockPos)golem.blockPosition()));
                level.addFreshEntity((Entity)golem);
            }
        }
    }

    public static void onBrushTick(LivingEntityUseItemEvent.Tick event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        ItemStack stack = event.getItem();
        if (!stack.is(Items.BRUSH)) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (level.isClientSide()) {
            return;
        }
        if (event.getDuration() == event.getItem().getUseDuration((LivingEntity)player) - 60) {
            HitResult hit = player.pick(5.0, 0.0f, false);
            if (!(hit instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult blockHit = (BlockHitResult)hit;
            BlockPos pos = blockHit.getBlockPos();
            BlockState state = level.getBlockState(pos);
            if (state.getBlock() instanceof WeatheringCopper) {
                WeatheringCopper.getPrevious((BlockState)state).ifPresent(previous -> {
                    level.setBlockAndUpdate(pos, previous);
                    level.playSound(null, pos, SoundEvents.BRUSH_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.levelEvent(3005, pos, 0);
                    ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.325, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.325, new ItemStack((ItemLike)ItemRegistry.COPPER_DUST.get(), 2));
                    itementity.setDeltaMovement(0.05 + level.random.nextDouble() * 0.02, 0.05, 0.05 + level.random.nextDouble() * 0.02);
                    level.addFreshEntity((Entity)itementity);
                    stack.hurtAndBreak(4, (LivingEntity)player, EquipmentSlot.MAINHAND);
                });
            }
        }
    }
}

