/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.guir.config.sub;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Field;
import net.lopymine.guir.client.GUIRecorderClient;
import net.lopymine.guir.config.GUIRecorderConfig;
import net.lopymine.guir.config.sub.GUIElements;
import net.lopymine.guir.utils.CodecUtils;

public class GUIRecorderRenderingElementsConfig {
    public static final Codec<GUIRecorderRenderingElementsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("show_in_game_hud", true, Codec.BOOL, GUIRecorderRenderingElementsConfig::isShowInGameHud), CodecUtils.option("show_background", true, Codec.BOOL, GUIRecorderRenderingElementsConfig::isShowBackground), CodecUtils.option("show_cursor", true, Codec.BOOL, GUIRecorderRenderingElementsConfig::isShowCursor), CodecUtils.option("show_recording_icon", true, Codec.BOOL, GUIRecorderRenderingElementsConfig::isShowRecordingIcon), CodecUtils.option("show_slot_highlighting", true, Codec.BOOL, GUIRecorderRenderingElementsConfig::isShowSlotHighlighting), CodecUtils.option("show_cursor_stack", true, Codec.BOOL, GUIRecorderRenderingElementsConfig::isShowCursorStack), CodecUtils.option("show_tooltip", true, Codec.BOOL, GUIRecorderRenderingElementsConfig::isShowTooltip)).apply((Applicative)instance, GUIRecorderRenderingElementsConfig::new));
    private boolean showInGameHud;
    private boolean showBackground;
    private boolean showCursor;
    private boolean showRecordingIcon;
    private boolean showSlotHighlighting;
    private boolean showCursorStack;
    private boolean showTooltip;

    private GUIRecorderRenderingElementsConfig() {
        throw new IllegalArgumentException();
    }

    public static GUIRecorderRenderingElementsConfig getNewInstance() {
        return CodecUtils.parseNewInstanceHacky(CODEC);
    }

    public void bump() {
        for (Field field : this.getClass().getDeclaredFields()) {
            String name = GUIRecorderRenderingElementsConfig.toEnumName(field.getName().replace("show", ""));
            if (name.equalsIgnoreCase("c_o_d_e_c")) continue;
            try {
                GUIElements element = GUIElements.valueOf(name);
                boolean show = (Boolean)field.get(this);
                element.setEnabled(show);
            }
            catch (Exception e) {
                GUIRecorderConfig.LOGGER.error("Unknown enum GUI element \"{}\"!", (Object)name);
            }
        }
    }

    public static String toEnumName(String input) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                result.append('_');
            }
            result.append(Character.toUpperCase(c));
        }
        return result.toString();
    }

    public boolean getForElement(GUIElements element) {
        for (Field field : this.getClass().getDeclaredFields()) {
            String name = GUIRecorderRenderingElementsConfig.toEnumName(field.getName().replace("show", ""));
            if (!name.equalsIgnoreCase(element.name().toLowerCase())) continue;
            try {
                field.setAccessible(true);
                return (Boolean)field.get(this);
            }
            catch (Exception e) {
                GUIRecorderClient.LOGGER.error("Failed to get value for enum with name \"{}\"!", (Object)element.name().toLowerCase(), (Object)e);
                return false;
            }
        }
        return false;
    }

    public void setForElement(GUIElements element, boolean value) {
        for (Field field : this.getClass().getDeclaredFields()) {
            String name = GUIRecorderRenderingElementsConfig.toEnumName(field.getName().replace("show", ""));
            if (!name.equalsIgnoreCase(element.name().toLowerCase())) continue;
            try {
                field.setAccessible(true);
                field.set(this, value);
                element.setEnabled(value);
                break;
            }
            catch (Exception e) {
                GUIRecorderClient.LOGGER.error("Failed to set value for enum with name \"{}\"!", (Object)element.name().toLowerCase(), (Object)e);
            }
        }
    }

    private boolean isShowInGameHud() {
        return this.showInGameHud;
    }

    private boolean isShowBackground() {
        return this.showBackground;
    }

    private boolean isShowCursor() {
        return this.showCursor;
    }

    private boolean isShowRecordingIcon() {
        return this.showRecordingIcon;
    }

    private boolean isShowSlotHighlighting() {
        return this.showSlotHighlighting;
    }

    private boolean isShowCursorStack() {
        return this.showCursorStack;
    }

    private boolean isShowTooltip() {
        return this.showTooltip;
    }

    public void setShowInGameHud(boolean showInGameHud) {
        this.showInGameHud = showInGameHud;
    }

    public void setShowBackground(boolean showBackground) {
        this.showBackground = showBackground;
    }

    public void setShowCursor(boolean showCursor) {
        this.showCursor = showCursor;
    }

    public void setShowRecordingIcon(boolean showRecordingIcon) {
        this.showRecordingIcon = showRecordingIcon;
    }

    public void setShowSlotHighlighting(boolean showSlotHighlighting) {
        this.showSlotHighlighting = showSlotHighlighting;
    }

    public void setShowCursorStack(boolean showCursorStack) {
        this.showCursorStack = showCursorStack;
    }

    public void setShowTooltip(boolean showTooltip) {
        this.showTooltip = showTooltip;
    }

    public GUIRecorderRenderingElementsConfig(boolean showInGameHud, boolean showBackground, boolean showCursor, boolean showRecordingIcon, boolean showSlotHighlighting, boolean showCursorStack, boolean showTooltip) {
        this.showInGameHud = showInGameHud;
        this.showBackground = showBackground;
        this.showCursor = showCursor;
        this.showRecordingIcon = showRecordingIcon;
        this.showSlotHighlighting = showSlotHighlighting;
        this.showCursorStack = showCursorStack;
        this.showTooltip = showTooltip;
    }
}

