/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.guir.config;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.lopymine.guir.config.sub.GUIRecorderRecordingConfig;
import net.lopymine.guir.config.sub.GUIRecorderRenderingElementsConfig;
import net.lopymine.guir.utils.CodecUtils;
import net.lopymine.guir.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIRecorderConfig {
    public static final Codec<GUIRecorderConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("mod_enabled", true, Codec.BOOL, GUIRecorderConfig::isModEnabled), CodecUtils.option("debug_mode_enabled", false, Codec.BOOL, GUIRecorderConfig::isDebugModeEnabled), CodecUtils.option("recording", GUIRecorderRecordingConfig.getNewInstance(), GUIRecorderRecordingConfig.CODEC, GUIRecorderConfig::getRecordingConfig), CodecUtils.option("recording_elements", GUIRecorderRenderingElementsConfig.getNewInstance(), GUIRecorderRenderingElementsConfig.CODEC, GUIRecorderConfig::getElementsConfig)).apply((Applicative)instance, GUIRecorderConfig::new));
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("gui-recorder.json5").toFile();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"GUI Recorder/Config");
    private static GUIRecorderConfig INSTANCE;
    private boolean modEnabled;
    private boolean debugModeEnabled;
    private GUIRecorderRecordingConfig recordingConfig;
    private GUIRecorderRenderingElementsConfig elementsConfig;

    private GUIRecorderConfig() {
        throw new IllegalArgumentException();
    }

    public static GUIRecorderConfig getInstance() {
        return INSTANCE == null ? GUIRecorderConfig.reload() : INSTANCE;
    }

    public static GUIRecorderConfig reload() {
        GUIRecorderConfig config = GUIRecorderConfig.read();
        config.getElementsConfig().bump();
        INSTANCE = config;
        return INSTANCE;
    }

    public static GUIRecorderConfig getNewInstance() {
        return CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static GUIRecorderConfig read() {
        return ConfigUtils.readConfig(CODEC, CONFIG_FILE, LOGGER);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig(this, CODEC, CONFIG_FILE, LOGGER);
    }

    public boolean isModEnabled() {
        return this.modEnabled;
    }

    public boolean isDebugModeEnabled() {
        return this.debugModeEnabled;
    }

    public GUIRecorderRecordingConfig getRecordingConfig() {
        return this.recordingConfig;
    }

    public GUIRecorderRenderingElementsConfig getElementsConfig() {
        return this.elementsConfig;
    }

    public void setModEnabled(boolean modEnabled) {
        this.modEnabled = modEnabled;
    }

    public void setDebugModeEnabled(boolean debugModeEnabled) {
        this.debugModeEnabled = debugModeEnabled;
    }

    public void setRecordingConfig(GUIRecorderRecordingConfig recordingConfig) {
        this.recordingConfig = recordingConfig;
    }

    public void setElementsConfig(GUIRecorderRenderingElementsConfig elementsConfig) {
        this.elementsConfig = elementsConfig;
    }

    public GUIRecorderConfig(boolean modEnabled, boolean debugModeEnabled, GUIRecorderRecordingConfig recordingConfig, GUIRecorderRenderingElementsConfig elementsConfig) {
        this.modEnabled = modEnabled;
        this.debugModeEnabled = debugModeEnabled;
        this.recordingConfig = recordingConfig;
        this.elementsConfig = elementsConfig;
    }
}

