/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.guir.manager;

import net.lopymine.guir.utils.CroppedArea;

public class CroppingManager {
    private CroppedArea croppedArea = new CroppedArea(-1, -1, -1, -1);
    private boolean cropping;
    private boolean enabled;
    private static final CroppingManager INSTANCE = new CroppingManager();
    private int bufferWidth;
    private int bufferHeight;

    private CroppingManager() {
    }

    public static CroppingManager getInstance() {
        return INSTANCE;
    }

    public void startSelection() {
        this.cropping = true;
        this.enabled = true;
        this.croppedArea = new CroppedArea(-1, -1, -1, -1);
    }

    public void clearSelection() {
        this.enabled = false;
        this.cropping = false;
        this.croppedArea = new CroppedArea(-1, -1, -1, -1);
    }

    public void pos(int x, int y) {
        if (this.croppedArea.getFromX() == -1) {
            this.croppedArea.setFromX(x);
            this.croppedArea.setFromY(y);
        } else {
            this.croppedArea.setToX(x);
            this.croppedArea.setToY(y);
            this.cropping = false;
        }
    }

    public void resize(int bufferWidth, int bufferHeight) {
        int toY;
        int fromY;
        int toX;
        int oldWidth = this.bufferWidth;
        int oldHeight = this.bufferHeight;
        this.bufferWidth = bufferWidth;
        this.bufferHeight = bufferHeight;
        float dx = (float)bufferWidth / (float)oldWidth;
        float dy = (float)bufferHeight / (float)oldHeight;
        int fromX = this.croppedArea.getFromX();
        if (fromX != -1) {
            this.croppedArea.setFromX((int)((float)fromX * dx));
        }
        if ((toX = this.croppedArea.getToX()) != -1) {
            this.croppedArea.setToX((int)((float)toX * dx));
        }
        if ((fromY = this.croppedArea.getFromY()) != -1) {
            this.croppedArea.setFromY((int)((float)fromY * dy));
        }
        if ((toY = this.croppedArea.getToY()) != -1) {
            this.croppedArea.setToY((int)((float)toY * dy));
        }
    }

    public void finishAnyway() {
        if (this.croppedArea.getFromX() != -1 && this.croppedArea.getFromY() != -1 && this.croppedArea.getToX() == -1 && this.croppedArea.getToY() == -1) {
            this.clearSelection();
        }
    }

    public CroppedArea getCroppedArea() {
        return this.croppedArea;
    }

    public boolean isCropping() {
        return this.cropping;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getBufferWidth() {
        return this.bufferWidth;
    }

    public int getBufferHeight() {
        return this.bufferHeight;
    }

    public void setCroppedArea(CroppedArea croppedArea) {
        this.croppedArea = croppedArea;
    }

    public void setCropping(boolean cropping) {
        this.cropping = cropping;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBufferWidth(int bufferWidth) {
        this.bufferWidth = bufferWidth;
    }

    public void setBufferHeight(int bufferHeight) {
        this.bufferHeight = bufferHeight;
    }
}

