/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.guir.manager;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.lopymine.guir.client.GUIRecorderClient;
import net.lopymine.guir.config.GUIRecorderConfig;
import net.minecraft.class_156;
import org.jetbrains.annotations.Nullable;

public class FFMpegManager {
    @Nullable
    private static Boolean FFMPEG_AVAILABLE = null;

    public static void convert(File inputDir, File outputDir, Consumer<Integer> consumer, String ... args) {
        if (FFMPEG_AVAILABLE == null || !FFMPEG_AVAILABLE.booleanValue()) {
            GUIRecorderClient.LOGGER.error("Cannot run FFMpeg because it was not found!");
            return;
        }
        if (!inputDir.isDirectory()) {
            return;
        }
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            return;
        }
        int exitCode = -1010101010;
        try {
            exitCode = FFMpegManager.runFFMpegAndGetExitCode(inputDir.toPath(), outputDir.toPath(), args);
        }
        catch (Exception e) {
            GUIRecorderClient.LOGGER.error("Failed to convert frames using FFMpeg:", (Throwable)e);
        }
        consumer.accept(exitCode);
    }

    private static int runFFMpegAndGetExitCode(Path inputDir, Path outputDir, String[] args) throws IOException, InterruptedException {
        GUIRecorderConfig config = GUIRecorderConfig.getInstance();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("ffmpeg");
        commands.add("-y");
        commands.add("-i");
        commands.add(inputDir.resolve(config.getRecordingConfig().getFrameNamePattern()).toAbsolutePath().toString());
        commands.addAll(Arrays.asList(args));
        commands.add(outputDir.resolve("%s_recording.%s".formatted(class_156.method_44893(), config.getRecordingConfig().getResultFileExtension())).toAbsolutePath().toString());
        if (config.isDebugModeEnabled()) {
            GUIRecorderClient.LOGGER.info("FFMPeg Commands:");
        }
        for (String command : commands) {
            if (!config.isDebugModeEnabled()) continue;
            GUIRecorderClient.LOGGER.info(command);
        }
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        FFMpegManager.listenFFMpegOutput(process, config);
        return process.waitFor();
    }

    public static boolean isFFMpegAvailable() {
        if (FFMPEG_AVAILABLE != null) {
            return FFMPEG_AVAILABLE;
        }
        CompletableFuture.runAsync(() -> {
            GUIRecorderConfig config = GUIRecorderConfig.getInstance();
            try {
                ProcessBuilder builder = new ProcessBuilder("ffmpeg", "-version");
                builder.redirectErrorStream(true);
                Process process = builder.start();
                FFMpegManager.listenFFMpegOutput(process, config);
                FFMPEG_AVAILABLE = process.waitFor() == 0;
            }
            catch (Exception e) {
                if (config.isDebugModeEnabled()) {
                    GUIRecorderClient.LOGGER.info("Failed to check FFMpeg available:", (Throwable)e);
                }
                FFMPEG_AVAILABLE = false;
            }
        });
        return false;
    }

    private static void listenFFMpegOutput(Process process, GUIRecorderConfig config) {
        CompletableFuture.runAsync(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while (process.isAlive() && (line = reader.readLine()) != null) {
                    if (!config.isDebugModeEnabled()) continue;
                    GUIRecorderClient.LOGGER.info(line);
                }
            }
            catch (IOException e) {
                GUIRecorderClient.LOGGER.error("Failed to read FFMpeg output logs:", (Throwable)e);
            }
        });
    }
}

