/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.guir.yacl.base;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.lopymine.guir.utils.ModMenuUtils;
import net.lopymine.guir.yacl.extension.YACLAPIExtension;
import net.lopymine.guir.yacl.utils.SimpleContent;
import net.minecraft.class_2561;

public class SimpleOption {
    public static <T> Builder<T> startBuilder(String optionId) {
        return new Builder(optionId);
    }

    public static ButtonBuilder startButtonBuilder(String optionId, BiConsumer<YACLScreen, ButtonOption> biConsumer) {
        return new ButtonBuilder(optionId, biConsumer);
    }

    public static <T> ListOptionBuilder<T> startListBuilder(String optionId) {
        return new ListOptionBuilder(optionId);
    }

    public static class Builder<T> {
        private final String optionId;
        private final String optionKey;
        private final Option.Builder<T> optionBuilder;

        public Builder(String optionId) {
            this.optionId = optionId;
            this.optionKey = ModMenuUtils.getOptionKey(optionId);
            this.optionBuilder = Option.createBuilder().name((class_2561)ModMenuUtils.getName(this.optionKey));
        }

        public Builder<T> withCustomDescription(ImageRenderer renderer) {
            OptionDescription.Builder builder = OptionDescription.createBuilder().customImage(renderer);
            this.optionBuilder.description(builder.build());
            return this;
        }

        public Builder<T> withDescription(SimpleContent content) {
            OptionDescription.Builder builder = OptionDescription.createBuilder().text(new class_2561[]{ModMenuUtils.getDescription(this.optionKey)});
            if (content == SimpleContent.IMAGE) {
                builder.image(ModMenuUtils.getContentId(content, this.optionId), 500, 500);
            }
            if (content == SimpleContent.WEBP) {
                builder.webpImage(ModMenuUtils.getContentId(content, this.optionId));
            }
            this.optionBuilder.description(builder.build());
            return this;
        }

        public Builder<T> withBinding(Binding<T> binding, boolean instant) {
            YACLAPIExtension.bindingE(this.optionBuilder, binding, instant);
            return this;
        }

        public Builder<T> withBinding(T def, Supplier<T> getter, Consumer<T> setter, boolean instant) {
            YACLAPIExtension.bindingE(this.optionBuilder, Binding.generic(def, getter, setter), instant);
            return this;
        }

        public Option<T> build() {
            return this.optionBuilder.build();
        }

        public Option.Builder<T> getOptionBuilder() {
            return this.optionBuilder;
        }
    }

    public static class ButtonBuilder {
        private final String optionId;
        private final String optionKey;
        private final ButtonOption.Builder optionBuilder;

        public ButtonBuilder(String optionId, BiConsumer<YACLScreen, ButtonOption> biConsumer) {
            this.optionId = optionId;
            this.optionKey = ModMenuUtils.getOptionKey(optionId);
            this.optionBuilder = ButtonOption.createBuilder().name((class_2561)ModMenuUtils.getName(this.optionKey)).action(biConsumer);
        }

        public ButtonBuilder withCustomDescription(ImageRenderer renderer) {
            OptionDescription.Builder builder = OptionDescription.createBuilder().customImage(renderer);
            this.optionBuilder.description(builder.build());
            return this;
        }

        public ButtonBuilder withDescription(SimpleContent content) {
            OptionDescription.Builder builder = OptionDescription.createBuilder().text(new class_2561[]{ModMenuUtils.getDescription(this.optionKey)});
            if (content == SimpleContent.IMAGE) {
                builder.image(ModMenuUtils.getContentId(content, this.optionId), 500, 500);
            }
            if (content == SimpleContent.WEBP) {
                builder.webpImage(ModMenuUtils.getContentId(content, this.optionId));
            }
            this.optionBuilder.description(builder.build());
            return this;
        }

        public ButtonOption build() {
            return this.optionBuilder.build();
        }

        public ButtonOption.Builder getOptionBuilder() {
            return this.optionBuilder;
        }
    }

    public static class ListOptionBuilder<T> {
        private final String optionId;
        private final String optionKey;
        private final ListOption.Builder<T> optionBuilder;

        public ListOptionBuilder(String optionId) {
            this.optionId = optionId;
            this.optionKey = ModMenuUtils.getGroupKey(optionId);
            this.optionBuilder = ListOption.createBuilder().name((class_2561)ModMenuUtils.getName(this.optionKey));
        }

        public ListOptionBuilder<T> withCustomDescription(ImageRenderer renderer) {
            OptionDescription.Builder builder = OptionDescription.createBuilder().customImage(renderer);
            this.optionBuilder.description(builder.build());
            return this;
        }

        public ListOptionBuilder<T> withDescription(SimpleContent content) {
            OptionDescription.Builder builder = OptionDescription.createBuilder().text(new class_2561[]{ModMenuUtils.getDescription(this.optionKey)});
            if (content == SimpleContent.IMAGE) {
                builder.image(ModMenuUtils.getContentId(content, this.optionId), 500, 500);
            }
            if (content == SimpleContent.WEBP) {
                builder.webpImage(ModMenuUtils.getContentId(content, this.optionId));
            }
            this.optionBuilder.description(builder.build());
            return this;
        }

        public ListOptionBuilder<T> withBinding(Binding<List<T>> binding, boolean instant) {
            YACLAPIExtension.bindingE(this.optionBuilder, binding, instant);
            return this;
        }

        public ListOptionBuilder<T> withBinding(List<T> def, Supplier<List<T>> getter, Consumer<List<T>> setter, boolean instant) {
            YACLAPIExtension.bindingE(this.optionBuilder, Binding.generic(def, getter, setter), instant);
            return this;
        }

        public ListOption.Builder<T> getOptionBuilder() {
            return this.optionBuilder;
        }
    }
}

