/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.guir.yacl.extension;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.StateManager;
import java.util.List;
import java.util.NoSuchElementException;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.impl.util.version.StringVersion;
import net.lopymine.guir.yacl.state.PreviewStateManager;

public class YACLAPIExtension {
    private static final String STATE_MANAGER_VERSION = "3.6.0";

    public static <A> ListOption.Builder<A> bindingE(ListOption.Builder<A> builder, Binding<List<A>> binding, boolean instant) {
        Version currentYACLVersion = YACLAPIExtension.getCurrentYACLVersion();
        if (currentYACLVersion.compareTo((Object)YACLAPIExtension.getVersion(STATE_MANAGER_VERSION)) >= 0) {
            builder.state((StateManager)(instant ? new PreviewStateManager<List<A>>(binding) : StateManager.createSimple(binding)));
        } else {
            builder.binding(binding);
        }
        return builder;
    }

    public static <A> Option.Builder<A> bindingE(Option.Builder<A> builder, Binding<A> binding, boolean instant) {
        Version currentYACLVersion = YACLAPIExtension.getCurrentYACLVersion();
        if (currentYACLVersion.compareTo((Object)YACLAPIExtension.getVersion(STATE_MANAGER_VERSION)) >= 0) {
            builder.stateManager((StateManager)(instant ? new PreviewStateManager<A>(binding) : StateManager.createSimple(binding)));
        } else {
            builder.binding(binding);
            builder.instant(instant);
        }
        return builder;
    }

    private static Version getCurrentYACLVersion() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("yet_another_config_lib_v3").orElseThrow(() -> new NoSuchElementException("Failed to find Yet Another Config Lib [YACL], this shouldn't happen! Please report this crash to discord server of %s mod!".formatted("GUI Recorder")))).getMetadata().getVersion();
    }

    private static Version getVersion(String version) {
        try {
            return Version.parse((String)version);
        }
        catch (Exception ignored) {
            return new StringVersion("1.0.0");
        }
    }
}

