/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.guir.yacl.state;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.StateManager;
import dev.isxander.yacl3.impl.ProvidesBindingForDeprecation;

public class PreviewStateManager<T>
implements StateManager<T>,
ProvidesBindingForDeprecation<T> {
    private final T previousValue;
    private T pendingValue;
    private final Binding<T> binding;
    private StateManager.StateListener<T> stateListener;
    private boolean shouldSave = false;

    public PreviewStateManager(Binding<T> binding) {
        this.binding = binding;
        this.previousValue = binding.getValue();
        this.pendingValue = binding.getValue();
        this.stateListener = StateManager.StateListener.noop();
    }

    public void set(T value) {
        boolean changed = !this.pendingValue.equals(value);
        boolean previousValue = this.previousValue.equals(value);
        this.binding.setValue(value);
        this.pendingValue = value;
        if (previousValue) {
            this.shouldSave = false;
        }
        if (changed && !previousValue) {
            this.shouldSave = true;
        }
        if (changed) {
            this.stateListener.onStateChange(this.pendingValue, value);
        }
    }

    public T get() {
        return this.pendingValue;
    }

    public void apply() {
        this.shouldSave = false;
    }

    public void resetToDefault(StateManager.ResetAction action) {
        this.set(this.binding.defaultValue());
    }

    public void sync() {
        this.set(this.previousValue);
    }

    public boolean isSynced() {
        return !this.shouldSave;
    }

    public boolean isDefault() {
        return this.binding.defaultValue().equals(this.pendingValue);
    }

    public void addListener(StateManager.StateListener<T> stateListener) {
        this.stateListener = this.stateListener.andThen(stateListener);
    }

    public Binding<T> getBinding() {
        return this.binding;
    }
}

