/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.guir.config.sub;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.lopymine.guir.utils.CodecUtils;

public class GUIRecorderRecordingConfig {
    public static final Codec<GUIRecorderRecordingConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("frame_name_pattern", "frame_%06d.png", Codec.STRING, GUIRecorderRecordingConfig::getFrameNamePattern), CodecUtils.option("result_file_extension", "webp", Codec.STRING, GUIRecorderRecordingConfig::getResultFileExtension), CodecUtils.option("ffmpeg_args", "-lossless 1 -loop 0", Codec.STRING, GUIRecorderRecordingConfig::getFfmpegArgs), CodecUtils.option("fps", 24, Codec.INT, GUIRecorderRecordingConfig::getFps), CodecUtils.option("create_backup_for_last_frames", false, Codec.BOOL, GUIRecorderRecordingConfig::isCreateBackupForLastFrames)).apply((Applicative)instance, GUIRecorderRecordingConfig::new));
    private String frameNamePattern;
    private String resultFileExtension;
    private String ffmpegArgs;
    private int fps;
    private boolean createBackupForLastFrames;

    private GUIRecorderRecordingConfig() {
        throw new IllegalArgumentException();
    }

    public static GUIRecorderRecordingConfig getNewInstance() {
        return CodecUtils.parseNewInstanceHacky(CODEC);
    }

    public String getFrameNamePattern() {
        return this.frameNamePattern;
    }

    public String getResultFileExtension() {
        return this.resultFileExtension;
    }

    public String getFfmpegArgs() {
        return this.ffmpegArgs;
    }

    public int getFps() {
        return this.fps;
    }

    public boolean isCreateBackupForLastFrames() {
        return this.createBackupForLastFrames;
    }

    public void setFrameNamePattern(String frameNamePattern) {
        this.frameNamePattern = frameNamePattern;
    }

    public void setResultFileExtension(String resultFileExtension) {
        this.resultFileExtension = resultFileExtension;
    }

    public void setFfmpegArgs(String ffmpegArgs) {
        this.ffmpegArgs = ffmpegArgs;
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public void setCreateBackupForLastFrames(boolean createBackupForLastFrames) {
        this.createBackupForLastFrames = createBackupForLastFrames;
    }

    public GUIRecorderRecordingConfig(String frameNamePattern, String resultFileExtension, String ffmpegArgs, int fps, boolean createBackupForLastFrames) {
        this.frameNamePattern = frameNamePattern;
        this.resultFileExtension = resultFileExtension;
        this.ffmpegArgs = ffmpegArgs;
        this.fps = fps;
        this.createBackupForLastFrames = createBackupForLastFrames;
    }
}

