/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.guir.manager;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.lopymine.guir.client.GUIRecorderClient;
import net.lopymine.guir.config.GUIRecorderConfig;
import net.lopymine.guir.manager.CroppingManager;
import net.lopymine.guir.manager.FFMpegManager;
import net.lopymine.guir.utils.CroppedArea;
import net.lopymine.guir.utils.ScreenshotUtils;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class GUIRecordingManager {
    private static GUIRecordingManager INSTANCE;
    private final File framesFolder;
    private File resultFolder;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final AtomicInteger savedImages = new AtomicInteger(0);
    private boolean recording = false;
    private long frameIntervalNanos;
    private long nextCaptureTimeNanos;
    private String fileNamePattern;
    private boolean canStart = true;
    private boolean screenshot;

    private GUIRecordingManager() {
        this.framesFolder = FabricLoader.getInstance().getGameDir().resolve(".cache").resolve("gui-recorder").toFile();
    }

    public static GUIRecordingManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GUIRecordingManager();
        }
        return INSTANCE;
    }

    public void startScreenshotMode() {
        if (this.recording || !this.canStart) {
            return;
        }
        this.start();
        this.screenshot = true;
    }

    public void start() {
        if (this.recording || !this.canStart) {
            return;
        }
        this.fileNamePattern = GUIRecorderConfig.getInstance().getRecordingConfig().getFrameNamePattern();
        try {
            String string = this.fileNamePattern.formatted(1);
        }
        catch (Exception e) {
            GUIRecorderClient.LOGGER.error("Cannot start recording, wrong file name pattern!");
            return;
        }
        this.frameIntervalNanos = 1000000000L / (long)Math.max(1, GUIRecorderConfig.getInstance().getRecordingConfig().getFps());
        this.nextCaptureTimeNanos = System.nanoTime();
        this.savedImages.set(0);
        this.counter.set(0);
        CroppingManager.getInstance().finishAnyway();
        File file = FabricLoader.getInstance().getGameDir().resolve("gui-recorder").toFile();
        if (!file.exists()) {
            if (!file.mkdirs()) {
                GUIRecorderClient.LOGGER.error("Failed to create folder for final recording files!");
                this.resultFolder = FabricLoader.getInstance().getGameDir().toFile();
            } else {
                this.resultFolder = file;
            }
        } else {
            this.resultFolder = file;
        }
        if (!this.framesFolder.exists()) {
            try {
                Files.createDirectories(this.framesFolder.toPath(), new FileAttribute[0]);
                GUIRecorderClient.LOGGER.info("Successfully created folder for new frames");
            }
            catch (Exception e) {
                GUIRecorderClient.LOGGER.error("Failed to create folder for new frames!", (Throwable)e);
            }
        }
        this.recording = true;
    }

    public void stop() {
        this.recording = false;
    }

    public void stopScreenshotMode() {
        this.recording = false;
        this.screenshot = false;
    }

    private void deleteFrames() {
        if (GUIRecorderConfig.getInstance().getRecordingConfig().isCreateBackupForLastFrames()) {
            Path path = this.framesFolder.toPath();
            try {
                Path backupPath = FabricLoader.getInstance().getGameDir().resolve(this.framesFolder.getName() + "-latest-backup");
                if (Files.exists(backupPath, new LinkOption[0])) {
                    this.deleteFrames(backupPath);
                    if (Files.exists(backupPath, new LinkOption[0])) {
                        return;
                    }
                }
                Files.move(path, backupPath, new CopyOption[0]);
            }
            catch (Exception e) {
                GUIRecorderClient.LOGGER.error("Failed to backup old frames!", (Throwable)e);
            }
        } else if (this.framesFolder.exists()) {
            this.deleteFrames(this.framesFolder.toPath());
        }
    }

    private void deleteFrames(Path folder) {
        try (Stream<Path> stream = Files.walk(folder, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (Exception e) {
                    GUIRecorderClient.LOGGER.error("Failed to delete old frame from \"{}\"!", (Object)folder.toAbsolutePath(), (Object)e);
                }
            });
        }
        catch (Exception e) {
            GUIRecorderClient.LOGGER.error("Failed to delete old frames from \"{}\"!", (Object)folder.toAbsolutePath(), (Object)e);
        }
    }

    public void save() {
        this.canStart = false;
        CompletableFuture.runAsync(() -> {
            while (this.savedImages.get() < this.counter.get()) {
                Thread.onSpinWait();
            }
            FFMpegManager.convert(this.framesFolder, this.resultFolder, code -> {
                if (code == -1010101010) {
                    GUIRecorderClient.LOGGER.info("Failed to run FFMpeg!");
                } else {
                    GUIRecorderClient.LOGGER.info("FFMpeg ended work with code \"{}\"", code);
                }
                this.deleteFrames();
                this.canStart = true;
            }, GUIRecorderConfig.getInstance().getRecordingConfig().getFfmpegArgs().split(" "));
        });
    }

    public void captureFrameBuffer(class_276 framebuffer) {
        if (!this.recording) {
            return;
        }
        if (framebuffer == null) {
            return;
        }
        long now = System.nanoTime();
        if (now < this.nextCaptureTimeNanos) {
            return;
        }
        this.nextCaptureTimeNanos += this.frameIntervalNanos;
        if (this.nextCaptureTimeNanos < now) {
            this.nextCaptureTimeNanos = now + this.frameIntervalNanos;
        }
        ScreenshotUtils.screenshot(framebuffer, image -> {
            class_1011 frame = this.getCroppedOrNot((class_1011)image, framebuffer);
            this.saveFrame(frame);
            if (this.screenshot) {
                this.stopScreenshotMode();
            }
        });
    }

    private void saveFrame(class_1011 frame) {
        File file = this.getFileForCurrentFrame(this.counter.getAndIncrement());
        class_156.method_27958().execute(() -> {
            try (class_1011 class_10112 = frame;){
                frame.method_4325(file);
                this.savedImages.incrementAndGet();
            }
            catch (IOException e) {
                GUIRecorderClient.LOGGER.error("Failed to save frame during active recording!", (Throwable)e);
            }
        });
    }

    @NotNull
    private File getFileForCurrentFrame(int id) {
        if (this.screenshot) {
            return new File(this.resultFolder, "%s_screenshot.png".formatted(class_156.method_44893()));
        }
        return new File(this.framesFolder, this.fileNamePattern.formatted(id));
    }

    private class_1011 getCroppedOrNot(class_1011 original, class_276 framebuffer) {
        if (!CroppingManager.getInstance().isCropping() && CroppingManager.getInstance().isEnabled()) {
            int textureWidth = framebuffer.field_1482;
            int textureHeight = framebuffer.field_1481;
            CroppedArea croppedArea = CroppingManager.getInstance().getCroppedArea();
            int x1 = croppedArea.getFromX();
            int y1 = croppedArea.getFromY();
            int x2 = croppedArea.getToX();
            int y2 = croppedArea.getToY();
            if (x1 < 0 || y1 < 0 || x2 < 0 || y2 < 0) {
                return original;
            }
            if (x1 > x2) {
                int xOne = x1;
                x1 = x2;
                x2 = xOne;
            }
            if (y1 > y2) {
                int yOne = y1;
                y1 = y2;
                y2 = yOne;
            }
            class_310 client = class_310.method_1551();
            int scaledWidth = client.method_22683().method_4486();
            int scaledHeight = client.method_22683().method_4502();
            double scaleX = (double)textureWidth / (double)scaledWidth;
            double scaleY = (double)textureHeight / (double)scaledHeight;
            int scaledX1 = (int)Math.max(0.0, Math.floor((double)(x1 + 2) * scaleX));
            int scaledY1 = (int)Math.max(0.0, Math.floor((double)(y1 + 2) * scaleY));
            int scaledX2 = (int)Math.min((double)textureWidth, Math.ceil((double)(x2 - 2) * scaleX));
            int scaledY2 = (int)Math.min((double)textureHeight, Math.ceil((double)(y2 - 2) * scaleY));
            int croppedWidth = scaledX2 - scaledX1;
            int croppedHeight = scaledY2 - scaledY1;
            if (croppedWidth <= 0 || croppedHeight <= 0) {
                return original;
            }
            class_1011 croppedImage = new class_1011(croppedWidth, croppedHeight, false);
            original.method_47594(croppedImage, scaledX1, scaledY1, 0, 0, croppedWidth, croppedHeight, false, false);
            original.close();
            return croppedImage;
        }
        return original;
    }

    public boolean isRecording() {
        return this.recording;
    }
}

