/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.guir.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Supplier;
import net.lopymine.guir.client.GUIRecorderClient;
import net.lopymine.guir.manager.GUIRecordingBufferManager;
import net.lopymine.guir.manager.GUIRecordingManager;
import net.minecraft.class_11228;
import net.minecraft.class_276;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_11228.class})
public class GuiRendererMixin {
    @Unique
    private boolean capture;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;getFramebuffer()Lnet/minecraft/client/gl/Framebuffer;")}, method={"renderPreparedDraws"})
    private void clearBeforeRender(GpuBufferSlice fogBuffer, CallbackInfo ci) {
        if (!GUIRecorderClient.isRecording()) {
            return;
        }
        class_276 recordingBuffer = GUIRecordingBufferManager.getBuffer();
        RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(recordingBuffer.method_30277(), 0, recordingBuffer.method_30278(), 1.0);
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/render/GuiRenderer;render(Ljava/util/function/Supplier;Lnet/minecraft/client/gl/Framebuffer;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lcom/mojang/blaze3d/buffers/GpuBuffer;Lcom/mojang/blaze3d/vertex/VertexFormat$IndexType;II)V", ordinal=0)}, method={"renderPreparedDraws"})
    private void captureBeforeBlur(class_11228 instance, Supplier<String> nameSupplier, class_276 framebuffer, GpuBufferSlice fogBuffer, GpuBufferSlice dynamicTransformsBuffer, GpuBuffer buffer, VertexFormat.class_5595 indexType, int from, int _to, Operation<Void> original) {
        original.call(new Object[]{instance, nameSupplier, framebuffer, fogBuffer, dynamicTransformsBuffer, buffer, indexType, from, _to});
        if (!GUIRecorderClient.isRecording()) {
            return;
        }
        class_276 recordingBuffer = GUIRecordingBufferManager.getBuffer();
        original.call(new Object[]{instance, nameSupplier, recordingBuffer, fogBuffer, dynamicTransformsBuffer, buffer, indexType, from, _to});
        this.capture = true;
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/render/GuiRenderer;render(Ljava/util/function/Supplier;Lnet/minecraft/client/gl/Framebuffer;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lcom/mojang/blaze3d/buffers/GpuBuffer;Lcom/mojang/blaze3d/vertex/VertexFormat$IndexType;II)V", ordinal=1)}, method={"renderPreparedDraws"})
    private void captureAfterBlur(class_11228 instance, Supplier<String> nameSupplier, class_276 framebuffer, GpuBufferSlice fogBuffer, GpuBufferSlice dynamicTransformsBuffer, GpuBuffer buffer, VertexFormat.class_5595 indexType, int from, int _to, Operation<Void> original) {
        original.call(new Object[]{instance, nameSupplier, framebuffer, fogBuffer, dynamicTransformsBuffer, buffer, indexType, from, _to});
        if (!GUIRecorderClient.isRecording()) {
            return;
        }
        class_276 recordingBuffer = GUIRecordingBufferManager.getBuffer();
        RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(recordingBuffer.method_30278(), 1.0);
        original.call(new Object[]{instance, nameSupplier, recordingBuffer, fogBuffer, dynamicTransformsBuffer, buffer, indexType, from, _to});
        this.capture = true;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/render/GuiRenderer;renderPreparedDraws(Lcom/mojang/blaze3d/buffers/GpuBufferSlice;)V", shift=At.Shift.AFTER)}, method={"render(Lcom/mojang/blaze3d/buffers/GpuBufferSlice;)V"})
    private void captureFrame(GpuBufferSlice fogBuffer, CallbackInfo ci) {
        if (this.capture) {
            GUIRecordingManager.getInstance().captureFrameBuffer(GUIRecordingBufferManager.getBuffer());
            this.capture = false;
        }
    }
}

