/*
 * Decompiled with CFR 0.152.
 */
package com.xkingdark.kingsveinminer.helpers;

import java.io.InputStream;
import java.security.MessageDigest;
import java.util.UUID;
import net.minecraft.class_3262;

public class PackHashing {
    public static byte[] computePackHash() {
        byte[] byArray;
        block10: {
            InputStream input = class_3262.class.getResourceAsStream("/resourcepacks/kings-vein-miner.zip");
            try {
                int read;
                if (input == null) {
                    throw new IllegalStateException("Resource pack not found in JAR.");
                }
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                byte[] buffer = new byte[8192];
                while ((read = input.read(buffer)) != -1) {
                    sha1.update(buffer, 0, read);
                }
                byArray = sha1.digest();
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            input.close();
        }
        return byArray;
    }

    public static String toHex(byte[] digest) {
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static UUID calculateUUID(byte[] sha1) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(sha1[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(sha1[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }
}

