/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.config.mob$direction;

import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import dev.anye.core.color._ColorCDT;
import dev.anye.core.color._ColorSupport;
import dev.anye.core.json._JsonConfig;
import dev.anye.mc.nekoui.config.Configs;
import dev.anye.mc.nekoui.config.mob$direction.MobDirectionData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;

public class MobDirectionConfig
extends _JsonConfig<MobDirectionData> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String filePath = Configs.ConfigDir + "mob-direction.json";
    public static final MobDirectionConfig I = new MobDirectionConfig();

    public MobDirectionConfig() {
        super(filePath, "{\n                      \"enable\": true,\n                      \"dynamicDisplay\":true,\n                      \"poiShowRadius\":40,\n                      \"poiRadius\":22,\n                      \"poiSize\":11,\n                      \"poiMaxSize\": 9,\n                      \"poiMinSize\": 2,\n                      \"ratio\":-0.5,\n                      \"onlyLivingEntity\":true,\n                      \"notInListMode\":true,\n                      \"entityList\":{\n                          \"minecraft.chest_minecart\": true\n                      },\n                      \"defaultColor\":\"0xFF000000\",\n                      \"useEggColor\": false,\n                      \"eggLayerIndex\": 0,\n                      \"entityColors\":{\n                          \"minecraft.player\": \"0x56FFFFFF\",\n                          \"minecraft.chest_minecart\": \"0xFFFFFF00\"\n                      }\n                    }", (TypeToken)new TypeToken<MobDirectionData>(){});
        this.writeColor();
    }

    public void init() {
        super.init();
    }

    public MobDirectionData getDatas() {
        if (this.datas == null) {
            return new MobDirectionData();
        }
        return (MobDirectionData)this.datas;
    }

    public int getEntityColor(Entity entity) {
        if (entity != null) {
            ResourceLocation res = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            return this.getEntityColor(res.toLanguageKey());
        }
        return _ColorCDT.white;
    }

    public int getEntityColor(String entity) {
        return this.getDatas().getColor(entity);
    }

    public boolean isShowPoi(Entity entity) {
        if (entity != null) {
            ResourceLocation res = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            return this.isShowPoi(res.toLanguageKey());
        }
        return false;
    }

    public boolean isShowPoi(String entity) {
        return this.getDatas().isShow(entity);
    }

    public static int getEntityColor(MobCategory mobCategory) {
        return mobCategory == MobCategory.MONSTER ? _ColorCDT.red : (mobCategory.isPersistent() ? _ColorCDT.blue : (mobCategory.isFriendly() ? _ColorCDT.green : _ColorCDT.yellow));
    }

    public void writeColor() {
        BuiltInRegistries.ENTITY_TYPE.forEach(entityType -> {
            String eid = BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toLanguageKey();
            if (this.getDatas().getEntityColors().get(eid) == null) {
                int color = MobDirectionConfig.getEntityColor(entityType.getCategory());
                if (color == -1) {
                    return;
                }
                this.getDatas().getEntityColors().put(eid, _ColorSupport.intToHexColor((int)color));
            }
        });
        this.save();
    }

    public static ItemStack getSpawnEgg(EntityType<?> entity) {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        if (clientLevel instanceof ClientLevel) {
            ClientLevel clientLevel2 = clientLevel;
            for (SpawnEggItem eggItem : SpawnEggItem.eggs()) {
                if (eggItem.getType(ItemStack.EMPTY) != entity) continue;
                return new ItemStack((ItemLike)eggItem);
            }
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getSpawnEgg(Entity entity) {
        EntityType entityType = entity.getType();
        for (SpawnEggItem eggItem : SpawnEggItem.eggs()) {
            if (eggItem.getType(ItemStack.EMPTY) != entityType) continue;
            return new ItemStack((ItemLike)eggItem);
        }
        return ItemStack.EMPTY;
    }

    public static int[] getSpawnEggColors(ItemStack spawnEgg) {
        Item item = spawnEgg.getItem();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem spawnEggItem = (SpawnEggItem)item;
            int baseColor = -1;
            int overlayColor = -1;
            return new int[]{baseColor, overlayColor};
        }
        return new int[]{-1, -1};
    }

    public static int[] getSpawnEggColors(Entity spawnEgg) {
        return MobDirectionConfig.getSpawnEggColors(MobDirectionConfig.getSpawnEgg(spawnEgg));
    }

    public static int[] getSpawnEggColors(EntityType<?> spawnEgg) {
        return MobDirectionConfig.getSpawnEggColors(MobDirectionConfig.getSpawnEgg(spawnEgg));
    }
}

