/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.render;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.anye.core.format._FormatToString;
import dev.anye.mc.nekoui.config.health$bar.HealthBarConfig;
import dev.anye.mc.nekoui.render.RenderSupport;
import dev.anye.mc.nekoui.render.UniformCircleDistribution;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class MobHealthBar {
    private static final ResourceLocation HealthBar = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/hud/mob/health_bar.png");
    private static final RenderType HBRT = RenderType.text((ResourceLocation)HealthBar);
    private static double rotationAngle = 0.0;

    public static void render(LivingEntity livingEntity, LivingEntityRenderState renderState, SubmitNodeCollector submitNodeCollector, PoseStack poseStack) {
        if (HealthBarConfig.I.getDatas().enable) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.player != null && HealthBarConfig.I.getDatas().renderOnlyView && MobHealthBar.checkView(minecraft, livingEntity)) {
                if (livingEntity.distanceTo((Entity)minecraft.player) > (float)HealthBarConfig.I.getDatas().renderDistance) {
                    return;
                }
                Quaternionf camera = minecraft.getEntityRenderDispatcher().camera.rotation();
                if (HealthBarConfig.I.getDatas().renderHealthBar) {
                    float y = livingEntity.getBbHeight() + HealthBarConfig.I.getDatas().renderTop;
                    int h = Math.max((int)(livingEntity.getHealth() / livingEntity.getMaxHealth() * 121.0f), 0);
                    poseStack.pushPose();
                    poseStack.translate(0.0f, y, 0.0f);
                    poseStack.mulPose((Quaternionfc)camera);
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                    poseStack.scale(-0.0125f, -0.005f, 0.0125f);
                    submitNodeCollector.submitCustomGeometry(poseStack, HBRT, (pose, vertexConsumer) -> {
                        RenderSupport.image(vertexConsumer, pose.pose(), -64, 0, 0.0f, 0.0f, 128, 32, 128, 128, 0.0f, renderState.lightCoords);
                        RenderSupport.image(vertexConsumer, pose.pose(), -64, 0, 0.0f, 32.0f, Math.min(h, 121), 32, 128, 128, 0.0f, renderState.lightCoords);
                    });
                    if (HealthBarConfig.I.getDatas().renderHealthBarText) {
                        String txt = _FormatToString.numberToString((Object)Float.valueOf(livingEntity.getHealth())) + "/" + _FormatToString.numberToString((Object)Float.valueOf(livingEntity.getMaxHealth()));
                        Font font = minecraft.font;
                        float f = -((float)minecraft.font.width(txt)) / 2.0f;
                        Objects.requireNonNull(minecraft.font);
                        font.drawInBatch(txt, f, 16.0f - 9.0f / 2.0f, 0, false, poseStack.last().pose(), (MultiBufferSource)minecraft.renderBuffers().bufferSource(), Font.DisplayMode.NORMAL, 0, renderState.lightCoords);
                    }
                    poseStack.popPose();
                }
                if (HealthBarConfig.I.getDatas().renderEffect) {
                    float lY = livingEntity.getBbHeight() / 2.0f + 0.16f;
                    poseStack.pushPose();
                    poseStack.translate(0.0, (double)lY, 0.0);
                    camera.x = 0.0f;
                    camera.z = 0.0f;
                    poseStack.mulPose((Quaternionfc)camera);
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                    poseStack.scale(-0.025f, -0.025f, 0.025f);
                    MobHealthBar.draw(livingEntity, submitNodeCollector, poseStack, minecraft, renderState.lightCoords);
                    poseStack.popPose();
                }
            }
        }
    }

    public static boolean checkView(Minecraft minecraft, LivingEntity entity) {
        if (minecraft.player != null) {
            return ForgeHooksClient.isNameplateInRenderDistance((Entity)entity, (double)minecraft.getEntityRenderDispatcher().distanceToSqr((Entity)entity)) && minecraft.player.hasLineOfSight((Entity)entity) && entity == minecraft.getEntityRenderDispatcher().crosshairPickEntity;
        }
        return false;
    }

    public static boolean checkView(LocalPlayer localPlayer, LivingEntity entity) {
        Vec3 vec3 = localPlayer.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(entity.getX() - localPlayer.getX(), entity.getEyeY() - localPlayer.getEyeY(), entity.getZ() - localPlayer.getZ());
        double d0 = vec31.length();
        double d1 = vec3.dot(vec31 = vec31.normalize());
        return d1 > 1.0 - 0.025 / d0 && localPlayer.hasLineOfSight((Entity)entity);
    }

    public static double getAngle() {
        if (HealthBarConfig.I.getDatas().effectImageRotationAngle == 0) {
            return 0.0;
        }
        if ((rotationAngle += Math.PI / (double)HealthBarConfig.I.getDatas().effectImageRotationAngle) >= Math.PI * 2) {
            rotationAngle = 0.0;
        }
        return rotationAngle;
    }

    private static void draw(LivingEntity entity, SubmitNodeCollector multiBufferSource, PoseStack poseStack, Minecraft minecraft, int packedLight) {
        Collection effects = entity.getActiveEffects();
        if (effects.isEmpty()) {
            return;
        }
        GlStateManager._enableBlend();
        GlStateManager._enableDepthTest();
        int[] i = new int[]{0};
        ArrayList<Point2D.Double> pointPoss = UniformCircleDistribution.distributePoints(entity.getBbWidth() * 40.0f, effects.size(), MobHealthBar.getAngle());
        effects.forEach(mobEffectInstance -> {
            if (HealthBarConfig.I.getDatas().effectRenderImage) {
                Point2D.Double point = (Point2D.Double)pointPoss.get(i[0]);
                poseStack.pushPose();
                poseStack.translate(point.x - 16.0, 0.0, point.y);
                ResourceLocation icon = MobHealthBar.getIcon(mobEffectInstance);
                multiBufferSource.submitCustomGeometry(poseStack, RenderType.text((ResourceLocation)icon), (pose, vertexConsumer) -> RenderSupport.image(vertexConsumer, poseStack.last().pose(), 0, 0, 0.0f, 0.0f, 16, 16, 16, 16, 0.0f, packedLight));
            } else {
                MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
                minecraft.font.drawInBatch(MobHealthBar.getName(mobEffectInstance), 0.0f, 0.0f, 0x1000000, false, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
            }
            poseStack.popPose();
            i[0] = i[0] + 1;
        });
        GlStateManager._disableBlend();
        GlStateManager._disableDepthTest();
    }

    private static void draw(LivingEntity entity, MultiBufferSource multiBufferSource, PoseStack poseStack, Minecraft minecraft, int packedLight) {
        Collection effects = entity.getActiveEffects();
        if (effects.isEmpty()) {
            return;
        }
        GlStateManager._enableBlend();
        GlStateManager._enableDepthTest();
        int[] i = new int[]{0};
        ArrayList<Point2D.Double> pointPoss = UniformCircleDistribution.distributePoints(entity.getBbWidth() * 40.0f, effects.size(), MobHealthBar.getAngle());
        effects.forEach(mobEffectInstance -> {
            if (HealthBarConfig.I.getDatas().effectRenderImage) {
                Point2D.Double point = (Point2D.Double)pointPoss.get(i[0]);
                poseStack.pushPose();
                poseStack.translate(point.x - 16.0, 0.0, point.y);
                ResourceLocation icon = MobHealthBar.getIcon(mobEffectInstance);
                VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.text((ResourceLocation)icon));
                RenderSupport.image(vertexConsumer, poseStack.last().pose(), 0, 0, 0.0f, 0.0f, 16, 16, 16, 16, 0.0f, packedLight);
            } else {
                MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
                minecraft.font.drawInBatch(MobHealthBar.getName(mobEffectInstance), 0.0f, 0.0f, 0x1000000, false, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
            }
            poseStack.popPose();
            i[0] = i[0] + 1;
        });
        GlStateManager._disableBlend();
        GlStateManager._disableDepthTest();
    }

    public static ResourceLocation getReg(MobEffectInstance m) {
        return BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)m.getEffect().value()));
    }

    public static ResourceLocation getIcon(MobEffectInstance m) {
        return MobHealthBar.getIcon(MobHealthBar.getReg(m));
    }

    public static ResourceLocation getIcon(ResourceLocation res) {
        return ResourceLocation.tryBuild((String)res.getNamespace(), (String)("textures/mob_effect/" + res.getPath() + ".png"));
    }

    public static Component getName(ResourceLocation res) {
        return Component.translatable((String)("effect." + res.getNamespace() + "." + res.getPath()));
    }

    public static Component getName(MobEffectInstance effectInstance) {
        return MobHealthBar.getName(MobHealthBar.getReg(effectInstance));
    }
}

