/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.config;

import com.mojang.logging.LogUtils;
import dev.anye.core.system._File;
import dev.anye.mc.nekoui.config.Config;
import dev.anye.mc.nekoui.config.OldToNew;
import dev.anye.mc.nekoui.config.ban$screen.BanScreenConfig;
import dev.anye.mc.nekoui.config.health$bar.HealthBarConfig;
import dev.anye.mc.nekoui.config.hide$hud.HideHudConfig;
import dev.anye.mc.nekoui.config.hotbar.HotBarConfig;
import dev.anye.mc.nekoui.config.menu.MenuPageConfig;
import dev.anye.mc.nekoui.config.menu.MenuPageIO;
import dev.anye.mc.nekoui.config.menu.MenuProjectIO;
import dev.anye.mc.nekoui.config.menu.MenuScreenConfig;
import dev.anye.mc.nekoui.config.mob$direction.MobDirectionConfig;
import dev.anye.mc.nekoui.config.screen$element.ScreenRenderIO;
import dev.anye.mc.nekoui.dat$type.MenuPageData;
import dev.anye.mc.nekoui.dat$type.MenuProjectData;
import dev.anye.mc.nekoui.dat$type.ScreenRender;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Configs {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String ConfigDir = _File.getFileFullPathWithRun((String[])new String[]{"config/NekoUI/"});
    public static final String ConfigDir_JS = ConfigDir + "JavaScript/";
    public static final String ConfigDir_ScreenElement = ConfigDir + "ScreenElement/";
    public static final String ConfigDir_Menu = ConfigDir + "Menu/";
    public static final String ConfigDir_MenuProject = ConfigDir_Menu + "Project/";
    public static final String ConfigDir_MenuPage = ConfigDir_Menu + "Page/";
    private static boolean isInit = true;
    public static final List<ScreenRender> ScreenRenders = new ArrayList<ScreenRender>();
    public static final HashMap<String, MenuProjectData> MenuProjects = new HashMap();
    public static final List<MenuPageData> MenuPage = new ArrayList<MenuPageData>();

    public static void init() {
        LOGGER.info("load config");
        Config.INSTANCE.init();
        if (isInit) {
            isInit = false;
            OldToNew.ToNewScreenElementConfig();
            OldToNew.ToNewMenuProjectConfig();
            OldToNew.ToNewMenuPageConfig();
            if (Config.INSTANCE.getDatas().isPutDefault()) {
                Config.INSTANCE.getDatas().setPutDefault(false);
                Config.INSTANCE.save();
            }
        }
        BanScreenConfig.I.init();
        HealthBarConfig.I.init();
        HideHudConfig.I.init();
        HotBarConfig.INSTANCE.init();
        MenuScreenConfig.INSTANCE.init();
        MobDirectionConfig.I.init();
        Configs.LoadScreenRender();
        Configs.LoadMenuProject();
        Configs.LoadMenuPage();
    }

    public static void LoadScreenRender() {
        ScreenRenders.clear();
        _File.getFiles((String)ConfigDir_ScreenElement, (String)".json").forEach(path -> {
            ScreenRender screenRender = (ScreenRender)new ScreenRenderIO(path.getFileName().toString()).getDatas();
            if (screenRender != null) {
                ScreenRenders.add(screenRender);
            }
        });
    }

    public static void LoadMenuProject() {
        MenuProjects.clear();
        _File.getFiles((String)ConfigDir_MenuProject, (String)".json").forEach(path -> {
            MenuProjectData menuProjectData = (MenuProjectData)new MenuProjectIO(path.getFileName().toString()).getDatas();
            if (menuProjectData != null) {
                MenuProjects.put(Configs.getFileNameWithoutExtension(path.getFileName().toString()), menuProjectData);
            }
        });
    }

    public static void LoadMenuPage() {
        MenuPage.clear();
        ((List)MenuPageConfig.I.getDatas()).forEach(s -> {
            MenuPageData menuPageData;
            String filePath = ConfigDir_MenuPage + s + ".json";
            File file = new File(filePath);
            if (file.exists() && (menuPageData = (MenuPageData)new MenuPageIO(s + ".json").getDatas()) != null) {
                MenuPage.add(menuPageData);
            }
        });
    }

    public static String getFileNameWithoutExtension(String filename) {
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex > 0 && dotIndex < filename.length() - 1) {
            return filename.substring(0, dotIndex);
        }
        return filename;
    }

    static {
        _File.checkAndCreateDir((String)ConfigDir);
        _File.checkAndCreateDir((String)ConfigDir_JS);
        _File.checkAndCreateDir((String)ConfigDir_ScreenElement);
        _File.checkAndCreateDir((String)ConfigDir_Menu);
        _File.checkAndCreateDir((String)ConfigDir_MenuProject);
        _File.checkAndCreateDir((String)ConfigDir_MenuPage);
    }
}

