/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.anye.core.color._ColorSupport;
import dev.anye.core.math._Math;
import dev.anye.mc.nekoui.config.mob$direction.MobDirectionConfig;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.AxisAngle4d;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class MobDirectionGui
extends MobDirectionConfig {
    public static final String ID = "mob_direction";
    public static final ResourceLocation RESOURCE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"mob_direction");
    private static final ResourceLocation MOB_POI = ResourceLocation.tryBuild((String)"nekoui", (String)"textures/ui/info/poi.png");

    public Vec3 v(Vec3 pos, Vec3 focus, double r) {
        Vec3 v = pos.subtract(focus);
        return new Vec3(v.x, 0.0, v.z).normalize().scale(r).add(pos);
    }

    public static void render(GuiGraphics guiGraphics, DeltaTracker partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.hideGui) {
            return;
        }
        ClientLevel clientLevel = minecraft.level;
        LocalPlayer localPlayer = minecraft.player;
        if (clientLevel == null || localPlayer == null || !clientLevel.isClientSide) {
            return;
        }
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        int startX = screenWidth / 2;
        int startY = screenHeight / 2;
        List mobs = clientLevel.getEntities(null, localPlayer.getBoundingBox().inflate((double)I.getDatas().getPoiRadius()));
        Vec3 playerForward = localPlayer.getForward();
        Vec3 playerPosition = localPlayer.position();
        for (Entity mob2 : mobs) {
            int imageSize;
            LocalPlayer player;
            if (mob2 == null || mob2 instanceof LocalPlayer && (player = (LocalPlayer)mob2).equals((Object)localPlayer) || (!I.getDatas().isOnlyLivingEntity() || !(mob2 instanceof LivingEntity) || !I.getDatas().isNotInListMode()) && !I.isShowPoi(mob2)) continue;
            Vec3 mobPosition = mob2.position();
            double cx = mobPosition.x - playerPosition.x;
            double cz = mobPosition.z - playerPosition.z;
            double g = Math.atan2(cz, cx) - Math.atan2(playerForward.z, playerForward.x);
            g = _Math.pullBackWithPI((double)g);
            int ox = (int)((double)I.getDatas().getPoiShowRadius() * Math.cos(g));
            int oz = (int)((double)I.getDatas().getPoiShowRadius() * Math.sin(g));
            g += -2.356194490192345;
            if (I.getDatas().isDynamicDisplay()) {
                double distance = playerPosition.distanceTo(mobPosition);
                imageSize = (int)((double)I.getDatas().getPoiSize() + (distance *= I.getDatas().getRatio()));
                imageSize = Mth.clamp((int)imageSize, (int)I.getDatas().getPoiMinSize(), (int)I.getDatas().getPoiMaxSize());
            } else {
                imageSize = I.getDatas().getPoiSize();
            }
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            pose.translate((float)(startX + oz), (float)(startY - ox), 0.0f);
            pose.mulPose(new Quaternionf(new AxisAngle4d(g, 0.0, 0.0, 1.0)));
            MobDirectionGui.drawPoint(MobDirectionGui.getRenderColor(mob2, guiGraphics), guiGraphics, MOB_POI, imageSize);
            pose.popPose();
        }
    }

    private static void setRenderColor(Entity entity, GuiGraphics guiGraphics) {
        int[] color = _ColorSupport.extractRGBA((int)MobDirectionConfig.I.getEntityColor(entity));
        guiGraphics.setColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
    }

    private static int getRenderColor(Entity entity, GuiGraphics guiGraphics) {
        return MobDirectionConfig.I.getEntityColor(entity);
    }

    private static void drawPoint(int color, GuiGraphics guiGraphics, ResourceLocation res, int imageSize) {
        MobDirectionGui.blit(color, guiGraphics, res, 0, 0, 0.0f, 0.0f, imageSize, imageSize, imageSize, imageSize);
    }

    private static void drawPoint(GuiGraphics guiGraphics, ResourceLocation res, int x, int y, int imageSize) {
        guiGraphics.blit(res, x, y, 0.0f, 0.0f, imageSize, imageSize, imageSize, imageSize);
    }

    public static void blit(int color, GuiGraphics guiGraphics, ResourceLocation pAtlasLocation, int pX, int pY, int pWidth, int pHeight, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight) {
        MobDirectionGui.blit(color, guiGraphics, pAtlasLocation, pX, pX + pWidth, pY, pY + pHeight, 0, pUWidth, pVHeight, pUOffset, pVOffset, pTextureWidth, pTextureHeight);
    }

    public static void blit(int color, GuiGraphics guiGraphics, ResourceLocation pAtlasLocation, int pX, int pY, float pUOffset, float pVOffset, int pWidth, int pHeight, int pTextureWidth, int pTextureHeight) {
        MobDirectionGui.blit(color, guiGraphics, pAtlasLocation, pX, pY, pWidth, pHeight, pUOffset, pVOffset, pWidth, pHeight, pTextureWidth, pTextureHeight);
    }

    static void blit(int color, GuiGraphics guiGraphics, ResourceLocation pAtlasLocation, int pX1, int pX2, int pY1, int pY2, int pBlitOffset, int pUWidth, int pVHeight, float pUOffset, float pVOffset, int pTextureWidth, int pTextureHeight) {
        MobDirectionGui.innerBlit(color, guiGraphics, pAtlasLocation, pX1, pX2, pY1, pY2, pBlitOffset, (pUOffset + 0.0f) / (float)pTextureWidth, (pUOffset + (float)pUWidth) / (float)pTextureWidth, (pVOffset + 0.0f) / (float)pTextureHeight, (pVOffset + (float)pVHeight) / (float)pTextureHeight);
    }

    static void innerBlit(int color, GuiGraphics guiGraphics, ResourceLocation pAtlasLocation, int pX1, int pX2, int pY1, int pY2, int pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        int[] colors = _ColorSupport.extractRGBA((int)color);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)pAtlasLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix4f, (float)pX1, (float)pY1, (float)pBlitOffset).setUv(pMinU, pMinV).setColor(colors[0], colors[1], colors[2], colors[3]);
        bufferbuilder.addVertex(matrix4f, (float)pX1, (float)pY2, (float)pBlitOffset).setUv(pMinU, pMaxV).setColor(colors[0], colors[1], colors[2], colors[3]);
        bufferbuilder.addVertex(matrix4f, (float)pX2, (float)pY2, (float)pBlitOffset).setUv(pMaxU, pMaxV).setColor(colors[0], colors[1], colors[2], colors[3]);
        bufferbuilder.addVertex(matrix4f, (float)pX2, (float)pY1, (float)pBlitOffset).setUv(pMaxU, pMinV).setColor(colors[0], colors[1], colors[2], colors[3]);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    static void innerBlit(GuiGraphics guiGraphics, ResourceLocation pAtlasLocation, int pX1, int pX2, int pY1, int pY2, int pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV, float pRed, float pGreen, float pBlue, float pAlpha) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)pAtlasLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix4f, (float)pX1, (float)pY1, (float)pBlitOffset).setUv(pMinU, pMinV).setColor(pRed, pGreen, pBlue, pAlpha);
        bufferbuilder.addVertex(matrix4f, (float)pX1, (float)pY2, (float)pBlitOffset).setUv(pMinU, pMaxV).setColor(pRed, pGreen, pBlue, pAlpha);
        bufferbuilder.addVertex(matrix4f, (float)pX2, (float)pY2, (float)pBlitOffset).setUv(pMaxU, pMaxV).setColor(pRed, pGreen, pBlue, pAlpha);
        bufferbuilder.addVertex(matrix4f, (float)pX2, (float)pY1, (float)pBlitOffset).setUv(pMaxU, pMinV).setColor(pRed, pGreen, pBlue, pAlpha);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }
}

