/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.gui;

import dev.anye.core.color._ColorSupport;
import dev.anye.core.format._FormatToString;
import dev.anye.mc.cores.helper.component.ComponentStyle;
import dev.anye.mc.cores.js.Js;
import dev.anye.mc.graaljs.javascript.EasyJS;
import dev.anye.mc.nekoui.config.Configs;
import dev.anye.mc.nekoui.dat$type.ScreenRender;
import dev.anye.mc.nekoui.player.PlayerInfo;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3i;

@OnlyIn(value=Dist.CLIENT)
public class ScreenElementGui {
    public static final String id = "screen_element";
    public static final ResourceLocation RESOURCE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"screen_element");
    public static final HashMap<String, ResourceLocation> Resources = new HashMap();
    private static final HashMap<String, Reader> fileTemp = new HashMap();

    public static void render(GuiGraphics guiGraphics, DeltaTracker pPartialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.hideGui) {
            return;
        }
        ClientLevel clientLevel = minecraft.level;
        LocalPlayer localPlayer = minecraft.player;
        if (clientLevel != null && clientLevel.isClientSide && localPlayer != null) {
            int screenHeight = minecraft.getWindow().getGuiScaledHeight();
            int screenWidth = minecraft.getWindow().getGuiScaledWidth();
            Configs.ScreenRenders.forEach(arg_0 -> ScreenElementGui.lambda$render$1(screenWidth, screenHeight, guiGraphics, localPlayer, (Level)clientLevel, arg_0));
        }
    }

    public static Reader getJsFile(String name) throws FileNotFoundException {
        if (!fileTemp.containsKey(name)) {
            fileTemp.put(name, new FileReader(Configs.ConfigDir_JS + name));
        }
        return fileTemp.get(name);
    }

    private static /* synthetic */ void lambda$render$1(int screenWidth, int screenHeight, GuiGraphics guiGraphics, LocalPlayer localPlayer, Level clientLevel, ScreenRender screenRender) {
        int startX = switch (screenRender.x()) {
            case "center" -> screenWidth / 2;
            case "right" -> screenWidth;
            default -> 0;
        };
        int startY = switch (screenRender.y()) {
            case "center" -> screenHeight / 2;
            case "bottom" -> screenHeight;
            default -> 0;
        };
        Vector3i pos = screenRender.pos();
        int x = startX + pos.x;
        int y = startY + pos.y;
        int z = pos.z;
        screenRender.elements().forEach(element -> {
            Vector3i ePos = element.pos();
            int dx = x + ePos.x;
            int dy = y + ePos.y;
            int dz = z + ePos.z;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, (float)dz);
            String tmpS = "";
            switch (element.type()) {
                case Image: {
                    ResourceLocation res = Resources.getOrDefault(element.key(), ResourceLocation.tryParse((String)element.key()));
                    if (res == null) break;
                    guiGraphics.blit(res, dx, dy, 0.0f, 0.0f, element.width(), element.height(), element.width(), element.height());
                    break;
                }
                case Self: {
                    tmpS = element.key();
                    break;
                }
                case Custom: {
                    tmpS = PlayerInfo.getPlayerDat(element.key());
                    break;
                }
                case PlayerData: {
                    tmpS = _FormatToString.formatValue((Object)PlayerInfo.getPlayerAttribute(element.key()), (int)2);
                    break;
                }
                case Js: {
                    String key = element.key();
                    if (Js.CanRun) {
                        tmpS = EasyJS.NotSafe().addParameter("x", (Object)dx).addParameter("y", (Object)dy).addParameter("z", (Object)dz).addParameter("screenWidth", (Object)screenWidth).addParameter("screenHeight", (Object)screenHeight).addParameter("server", (Object)Minecraft.getInstance().getCurrentServer()).addParameter("player", (Object)localPlayer).addParameter("playerNbt", (Object)localPlayer.getPersistentData()).addParameter("guiGraphics", (Object)guiGraphics).addParameter("minecraft", (Object)Minecraft.getInstance()).runFile(Configs.ConfigDir_JS + key).toString();
                        break;
                    }
                    tmpS = "GraalJS not install can't run js code";
                    break;
                }
                case Slot: {
                    guiGraphics.renderItem(localPlayer.getInventory().getItem(Integer.parseInt(element.key())), dx, dy);
                }
            }
            if (!tmpS.isEmpty()) {
                String color = element.color();
                if (color.equals("rainbow")) {
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)ComponentStyle.Flash((String)tmpS, (long)clientLevel.getDayTime()), dx, dy, 0);
                } else {
                    guiGraphics.drawString(Minecraft.getInstance().font, tmpS, dx, dy, _ColorSupport.HexToColor((String)color));
                }
            }
            guiGraphics.pose().popPose();
        });
    }
}

