/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.gui.hot$bar;

import dev.anye.mc.nekoui.config.hotbar.HotBarConfig;
import dev.anye.mc.nekoui.gui.hot$bar.HotBarSys;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HotBarGui
extends HotBarConfig {
    public static final String id = "hot_bar";
    public static final ResourceLocation RESOURCE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"hot_bar");
    private static final ResourceLocation itemSlot = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/hud/item/slot.png");
    private static final ResourceLocation itemSelet = ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/hud/item/slot_select.png");
    private static final ResourceLocation[] itemSelects = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/hud/item/slot_select_1.png"), ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/hud/item/slot_select_2.png"), ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/hud/item/slot_select_3.png"), ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/hud/item/slot_select_4.png"), ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/hud/item/slot_select_5.png"), ResourceLocation.fromNamespaceAndPath((String)"nekoui", (String)"textures/hud/item/slot_select_6.png")};
    private static int itemSelectIndex = 0;
    private static int tick = 0;
    private static final int color = 0xFFFFFF;
    private static final int imageHeight = 16;
    private static final int imageWidth = 16;
    private static int startX;
    private static int startY;

    private static void addSpace() {
        switch (INSTANCE.getDatas().getDirection()) {
            case "horizontal": {
                startX += INSTANCE.getDatas().getSpace();
                break;
            }
            case "vertical": {
                startY += INSTANCE.getDatas().getSpace();
            }
        }
    }

    public static void render(GuiGraphics guiGraphics, DeltaTracker partialTick) {
        if (!INSTANCE.getDatas().isEnable()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.hideGui) {
            return;
        }
        if (HotBarSys.isOutTime() && INSTANCE.getDatas().isDynamicDisplay()) {
            return;
        }
        ClientLevel clientLevel = minecraft.level;
        LocalPlayer localPlayer = minecraft.player;
        if (clientLevel != null && localPlayer != null && clientLevel.isClientSide) {
            int screenWidth = minecraft.getWindow().getGuiScaledWidth();
            int screenHeight = minecraft.getWindow().getGuiScaledHeight();
            startX = switch (INSTANCE.getDatas().getStartX()) {
                case "center" -> screenWidth / 2;
                case "right" -> screenWidth;
                default -> 0;
            };
            startX += INSTANCE.getDatas().getX();
            startY = switch (INSTANCE.getDatas().getStartY()) {
                case "center" -> screenHeight / 2;
                case "bottom" -> screenHeight;
                default -> 0;
            };
            startY += INSTANCE.getDatas().getY();
            Inventory opi = localPlayer.getInventory();
            NonNullList oItems = opi.items;
            int i = 0;
            ItemStack item = localPlayer.getOffhandItem();
            if (item != ItemStack.EMPTY) {
                guiGraphics.blit(itemSlot, startX, startY, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.renderItem(item, startX, startY);
                HotBarGui.renderItemCountAndDamage(guiGraphics, item);
            }
            for (ItemStack itemStack : oItems) {
                if (i >= 9) break;
                HotBarGui.addSpace();
                if (i == opi.selected) {
                    guiGraphics.blit(itemSelects[itemSelectIndex], startX, startY, 0.0f, 0.0f, 16, 16, 16, 16);
                } else {
                    guiGraphics.blit(itemSlot, startX, startY, 0.0f, 0.0f, 16, 16, 16, 16);
                }
                guiGraphics.renderItem(itemStack, startX, startY);
                HotBarGui.renderItemCountAndDamage(guiGraphics, itemStack);
                ++i;
            }
            HotBarGui.setItemSelectIndex();
        }
    }

    private static void setItemSelectIndex() {
        if (++tick > 200) {
            tick = 0;
        }
        itemSelectIndex = tick / 40;
    }

    private static void renderItemCountAndDamage(GuiGraphics guiGraphics, ItemStack itemStack) {
        guiGraphics.renderItemDecorations(Minecraft.getInstance().font, itemStack, startX, startY);
    }
}

