/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.player;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import dev.anye.core.format._FormatToString;
import dev.anye.mc.cores.helper.attribute.AttributeHelper;
import dev.anye.mc.cores.helper.item.ItemHelper;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class PlayerInfo {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static String getPlayerDat(String s) {
        return _FormatToString.formatValue((Object)PlayerInfo.getPlayerData(s), (int)2);
    }

    public static JsonObject getPlayerNbtDat(LocalPlayer player) {
        if (player != null) {
            String dat2 = player.getPersistentData().toString();
            try {
                Gson gson = new Gson();
                return (JsonObject)gson.fromJson(dat2, JsonObject.class);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
        return null;
    }

    private static Number getPlayerData(String string) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 0;
        }
        return switch (string) {
            case "fps" -> Minecraft.getInstance().getFps();
            case "xp" -> Float.valueOf(player.experienceProgress);
            case "lvl" -> player.experienceLevel;
            case "health" -> Float.valueOf(player.getHealth());
            case "maxHealth" -> Float.valueOf(player.getMaxHealth());
            case "hunger" -> player.getFoodData().getFoodLevel();
            case "atk" -> PlayerInfo.getAttackDamage(player);
            case "atkWithItem" -> PlayerInfo.getTotalAttackDamage(player);
            case "luck" -> Float.valueOf(player.getLuck());
            case "speed" -> Float.valueOf(player.getSpeed());
            case "posX" -> player.getX();
            case "posY" -> player.getY();
            case "posZ" -> player.getZ();
            case "dayTime" -> player.level().getDayTime();
            case "gameTime" -> player.level().getGameTime();
            case "airSupply" -> player.getAirSupply();
            case "armor" -> player.getArmorValue();
            case "armorToughness" -> player.getAttributeValue(Attributes.ARMOR_TOUGHNESS);
            case "attackSpeed" -> player.getAttributeValue(Attributes.ATTACK_SPEED);
            case "attackKnockBack" -> player.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
            case "serverPing", "serverPlayersOnline" -> PlayerInfo.getServerInfo(string);
            default -> 0;
        };
    }

    public static double getPlayerAttribute(String s) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 0.0;
        }
        double[] v = new double[]{0.0};
        player.getAttributes().getSyncableAttributes().forEach(attributeInstance -> {
            if (attributeInstance.getAttribute().getRegisteredName().equals(s)) {
                v[0] = attributeInstance.getValue();
            }
        });
        return v[0];
    }

    private static double getServerInfo(String s) {
        ServerData server = Minecraft.getInstance().getCurrentServer();
        if (server == null) {
            return 0.0;
        }
        if (s.equals("serverPing")) {
            return server.ping;
        }
        if (s.equals("serverPlayers") && server.players != null) {
            return server.players.online();
        }
        return 0.0;
    }

    private static double getAttackDamage(LocalPlayer player) {
        return player.getAttributes().getValue(Attributes.ATTACK_DAMAGE);
    }

    private static double getTotalAttackDamage(LocalPlayer player) {
        ItemStack mainHandItem = player.getMainHandItem();
        double itemDamage = 0.0;
        if (!mainHandItem.isEmpty()) {
            Multimap attributeModifiers = ItemHelper.getAttributeModifiers((ItemStack)mainHandItem, (EquipmentSlot)EquipmentSlot.MAINHAND);
            Collection att = attributeModifiers.get((Object)Attributes.ATTACK_DAMAGE);
            itemDamage = AttributeHelper.getAttributeModifierValue((Collection)att);
        }
        double baseDamage = PlayerInfo.getAttackDamage(player);
        return baseDamage + itemDamage;
    }
}

