/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.screen;

import com.mojang.logging.LogUtils;
import dev.anye.core.system._File;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.c.CWidgetButton;
import dev.anye.mc.cores.screen.widget.c.CWidgetDropDownSelectBox;
import dev.anye.mc.cores.screen.widget.c.CWidgetEditBox;
import dev.anye.mc.cores.screen.widget.c.CWidgetLabel;
import dev.anye.mc.nekoui.config.Configs;
import dev.anye.mc.nekoui.config.menu.MenuPageIO;
import dev.anye.mc.nekoui.dat$type.MenuPageData;
import dev.anye.mc.nekoui.screen.ScreenCore;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PageSettingScreen
extends ScreenCore {
    protected final int lineHeight = 30;
    protected final Logger LOGGER = LogUtils.getLogger();
    public CWidgetEditBox idEditBox;
    public CWidgetEditBox nameEditBox;
    public CWidgetEditBox projectNumberEditBox;
    public CWidgetEditBox innerRadiusEditBox;
    public CWidgetEditBox outerRadiusEditBox;
    public CWidgetEditBox keyEditBox;
    public CWidgetEditBox textNormalColorEditBox;
    public CWidgetEditBox textHighlightColorEditBox;
    public CWidgetEditBox backgroundNormalColorEditBox;
    public CWidgetEditBox backgroundHighlightColorEditBox;
    public CWidgetDropDownSelectBox projectId;

    public PageSettingScreen() {
        super("screen.nekoui.page_setting");
    }

    protected void init() {
        super.init();
        int lx = 16;
        int rx = this.width / 2 + 16;
        int py = 16;
        CWidgetLabel tmpLabel = (CWidgetLabel)this.addRenderableWidget((GuiEventListener)this.createNewLabel(lx, py, -2, 12, this.getComponent("label.select")));
        this.addRenderableWidget((GuiEventListener)this.createNewSelectBox(lx, py + tmpLabel.getHeight(), 100, 16, this.getComponent("select_page"), this.getConfigData()));
        tmpLabel = (CWidgetLabel)this.addRenderableWidget((GuiEventListener)this.createNewLabel(lx, py += 30, -2, 12, this.getComponent("label.id")));
        this.idEditBox = this.createNewEditBox(lx, py + tmpLabel.getHeight(), 90, 16, this.idEditBox, this.getComponent("id_input"));
        this.addRenderableWidget((GuiEventListener)this.idEditBox);
        tmpLabel = (CWidgetLabel)this.addRenderableWidget((GuiEventListener)this.createNewLabel(lx, py += 30, -2, 12, this.getComponent("label.name")));
        this.nameEditBox = this.createNewEditBox(lx, py + tmpLabel.getHeight(), 90, 16, this.nameEditBox, this.getComponent("name_input"));
        this.addRenderableWidget((GuiEventListener)this.nameEditBox);
        tmpLabel = (CWidgetLabel)this.addRenderableWidget((GuiEventListener)this.createNewLabel(lx, py += 30, -2, 12, this.getComponent("label.number")));
        this.projectNumberEditBox = this.createNewEditBox(lx, py + tmpLabel.getHeight(), 24, 16, this.projectNumberEditBox, this.getComponent("number_input"));
        this.addRenderableWidget((GuiEventListener)this.projectNumberEditBox);
        tmpLabel = (CWidgetLabel)this.addRenderableWidget((GuiEventListener)this.createNewLabel(lx, py += 30, -2, 12, this.getComponent("label.inner_radius")));
        this.innerRadiusEditBox = this.createNewEditBox(lx, py + tmpLabel.getHeight(), 24, 16, this.innerRadiusEditBox, this.getComponent("inner_radius_input"));
        this.addRenderableWidget((GuiEventListener)this.innerRadiusEditBox);
        tmpLabel = (CWidgetLabel)this.addRenderableWidget((GuiEventListener)this.createNewLabel(lx, py += 30, -2, 12, this.getComponent("label.outer_radius")));
        this.outerRadiusEditBox = this.createNewEditBox(lx, py + tmpLabel.getHeight(), 24, 16, this.outerRadiusEditBox, this.getComponent("outer_radius_input"));
        this.addRenderableWidget((GuiEventListener)this.outerRadiusEditBox);
        py = 16;
        tmpLabel = (CWidgetLabel)this.addRenderableWidget((GuiEventListener)this.createNewLabel(rx, py, -2, 12, this.getComponent("label.project")));
        this.projectId = this.createNewSelectBox(rx, py + tmpLabel.getHeight(), 64, 16, this.getComponent("project"), this.getProjects());
        this.addRenderableWidget((GuiEventListener)this.projectId);
        tmpLabel = (CWidgetLabel)this.addRenderableWidget((GuiEventListener)this.createNewLabel(rx, py += 30, -2, 12, this.getComponent("label.key")));
        this.keyEditBox = this.createNewEditBox(rx, py + tmpLabel.getHeight(), 100, 16, this.keyEditBox, this.getComponent("key_input"));
        this.addRenderableWidget((GuiEventListener)this.keyEditBox);
        tmpLabel = (CWidgetLabel)this.addRenderableWidget((GuiEventListener)this.createNewLabel(rx, py += 30, -2, 12, this.getComponent("label.text_normal_color")));
        this.textNormalColorEditBox = this.createNewEditBox(rx, py + tmpLabel.getHeight(), 100, 16, this.textNormalColorEditBox, this.getComponent("text_normal_color_input"));
        this.addRenderableWidget((GuiEventListener)this.textNormalColorEditBox);
        tmpLabel = (CWidgetLabel)this.addRenderableWidget((GuiEventListener)this.createNewLabel(rx, py += 30, -2, 12, this.getComponent("label.text_highlight_color")));
        this.textHighlightColorEditBox = this.createNewEditBox(rx, py + tmpLabel.getHeight(), 100, 16, this.textHighlightColorEditBox, this.getComponent("text_highlight_color_input"));
        this.addRenderableWidget((GuiEventListener)this.textHighlightColorEditBox);
        tmpLabel = (CWidgetLabel)this.addRenderableWidget((GuiEventListener)this.createNewLabel(rx, py += 30, -2, 12, this.getComponent("label.background_normal_color")));
        this.backgroundNormalColorEditBox = this.createNewEditBox(rx, py + tmpLabel.getHeight(), 100, 16, this.backgroundNormalColorEditBox, this.getComponent("background_normal_color_input"));
        this.addRenderableWidget((GuiEventListener)this.backgroundNormalColorEditBox);
        tmpLabel = (CWidgetLabel)this.addRenderableWidget((GuiEventListener)this.createNewLabel(rx, py += 30, -2, 12, this.getComponent("label.background_highlight_color")));
        this.backgroundHighlightColorEditBox = this.createNewEditBox(rx, py + tmpLabel.getHeight(), 100, 16, this.backgroundHighlightColorEditBox, this.getComponent("background_highlight_color_input"));
        this.addRenderableWidget((GuiEventListener)this.backgroundHighlightColorEditBox);
        CWidgetButton save = this.createNewButton(rx, py += 30, 32, 16, this.getComponent("save"), this::saveConfig);
        this.addRenderableWidget((GuiEventListener)save);
        CWidgetButton delete = this.createNewButton(rx + save.getWidth() + 12, py, 32, 16, this.getComponent("delete_page"), this::delete);
        this.addRenderableWidget((GuiEventListener)delete);
    }

    public List<DT_ListBoxData> getConfigData() {
        ArrayList<DT_ListBoxData> data = new ArrayList<DT_ListBoxData>();
        _File.getFiles((String)Configs.ConfigDir_MenuPage, (String)".json").forEach(path -> {
            String s = Configs.getFileNameWithoutExtension(path.getFileName().toString());
            data.add(new DT_ListBoxData((Component)Component.literal((String)s), (Object)s, this::setData));
        });
        return data;
    }

    public List<DT_ListBoxData> getProjects() {
        int pn;
        ArrayList<DT_ListBoxData> data = new ArrayList<DT_ListBoxData>();
        if (!this.projectNumberEditBox.getValue().isEmpty() && (pn = Integer.parseInt(this.projectNumberEditBox.getValue())) > 0) {
            for (int i = 0; i < pn; ++i) {
                data.add(new DT_ListBoxData((Component)this.getComponent("project_list").copy().append(":" + i), (Object)String.valueOf(i), this::setProjectData));
            }
        }
        return data;
    }

    public void setData(Object v) {
        String id;
        MenuPageData pageData;
        if (v instanceof String && (pageData = (MenuPageData)new MenuPageIO((id = (String)v) + ".json").getDatas()) != null) {
            this.idEditBox.setValue(id);
            this.nameEditBox.setValue(pageData.title());
            this.projectNumberEditBox.setValue(String.valueOf(pageData.projectNumber()));
            this.innerRadiusEditBox.setValue(String.valueOf(pageData.innerRadius()));
            this.outerRadiusEditBox.setValue(String.valueOf(pageData.outerRadius()));
        }
    }

    public void setProjectData(Object v) {
        if (v instanceof String) {
            String id = (String)v;
            MenuPageData pageData = (MenuPageData)new MenuPageIO(this.idEditBox.getValue() + ".json").getDatas();
            if (pageData != null) {
                int index = Integer.parseInt(id);
                MenuPageData.ProjectInfo pd = null;
                if (index < pageData.projects().size()) {
                    pd = pageData.projects().get(index);
                }
                if (pd != null) {
                    this.keyEditBox.setValue(this.checkValue(pd.key(), "project key"));
                    this.textNormalColorEditBox.setValue(this.checkValue(pd.textNormalColor(), "auto"));
                    this.textHighlightColorEditBox.setValue(this.checkValue(pd.textHighlightColor(), "auto"));
                    this.backgroundNormalColorEditBox.setValue(this.checkValue(pd.backgroundNormalColor(), "auto"));
                    this.backgroundHighlightColorEditBox.setValue(this.checkValue(pd.backgroundHighlightColor(), "auto"));
                } else {
                    this.keyEditBox.setValue("project key");
                    this.textNormalColorEditBox.setValue("");
                    this.textHighlightColorEditBox.setValue("");
                    this.backgroundNormalColorEditBox.setValue("");
                    this.backgroundHighlightColorEditBox.setValue("");
                }
            }
        }
    }

    public void saveConfig() {
        String id = this.idEditBox.getValue();
        if (id.isEmpty()) {
            return;
        }
        MenuPageIO menuPageIO = new MenuPageIO(id + ".json");
        MenuPageData menuPageData = (MenuPageData)menuPageIO.getDatas();
        String title = this.checkValue(this.nameEditBox.getValue(), "page title");
        int pn = Integer.parseInt(this.checkValue(this.projectNumberEditBox.getValue(), "7"));
        if (pn > 0) {
            int innerR = Integer.parseInt(this.checkValue(this.innerRadiusEditBox.getValue(), "20"));
            int outerR = Integer.parseInt(this.checkValue(this.outerRadiusEditBox.getValue(), "80"));
            ArrayList<MenuPageData.ProjectInfo> projectInfos = new ArrayList<MenuPageData.ProjectInfo>();
            if (menuPageData != null) {
                projectInfos.addAll(menuPageData.projects());
            }
            if (this.projectId.getNowSelectIndex() >= 0 && this.projectId.getNowSelectIndex() < this.projectId.dataSize()) {
                int pid = Integer.parseInt((String)this.projectId.getSelectValue());
                MenuPageData.ProjectInfo projectData = new MenuPageData.ProjectInfo(this.checkValue(this.keyEditBox.getValue(), "project key"), this.checkValue(this.textNormalColorEditBox.getValue(), "auto"), this.checkValue(this.textHighlightColorEditBox.getValue(), "auto"), this.checkValue(this.backgroundNormalColorEditBox.getValue(), "auto"), this.checkValue(this.backgroundHighlightColorEditBox.getValue(), "auto"));
                while (projectInfos.size() <= pid) {
                    projectInfos.add(MenuPageData.ProjectInfo.EMPTY);
                }
                projectInfos.set(pid, projectData);
            }
            menuPageIO.setData(new MenuPageData(title, pn, innerR, outerR, projectInfos));
            menuPageIO.save();
            Configs.LoadMenuPage();
            Minecraft.getInstance().setScreen((Screen)new PageSettingScreen());
        }
    }

    public void delete() {
        File file;
        String id = this.idEditBox.getValue();
        if (!id.isEmpty() && (file = new File(Configs.ConfigDir_MenuPage + id + ".json")).exists()) {
            if (file.delete()) {
                Configs.LoadMenuPage();
            } else {
                this.LOGGER.warn("Delete file {} error", (Object)id);
            }
        }
        Minecraft.getInstance().setScreen((Screen)new PageSettingScreen());
    }

    public String checkValue(String v, String defaultValue) {
        if (v == null || v.isEmpty()) {
            return defaultValue;
        }
        return v;
    }
}

