/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.config.mob$direction;

import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import dev.anye.core.color._ColorCDT;
import dev.anye.core.color._ColorSupport;
import dev.anye.core.json._JsonConfig;
import dev.anye.mc.nekoui.config.Configs;
import dev.anye.mc.nekoui.config.mob$direction.MobDirectionData;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class MobDirectionConfig
extends _JsonConfig<MobDirectionData> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String filePath = Configs.ConfigDir + "mob-direction.json";
    public static final MobDirectionConfig I = new MobDirectionConfig();

    public MobDirectionConfig() {
        super(filePath, "{\n                      \"enable\": true,\n                      \"dynamicDisplay\":true,\n                      \"poiShowRadius\":80,\n                      \"poiRadius\":22,\n                      \"poiSize\":11,\n                      \"poiMaxSize\": 9,\n                      \"poiMinSize\": 2,\n                      \"ratio\":-0.5,\n                      \"onlyLivingEntity\":true,\n                      \"notInListMode\":true,\n                      \"entityList\":{\n                          \"minecraft.chest_minecart\": true\n                      },\n                      \"defaultColor\":\"0xFF000000\",\n                      \"useEggColor\": true,\n                      \"eggLayerIndex\": 0,\n                      \"entityColors\":{\n                          \"minecraft.player\": \"0x56FFFFFF\",\n                          \"minecraft.chest_minecart\": \"0xFFFFFF00\"\n                      }\n                    }", (TypeToken)new TypeToken<MobDirectionData>(){});
        if (this.getDatas().isUseEggColor()) {
            this.writeEggColor();
        }
    }

    public void init() {
        super.init();
    }

    public MobDirectionData getDatas() {
        if (this.datas == null) {
            return new MobDirectionData();
        }
        return (MobDirectionData)this.datas;
    }

    public int getEntityColor(Entity entity) {
        if (entity != null) {
            ResourceLocation res = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            return this.getEntityColor(res.toLanguageKey());
        }
        return _ColorCDT.white;
    }

    public int getEntityColor(String entity) {
        return this.getDatas().getColor(entity);
    }

    public boolean isShowPoi(Entity entity) {
        if (entity != null) {
            ResourceLocation res = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            return this.isShowPoi(res.toLanguageKey());
        }
        return false;
    }

    public boolean isShowPoi(String entity) {
        return this.getDatas().isShow(entity);
    }

    public void writeEggColor() {
        BuiltInRegistries.ENTITY_TYPE.forEach(entityType -> {
            String eid = BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toLanguageKey();
            if (this.getDatas().getEntityColors().get(eid) == null) {
                int color = MobDirectionConfig.getSpawnEggColors(entityType)[this.getDatas().getEggLayerIndex()];
                if (color == -1) {
                    return;
                }
                this.getDatas().getEntityColors().put(eid, _ColorSupport.intToHexColor((int)color));
            }
        });
        this.save();
    }

    public static ItemStack getSpawnEgg(EntityType<?> entity) {
        for (SpawnEggItem eggItem : SpawnEggItem.eggs()) {
            if (eggItem.getType(ItemStack.EMPTY) != entity) continue;
            return new ItemStack((ItemLike)eggItem);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getSpawnEgg(Entity entity) {
        EntityType entityType = entity.getType();
        for (SpawnEggItem eggItem : SpawnEggItem.eggs()) {
            if (eggItem.getType(ItemStack.EMPTY) != entityType) continue;
            return new ItemStack((ItemLike)eggItem);
        }
        return ItemStack.EMPTY;
    }

    public static int[] getSpawnEggColors(ItemStack spawnEgg) {
        Item item = spawnEgg.getItem();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem spawnEggItem = (SpawnEggItem)item;
            int baseColor = spawnEggItem.getColor(0);
            int overlayColor = spawnEggItem.getColor(1);
            return new int[]{baseColor, overlayColor};
        }
        return new int[]{-1, -1};
    }

    public static int[] getSpawnEggColors(Entity spawnEgg) {
        return MobDirectionConfig.getSpawnEggColors(MobDirectionConfig.getSpawnEgg(spawnEgg));
    }

    public static int[] getSpawnEggColors(EntityType<?> spawnEgg) {
        return MobDirectionConfig.getSpawnEggColors(MobDirectionConfig.getSpawnEgg(spawnEgg));
    }
}

