/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class RenderSupport {
    public static void renderWarpedImage(PoseStack poseStack, ResourceLocation texture, float x, float y, float width, float height, float angle) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        poseStack.pushPose();
        poseStack.translate(x, y, 0.0f);
        Matrix4f matrix = poseStack.last().pose();
        RenderSupport.drawWarpedPlaneZ(matrix, width, height, 20, 20, angle);
        poseStack.popPose();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void drawWarpedPlane(Matrix4f matrix, float width, float height, int segmentsX, int segmentsY, float angle) {
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder builder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i < segmentsX; ++i) {
            for (int j = 0; j < segmentsY; ++j) {
                float x1 = (float)i / (float)segmentsX * width;
                float y1 = (float)j / (float)segmentsY * height;
                float x2 = (float)(i + 1) / (float)segmentsX * width;
                float y2 = (float)(j + 1) / (float)segmentsY * height;
                double v = Math.sin((double)(x1 / width) * Math.PI) * (double)angle;
                float warpedY1 = (float)((double)y1 + v);
                double v3 = Math.sin((double)(x2 / width) * Math.PI) * (double)angle;
                float warpedY2 = (float)((double)y1 + v3);
                float warpedY3 = (float)((double)y2 + v);
                float warpedY4 = (float)((double)y2 + v3);
                float u1 = (float)i / (float)segmentsX;
                float v1 = (float)j / (float)segmentsY;
                float u2 = (float)(i + 1) / (float)segmentsX;
                float v2 = (float)(j + 1) / (float)segmentsY;
                builder.addVertex(matrix, x1, warpedY1, 0.0f).setUv(u1, v1);
                builder.addVertex(matrix, x2, warpedY2, 0.0f).setUv(u2, v1);
                builder.addVertex(matrix, x2, warpedY4, 0.0f).setUv(u2, v2);
                builder.addVertex(matrix, x1, warpedY3, 0.0f).setUv(u1, v2);
            }
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void drawWarpedPlaneX(Matrix4f matrix, float width, float height, int segmentsX, int segmentsY, float angle) {
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder builder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i < segmentsX; ++i) {
            for (int j = 0; j < segmentsY; ++j) {
                float x1 = (float)i / (float)segmentsX * width;
                float y1 = (float)j / (float)segmentsY * height;
                float x2 = (float)(i + 1) / (float)segmentsX * width;
                float y2 = (float)(j + 1) / (float)segmentsY * height;
                float warpedX1 = (float)((double)x1 + Math.sin((double)(y1 / height) * Math.PI) * (double)angle);
                float warpedX2 = (float)((double)x1 + Math.sin((double)(y2 / height) * Math.PI) * (double)angle);
                float warpedX3 = (float)((double)x2 + Math.sin((double)(y1 / height) * Math.PI) * (double)angle);
                float warpedX4 = (float)((double)x2 + Math.sin((double)(y2 / height) * Math.PI) * (double)angle);
                float u1 = (float)i / (float)segmentsX;
                float v1 = (float)j / (float)segmentsY;
                float u2 = (float)(i + 1) / (float)segmentsX;
                float v2 = (float)(j + 1) / (float)segmentsY;
                builder.addVertex(matrix, warpedX1, y1, 0.0f).setUv(u1, v1);
                builder.addVertex(matrix, warpedX3, y1, 0.0f).setUv(u2, v1);
                builder.addVertex(matrix, warpedX4, y2, 0.0f).setUv(u2, v2);
                builder.addVertex(matrix, warpedX2, y2, 0.0f).setUv(u1, v2);
            }
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void drawWarpedPlaneZ(Matrix4f matrix, float width, float height, int segmentsX, int segmentsY, float angle) {
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder builder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i < segmentsX; ++i) {
            for (int j = 0; j < segmentsY; ++j) {
                float x1 = (float)i / (float)segmentsX * width;
                float y1 = (float)j / (float)segmentsY * height;
                float x2 = (float)(i + 1) / (float)segmentsX * width;
                float y2 = (float)(j + 1) / (float)segmentsY * height;
                float warpedZ1 = (float)(Math.sin((double)(x1 / width) * Math.PI) * (double)angle);
                float warpedZ2 = (float)(Math.sin((double)(x2 / width) * Math.PI) * (double)angle);
                float warpedZ3 = (float)(Math.sin((double)(x1 / width) * Math.PI) * (double)angle);
                float warpedZ4 = (float)(Math.sin((double)(x2 / width) * Math.PI) * (double)angle);
                float u1 = (float)i / (float)segmentsX;
                float v1 = (float)j / (float)segmentsY;
                float u2 = (float)(i + 1) / (float)segmentsX;
                float v2 = (float)(j + 1) / (float)segmentsY;
                builder.addVertex(matrix, x1, y1, warpedZ1).setUv(u1, v1);
                builder.addVertex(matrix, x2, y1, warpedZ2).setUv(u2, v1);
                builder.addVertex(matrix, x2, y2, warpedZ4).setUv(u2, v2);
                builder.addVertex(matrix, x1, y2, warpedZ3).setUv(u1, v2);
            }
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }
}

