/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.screen;

import com.mojang.logging.LogUtils;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.simple.SimpleButton;
import dev.anye.mc.cores.screen.widget.simple.SimpleDropDownSelectBox;
import dev.anye.mc.cores.screen.widget.simple.SimpleEditBox;
import dev.anye.mc.nekoui.config.Configs;
import dev.anye.mc.nekoui.config.menu.MenuProjectIO;
import dev.anye.mc.nekoui.dat$type.MenuProjectData;
import dev.anye.mc.nekoui.screen.ScreenCore;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ProjectsSettingScreen
extends ScreenCore {
    public static final String ID = "screen.nekoui.projects_setting";
    private static final Logger LOGGER = LogUtils.getLogger();
    public boolean KeyListen;
    public SimpleEditBox idEditBox;
    public SimpleEditBox nameEditBox;
    public SimpleEditBox valueEditBox;
    public SimpleDropDownSelectBox runType;

    public ProjectsSettingScreen() {
        super(ID);
    }

    protected void init() {
        super.init();
        int px = this.width / 2 - 75;
        int py = 32;
        this.addRenderableWidget((GuiEventListener)this.createNewLabel(px, py, 50, 16, this.getComponent("label.select")));
        this.addRenderableWidget((GuiEventListener)this.createNewSelectBox(px + 50, py, 100, 16, this.getComponent("select_id"), this.getConfigData()));
        this.addRenderableWidget((GuiEventListener)this.createNewLabel(px, py += 23, 50, 16, this.getComponent("label.id")));
        this.idEditBox = this.createNewEditBox(px + 50, py, 100, 16, this.idEditBox, this.getComponent("id_input"));
        this.addRenderableWidget((GuiEventListener)this.idEditBox);
        this.addRenderableWidget((GuiEventListener)this.createNewLabel(px, py += 23, 50, 16, this.getComponent("label.name")));
        this.nameEditBox = this.createNewEditBox(px + 50, py, 100, 16, this.nameEditBox, this.getComponent("name_input"));
        this.addRenderableWidget((GuiEventListener)this.nameEditBox);
        this.addRenderableWidget((GuiEventListener)this.createNewLabel(px, py += 23, 50, 16, this.getComponent("label.type")));
        this.runType = this.createNewSelectBox(px + 50, py, 50, 16, this.getComponent("type"), this.getTypes());
        this.runType.setLine(4);
        this.addRenderableWidget((GuiEventListener)this.runType);
        this.addRenderableWidget((GuiEventListener)this.createNewLabel(px, py += 23, 50, 16, this.getComponent("label.value")));
        this.valueEditBox = this.createNewEditBox(px + 50, py, 100, 16, this.valueEditBox, this.getComponent("value_input"));
        this.addRenderableWidget((GuiEventListener)this.valueEditBox);
        SimpleButton b = this.createNewButton(px + 50, py + 16, 16, 16, this.getComponent("key"), this::setKeyListen);
        this.addRenderableWidget((GuiEventListener)b);
        SimpleButton save = this.createNewButton(px, py += 52, 32, 16, this.getComponent("save"), this::saveConfig);
        this.addRenderableWidget((GuiEventListener)save);
        SimpleButton delete = this.createNewButton(px + 64, py, 32, 16, this.getComponent("delete"), this::delete);
        this.addRenderableWidget((GuiEventListener)delete);
    }

    public void delete() {
        String id = this.idEditBox.getValue();
        if (!id.isEmpty() && Configs.MenuProjects.get(id) != null) {
            Configs.MenuProjects.remove(id);
            File file = new File(Configs.ConfigDir_MenuProject + id + ".json");
            if (file.exists() && file.delete()) {
                LOGGER.info("delete {}", (Object)id);
            } else {
                LOGGER.error("delete fail {}", (Object)id);
            }
        }
        Minecraft.getInstance().setScreen((Screen)new ProjectsSettingScreen());
    }

    public void saveConfig() {
        String id = this.idEditBox.getValue();
        if (id.isEmpty()) {
            return;
        }
        MenuProjectData menuProjectData = new MenuProjectData(id, this.runType.getNowSelectIndex(), this.valueEditBox.getValue());
        Configs.MenuProjects.put(id, menuProjectData);
        new MenuProjectIO(id + ".json").setData(menuProjectData).save();
        Minecraft.getInstance().setScreen((Screen)new ProjectsSettingScreen());
    }

    public void setKeyListen() {
        this.KeyListen = !this.KeyListen;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.KeyListen) {
            this.KeyListen = false;
            Object old = this.valueEditBox.getValue();
            if (!((String)old).isEmpty()) {
                old = (String)old + " ";
            }
            this.valueEditBox.setValue((String)old + pKeyCode);
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public List<DT_ListBoxData> getConfigData() {
        ArrayList<DT_ListBoxData> data = new ArrayList<DT_ListBoxData>();
        Configs.MenuProjects.forEach((s, menuData) -> data.add(new DT_ListBoxData((Component)Component.literal((String)s), s, this::setData)));
        return data;
    }

    public List<DT_ListBoxData> getTypes() {
        ArrayList<DT_ListBoxData> data = new ArrayList<DT_ListBoxData>();
        for (RunType type : RunType.values()) {
            data.add(new DT_ListBoxData(this.getComponent("types." + type.name()), (Object)type.v));
        }
        return data;
    }

    public void setData(Object v) {
        String id;
        MenuProjectData menuData;
        if (v instanceof String && (menuData = Configs.MenuProjects.get(id = (String)v)) != null) {
            this.idEditBox.setValue(id);
            this.nameEditBox.setValue(menuData.name());
            this.runType.setSelect(menuData.type().v());
            this.valueEditBox.setValue(menuData.value());
        }
    }

    public static enum RunType {
        message(0),
        command(1),
        button(2),
        js(3);

        private final int v;

        private RunType(int v) {
            this.v = v;
        }

        public static RunType fromInt(int type) {
            for (RunType t : RunType.values()) {
                if (t.v != type) continue;
                return t;
            }
            throw new IllegalArgumentException("No enum constant with value " + type);
        }
    }
}

