/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.screen.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.anye.core.color._ColorSupport;
import dev.anye.mc.cores.render.Draw;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.RenderWidgetCore;
import dev.anye.mc.nekoui.config.Configs;
import dev.anye.mc.nekoui.dat$type.MenuPageData;
import dev.anye.mc.nekoui.dat$type.MenuProjectData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class CircularNewMenu
extends RenderWidgetCore<CircularNewMenu> {
    protected final List<RenderPageData> renderPageData;
    protected FlipMode flipMode;
    protected int sectors;
    protected double fanAngle;
    protected double fanArc;
    protected double halfFanArc;
    protected int index = -1;
    protected int nowPage = 0;
    protected int maxPage;
    protected int fanTextInnerSpace;
    protected int innerRadius;
    protected int outerRadius;

    public CircularNewMenu(int x, int y, int w, int h, Component message, List<RenderPageData> renderPageData) {
        super(x, y, w, h, message);
        this.renderPageData = renderPageData;
        this.maxPage = renderPageData.size();
        this.setNowPage(0);
        this.setFlipMode(FlipMode.tire);
        this.setFanTextInnerSpace(10);
    }

    public int getNowPage() {
        return this.nowPage;
    }

    public void setNowPage(int newPage) {
        this.nowPage = newPage < 0 ? 0 : (newPage >= this.maxPage ? this.maxPage - 1 : newPage);
        this.setSectors(this.getNowPageData().projectNumber());
        this.innerRadius = this.getNowPageData().innerRadius();
        this.outerRadius = this.getNowPageData().outerRadius();
    }

    public MenuPageData getNowPageData() {
        return this.renderPageData.get(this.getNowPage()).pageData();
    }

    public List<DT_ListBoxData> getNowListBoxData() {
        return this.renderPageData.get(this.getNowPage()).projects();
    }

    public void changePage(boolean add) {
        if (add) {
            if (this.nowPage < this.maxPage - 1) {
                this.setNowPage(this.nowPage + 1);
            } else if (this.nowPage == this.maxPage - 1) {
                this.setNowPage(0);
            }
        } else if (this.nowPage > 0) {
            this.setNowPage(this.nowPage - 1);
        } else if (this.nowPage == 0) {
            this.setNowPage(this.maxPage - 1);
        }
    }

    public void setFanTextInnerSpace(int fanTextInnerSpace) {
        this.fanTextInnerSpace = fanTextInnerSpace;
    }

    public void setFlipMode(FlipMode flipMode) {
        this.flipMode = flipMode;
    }

    public void setFanArc(double fanArc) {
        this.fanArc = fanArc;
        this.setHalfFanArc(fanArc / 2.0);
    }

    public void setHalfFanArc(double halfFanArc) {
        this.halfFanArc = halfFanArc;
    }

    public int getFanTextInnerSpace() {
        return Math.max(this.fanTextInnerSpace, this.innerRadius);
    }

    public void setFanAngle(double fanAngle) {
        this.fanAngle = fanAngle;
    }

    public void setSectors(int sectors) {
        this.sectors = sectors;
        this.setFanAngle(360.0 / (double)sectors);
        this.setFanArc(Math.PI * 2 / (double)sectors);
    }

    public DT_ListBoxData getData() {
        return this.getData(this.index);
    }

    public DT_ListBoxData getData(int index) {
        if (this.isValidIndex(index)) {
            return this.getNowListBoxData().get(index);
        }
        return null;
    }

    public boolean isValidIndex() {
        return this.isValidIndex(this.index);
    }

    public boolean isValidIndex(int index) {
        return index >= 0 && index < this.getNowListBoxData().size();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.active && this.visible && this.flipMode == FlipMode.button) {
            if (pButton == 0) {
                this.changePage(false);
                return true;
            }
            if (pButton == 1) {
                this.changePage(true);
                return true;
            }
            return false;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public void onClick(double pMouseX, double pMouseY) {
        DT_ListBoxData dtListBoxData;
        if (this.flipMode == FlipMode.tire && (dtListBoxData = this.getData()) != null) {
            dtListBoxData.OnPress(dtListBoxData.getValue());
        }
        super.onClick(pMouseX, pMouseY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.flipMode == FlipMode.tire) {
            this.changePage(!(pScrollY > 0.0));
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        if (this.visible) {
            int centerX = this.getX();
            int centerY = this.getY();
            double angle = Math.atan2(mouseY - centerY, mouseX - centerX) + this.halfFanArc;
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            if (this.getNowPageData() == null) {
                return;
            }
            guiGraphics.drawString(this.font, this.getNowPageData().title(), centerX - this.font.width(this.getNowPageData().title()) / 2, 6, this.getTextUsualColor(), false);
            for (int i = 0; i < this.sectors; ++i) {
                double startAngle = (double)i * this.fanArc;
                double endAngle = (double)(i + 1) * this.fanArc;
                MenuPageData.ProjectInfo projectInfo = null;
                if (i < this.getNowPageData().projects().size()) {
                    projectInfo = this.getNowPageData().projects().get(i);
                }
                if (projectInfo == null) {
                    if (!(angle >= startAngle) || !(angle < endAngle)) continue;
                    this.index = -1;
                    continue;
                }
                if (projectInfo.key().isEmpty() || projectInfo.key().equals("-empty-")) continue;
                String tColor = projectInfo.backgroundNormalColor().isEmpty() ? "auto" : projectInfo.backgroundNormalColor();
                int bgc = tColor.equals("auto") ? this.getBackgroundUsualColor() : _ColorSupport.HexToColor((String)tColor);
                tColor = projectInfo.textNormalColor().isEmpty() ? "auto" : projectInfo.textNormalColor();
                int tc = tColor.equals("auto") ? this.getTextUsualColor() : _ColorSupport.HexToColor((String)tColor);
                float size = 1.0f;
                if (angle >= startAngle && angle < endAngle) {
                    tColor = projectInfo.backgroundHighlightColor().isEmpty() ? "auto" : projectInfo.backgroundHighlightColor();
                    bgc = tColor.equals("auto") ? this.getBackgroundHoverColor() : _ColorSupport.HexToColor((String)tColor);
                    tColor = projectInfo.textHighlightColor().isEmpty() ? "auto" : projectInfo.textHighlightColor();
                    tc = tColor.equals("auto") ? this.getTextHoverColor() : _ColorSupport.HexToColor((String)tColor);
                    size = 1.3f;
                    this.index = i;
                }
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.translate((float)centerX, (float)centerY, 0.0f);
                poseStack.mulPose(Axis.ZP.rotation((float)startAngle));
                Draw.drawSector((Matrix4f)poseStack.last().pose(), (int)this.innerRadius, (int)this.outerRadius, (double)(-this.halfFanArc), (double)this.halfFanArc, (int)bgc);
                if (this.isValidIndex(i)) {
                    DT_ListBoxData boxData = this.getData(i);
                    String name = "";
                    if (boxData != null) {
                        name = boxData.getComponent().getString();
                    }
                    this.drawName(guiGraphics, startAngle, name, tc, size);
                }
                poseStack.popPose();
            }
        }
    }

    public void drawTextName(GuiGraphics guiGraphics, String name, int color) {
        name = this.font.plainSubstrByWidth(name, this.outerRadius - this.getFanTextInnerSpace());
        int n = this.getFanTextInnerSpace();
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, name, n, -9 / 2, color, false);
    }

    protected void drawName(GuiGraphics guiGraphics, double rad, String name, int color, float size) {
        PoseStack pose;
        block12: {
            block11: {
                pose = guiGraphics.pose();
                pose.pushPose();
                String[] parts = name.split("\\?");
                if (parts.length != 2) break block11;
                pose.mulPose(Axis.ZP.rotation((float)(-rad)));
                double r = (double)this.getFanTextInnerSpace() + (double)(this.outerRadius - this.innerRadius) / 2.0;
                double x = Math.cos(rad) * r;
                double y = Math.sin(rad) * r;
                pose.translate(x, y, 0.0);
                pose.scale(size, size, size);
                switch (parts[0]) {
                    case "slot": {
                        LocalPlayer player = Minecraft.getInstance().player;
                        if (player != null) {
                            ItemStack item = player.getInventory().getItem(Integer.parseInt(parts[1]));
                            guiGraphics.renderItem(item, -8, -8);
                            guiGraphics.renderItemDecorations(this.font, item, -8, -8);
                            break;
                        }
                        break block12;
                    }
                    case "item": {
                        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)parts[1]));
                        guiGraphics.renderItem(new ItemStack((ItemLike)item), -8, -8);
                        break;
                    }
                    case "image": {
                        ResourceLocation res = ResourceLocation.tryParse((String)parts[1]);
                        if (res == null) break;
                        guiGraphics.blit(res, -8, -8, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                    }
                }
                break block12;
            }
            pose.scale(size, size, size);
            this.drawTextName(guiGraphics, name, color);
        }
        pose.popPose();
    }

    public static enum FlipMode {
        tire,
        button;

    }

    public record RenderPageData(MenuPageData pageData, List<DT_ListBoxData> projects) {
        public static RenderPageData creat(MenuPageData pageData, DT_ListBoxData.OnPress func) {
            ArrayList<DT_ListBoxData> data = new ArrayList<DT_ListBoxData>();
            pageData.projects().forEach(projectData -> {
                MenuProjectData menuData = Configs.MenuProjects.get(projectData.key());
                String name = "";
                if (menuData != null) {
                    name = menuData.name();
                }
                data.add(new DT_ListBoxData((Component)Component.literal((String)name), (Object)projectData.key(), func));
            });
            return new RenderPageData(pageData, data);
        }
    }
}

