/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui;

import com.google.common.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import dev.anye.mc.nekoui.config.Config;
import dev.anye.mc.nekoui.config.hide$hud.HideHudConfig;
import dev.anye.mc.nekoui.event.CommandList;
import dev.anye.mc.nekoui.gui.MobDirectionGui;
import dev.anye.mc.nekoui.gui.ScreenElementGui;
import dev.anye.mc.nekoui.gui.hot$bar.HotBarGui;
import dev.anye.mc.nekoui.gui.hot$bar.HotBarSys;
import dev.anye.mc.nekoui.render.MobHealthBar;
import dev.anye.mc.nekoui.screen.MenuScreen;
import dev.anye.mc.nekoui.screen.SettingScreen;
import dev.anye.mc.nekoui.util.KeyBinding;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ExtractLevelRenderStateEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;

@Mod(value="nekoui", dist={Dist.CLIENT})
@EventBusSubscriber(modid="nekoui", value={Dist.CLIENT})
public class NekoUIClient {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void regCommand(RegisterCommandsEvent event) {
        CommandList commandList = new CommandList((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        commandList.register();
    }

    @SubscribeEvent
    public static void onGuiRender(RenderGuiLayerEvent.Pre event) {
        if (Config.INSTANCE.getDatas().isOutputGuiId()) {
            LOGGER.info(event.getName().toString());
        }
        if (HideHudConfig.I.isHide(event.getName())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isAlive()) {
            HotBarSys.setNowTime();
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isAlive()) {
            if (event.getKey() >= 49 && event.getKey() <= 57) {
                HotBarSys.setNowTime();
            }
            if (Config.INSTANCE.getDatas().isMenu()) {
                Screen screen2;
                if (event.getKey() == KeyBinding.OPEN_MENU.getKey().getValue()) {
                    screen2 = Minecraft.getInstance().screen;
                    if (event.getAction() == 0) {
                        if (screen2 instanceof MenuScreen) {
                            MenuScreen menuScreen = (MenuScreen)screen2;
                            menuScreen.onClose();
                        }
                    } else if (event.getAction() == 1 && screen2 == null) {
                        Minecraft.getInstance().setScreen((Screen)new MenuScreen());
                    }
                }
                if (event.getKey() == KeyBinding.OPEN_SET_MENU.getKey().getValue()) {
                    screen2 = Minecraft.getInstance().screen;
                    if (event.getAction() == 1 && screen2 == null) {
                        Minecraft.getInstance().setScreen((Screen)new SettingScreen());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public static void onKeyRegister(RegisterKeyMappingsEvent event) {
        if (Config.INSTANCE.getDatas().isMenu()) {
            event.register(KeyBinding.OPEN_MENU);
            event.register(KeyBinding.OPEN_SET_MENU);
        }
    }

    @SubscribeEvent
    public static void onGuiReg(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ScreenElementGui.RESOURCE_LOCATION, ScreenElementGui::render);
        event.registerAboveAll(MobDirectionGui.RESOURCE_LOCATION, MobDirectionGui::render);
        event.registerAboveAll(HotBarGui.RESOURCE_LOCATION, HotBarGui::render);
    }

    @SubscribeEvent
    public static void on(RegisterRenderStateModifiersEvent event) {
        event.registerEntityModifier((TypeToken)new TypeToken<EntityRenderer<? extends Entity, ? extends EntityRenderState>>(){}, (entity, renderState) -> {
            renderState.setRenderData(MobHealthBar.EntityKey, entity);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                renderState.setRenderData(MobHealthBar.HealthKey, (Object)Float.valueOf(livingEntity.getHealth()));
                renderState.setRenderData(MobHealthBar.MaxHealthKey, (Object)Float.valueOf(livingEntity.getMaxHealth()));
            }
        });
    }

    public static void onELRSE(ExtractLevelRenderStateEvent event) {
    }

    @SubscribeEvent
    public static void onRender(RenderLivingEvent.Post<LivingEntity, ?, ?> event) {
        MobHealthBar.render(event.getRenderState(), event.getRenderer(), event.getSubmitNodeCollector(), event.getPoseStack());
    }
}

