/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.screen;

import com.mojang.logging.LogUtils;
import dev.anye.core.system._KeySimulate;
import dev.anye.core.system._System;
import dev.anye.mc.cores.js.Js;
import dev.anye.mc.cores.screen.widget.CircularWidget;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.graaljs.javascript.EasyJS;
import dev.anye.mc.nekoui.config.Config;
import dev.anye.mc.nekoui.config.Configs;
import dev.anye.mc.nekoui.config.menu.MenuScreenConfig;
import dev.anye.mc.nekoui.dat$type.MenuProjectData;
import dev.anye.mc.nekoui.screen.widget.CircularMenu;
import dev.anye.mc.nekoui.screen.widget.CircularNewMenu;
import java.awt.AWTException;
import java.awt.Robot;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;

public class MenuScreen
extends Screen {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private CircularMenu circularMenu;
    private CircularNewMenu circularNewMenu;

    public MenuScreen() {
        super((Component)Component.translatable((String)"screen.nekoui.menu.title"));
    }

    protected void init() {
        super.init();
        this.addMenu();
    }

    private void addMenu() {
        if (Config.INSTANCE.getDatas().isAutoPage()) {
            ArrayList<DT_ListBoxData> data = new ArrayList<DT_ListBoxData>();
            Configs.MenuProjects.forEach((s, menuData) -> data.add(new DT_ListBoxData((Component)Component.literal((String)menuData.name()), s, this::run)));
            this.circularMenu = new CircularMenu(this.width / 2, this.height / 2, this.width, this.height, MenuScreenConfig.INSTANCE.getDatas().sectors, MenuScreenConfig.INSTANCE.getDatas().innerRadius, MenuScreenConfig.INSTANCE.getDatas().outerRadius, (Component)Component.empty(), data);
            this.circularMenu.setFlipMode(CircularWidget.FlipMode.button);
            this.addRenderableWidget((GuiEventListener)this.circularMenu);
        } else {
            ArrayList<CircularNewMenu.RenderPageData> pd = new ArrayList<CircularNewMenu.RenderPageData>();
            Configs.MenuPage.forEach(pageData -> pd.add(CircularNewMenu.RenderPageData.creat(pageData, this::run)));
            this.circularNewMenu = new CircularNewMenu(this.width / 2, this.height / 2, this.width, this.height, (Component)Component.empty(), pd);
            this.circularNewMenu.setFlipMode(CircularNewMenu.FlipMode.button);
            this.addRenderableWidget((GuiEventListener)this.circularNewMenu);
        }
    }

    public void run(Object v) {
        String s;
        MenuProjectData menuData;
        if (v instanceof String && (menuData = Configs.MenuProjects.get(s = (String)v)) != null && !menuData.value().isEmpty()) {
            switch (menuData.type()) {
                case message: {
                    MenuScreen.sendChat(menuData.value());
                    break;
                }
                case command: {
                    MenuScreen.sendCommand(menuData.value());
                    break;
                }
                case button: {
                    String[] keyA = menuData.value().split(" ");
                    int[] keys = new int[keyA.length];
                    for (int i = 0; i < keyA.length; ++i) {
                        keys[i] = Integer.parseInt(keyA[i]);
                    }
                    MenuScreen.simulateKey(keys);
                    break;
                }
                case js: {
                    if (Js.CanRun) {
                        EasyJS.NotSafe().addParameter("minecraft", (Object)Minecraft.getInstance()).runFile(Configs.ConfigDir_JS + menuData.value());
                        break;
                    }
                    LOGGER.error("GraalJS not install can't run js code");
                }
            }
        }
    }

    public static void sendChat(String msg) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.connection.sendChat(msg);
        }
    }

    public static void sendCommand(String command) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.connection.sendCommand(command);
        }
    }

    public static void simulateKey(int[] keyCode) {
        if (_System.isWindows) {
            for (int key : keyCode) {
                _KeySimulate.simulateKeyPress((int)key);
            }
            for (int i = keyCode.length - 1; i >= 0; --i) {
                _KeySimulate.simulateKeyRelease((int)keyCode[i]);
            }
        } else {
            try {
                Robot robot = new Robot();
                for (int key : keyCode) {
                    robot.keyPress(key);
                }
                for (int i = keyCode.length - 1; i >= 0; --i) {
                    robot.keyRelease(keyCode[i]);
                }
            }
            catch (AWTException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    public void onClose() {
        if (Config.INSTANCE.getDatas().isAutoPage()) {
            DT_ListBoxData dtListBoxData = this.circularMenu.getData();
            if (dtListBoxData != null) {
                dtListBoxData.OnPress(dtListBoxData.getValue());
            }
        } else {
            DT_ListBoxData dtListBoxData = this.circularNewMenu.getData();
            if (dtListBoxData != null) {
                dtListBoxData.OnPress(dtListBoxData.getValue());
            }
        }
        super.onClose();
    }
}

