/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.dat$type;

import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;

@OnlyIn(value=Dist.CLIENT)
public record ScreenRender(String x, String y, Vector3i pos, List<Element> elements) {
    @Override
    @NotNull
    public String toString() {
        return "{\"x\":\"" + this.x + "\",\"y\":\"" + this.y + "\",\"pos\":" + String.valueOf(this.pos) + ",\"elements\":" + String.valueOf(this.elements) + "}";
    }

    public static enum Type {
        Image(0),
        Self(1),
        Custom(2),
        PlayerData(3),
        Js(4),
        Slot(5);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type fromInt(int type) {
            for (Type t : Type.values()) {
                if (t.value != type) continue;
                return t;
            }
            throw new IllegalArgumentException("No enum constant with value " + type);
        }

        public static Type getTypeEnum(String type) {
            try {
                return Type.fromInt(Integer.parseInt(type));
            }
            catch (NumberFormatException e) {
                return Type.valueOf(type);
            }
        }
    }

    public record Element(Vector3i pos, Type type, String key, String color, int width, int height) {
        public Element(Vector3i pos, int type, String key, String color) {
            this(pos, type, key, color, 10, 10);
        }

        public Element(Vector3i pos, int type, String key, String color, int width, int height) {
            this(pos, Type.fromInt(type), key, color, width, height);
        }

        public Element(Vector3i pos, String type, String key, String color) {
            this(pos, type, key, color, 10, 10);
        }

        public Element(Vector3i pos, String type, String key, String color, int width, int height) {
            this(pos, Type.getTypeEnum(type), key, color, width, height);
        }

        @Override
        @NotNull
        public String toString() {
            return "Element{pos=" + String.valueOf(this.pos) + ", type=" + String.valueOf((Object)this.type) + ", key='" + this.key + "', color='" + this.color + "', width=" + this.width + ", height=" + this.height + "}";
        }
    }
}

