/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.event;

import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import dev.anye.core.format._FormatToString;
import dev.anye.mc.nekoui.config.health$bar.HealthBarConfig;
import dev.anye.mc.nekoui.render.MobHealthBar;
import dev.anye.mc.nekoui.render.RenderSupport;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.client.FramePassManager;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.slf4j.Logger;

public class FramePassRender
implements FramePassManager.PassDefinition {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Minecraft minecraft = Minecraft.getInstance();

    public void targets(LevelTargetBundle bundle, FramePass pass) {
        bundle.main = pass.readsAndWrites(bundle.main);
    }

    public void executes() {
        if (HealthBarConfig.I.getDatas().enable) {
            RenderBuffers buffers = this.minecraft.renderBuffers();
            MultiBufferSource.BufferSource bufSource = buffers.bufferSource();
            PoseStack pose = new PoseStack();
            pose.pushPose();
            if (this.minecraft.level == null || this.minecraft.player == null) {
                return;
            }
            pose.translate(this.minecraft.gameRenderer.getMainCamera().position().multiply(-1.0, -1.0, -1.0));
            this.minecraft.level.getEntities(null, this.minecraft.player.getBoundingBox().inflate((double)HealthBarConfig.I.getDatas().renderDistance)).forEach(entity -> {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (HealthBarConfig.I.getDatas().renderOnlyView && MobHealthBar.checkView(this.minecraft, livingEntity)) {
                        Quaternionf cameraq = this.minecraft.getEntityRenderDispatcher().camera.rotation();
                        if (HealthBarConfig.I.getDatas().renderHealthBar) {
                            float y = livingEntity.getBbHeight() + HealthBarConfig.I.getDatas().renderTop;
                            int h = Math.max((int)(livingEntity.getHealth() / livingEntity.getMaxHealth() * 121.0f), 0);
                            pose.pushPose();
                            pose.translate(livingEntity.position());
                            pose.translate(0.0f, y, 0.0f);
                            pose.mulPose((Quaternionfc)cameraq);
                            pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                            pose.scale(-0.0125f, -0.005f, 0.0125f);
                            VertexConsumer consumer = bufSource.getBuffer(MobHealthBar.HBRT);
                            int pl = this.getPackedLightCoords((Entity)livingEntity, 0.0f);
                            RenderSupport.image(consumer, pose.last().pose(), -64, 0, 0.0f, 0.0f, 128, 32, 128, 128, 0.0f, pl);
                            RenderSupport.image(consumer, pose.last().pose(), -64, 0, 0.0f, 32.0f, Math.min(h, 121), 32, 128, 128, 0.0f, pl);
                            bufSource.endBatch();
                            if (HealthBarConfig.I.getDatas().renderHealthBarText) {
                                String txt = _FormatToString.numberToString((Object)Float.valueOf(livingEntity.getHealth())) + "/" + _FormatToString.numberToString((Object)Float.valueOf(livingEntity.getMaxHealth()));
                                Font font = this.minecraft.font;
                                float f = -((float)this.minecraft.font.width(txt)) / 2.0f;
                                Objects.requireNonNull(this.minecraft.font);
                                font.drawInBatch(txt, f, 16.0f - 9.0f / 2.0f, 0, false, pose.last().pose(), (MultiBufferSource)this.minecraft.renderBuffers().bufferSource(), Font.DisplayMode.NORMAL, 0, pl);
                            }
                            pose.popPose();
                        }
                    }
                }
            });
            pose.popPose();
        }
    }

    public final int getPackedLightCoords(Entity pEntity, float pPartialTicks) {
        BlockPos blockpos = BlockPos.containing((Position)pEntity.getLightProbePosition(pPartialTicks));
        return LightTexture.pack((int)this.getBlockLightLevel(pEntity, blockpos), (int)this.getSkyLightLevel(pEntity, blockpos));
    }

    protected int getBlockLightLevel(Entity pEntity, BlockPos pPos) {
        return pEntity.isOnFire() ? 15 : pEntity.level().getBrightness(LightLayer.BLOCK, pPos);
    }

    protected int getSkyLightLevel(Entity pEntity, BlockPos pPos) {
        return pEntity.level().getBrightness(LightLayer.SKY, pPos);
    }
}

