/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.nekoui.screen.widget;

import dev.anye.mc.cores.screen.widget.CircularWidget;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix3x2fStack;

public class CircularMenu
extends CircularWidget {
    public CircularMenu(int x, int y, int w, int h, Component message, DT_ListBoxData ... data) {
        super(x, y, w, h, message, data);
    }

    public CircularMenu(int x, int y, int w, int h, Component message, List<DT_ListBoxData> data) {
        super(x, y, w, h, message, data);
    }

    public CircularMenu(int x, int y, int w, int h, int sectors, int innerRadius, int outerRadius, Component message, DT_ListBoxData ... data) {
        super(x, y, w, h, sectors, innerRadius, outerRadius, message, data);
    }

    public CircularMenu(int x, int y, int w, int h, int sectors, int innerRadius, int outerRadius, Component message, List<DT_ListBoxData> data) {
        super(x, y, w, h, sectors, innerRadius, outerRadius, message, data);
    }

    public CircularMenu(int x, int y, int w, int h, int sectors, int innerRadius, int outerRadius, int highlightColor, int normalColor, Component message, DT_ListBoxData ... data) {
        super(x, y, w, h, sectors, innerRadius, outerRadius, highlightColor, normalColor, message, data);
    }

    public CircularMenu(int x, int y, int w, int h, int sectors, int innerRadius, int outerRadius, int highlightColor, int normalColor, Component message, List<DT_ListBoxData> data) {
        super(x, y, w, h, sectors, innerRadius, outerRadius, highlightColor, normalColor, message, data);
    }

    public void setData(List<DT_ListBoxData> data) {
        this.data = data;
    }

    protected void drawName(GuiGraphics guiGraphics, double rad, String name, int color, float size) {
        Matrix3x2fStack pose;
        block12: {
            block11: {
                pose = guiGraphics.pose();
                pose.pushMatrix();
                String[] parts = name.split("\\?");
                if (parts.length != 2) break block11;
                double r = (double)this.getFanTextInnerSpace() + (double)(this.outerRadius - this.innerRadius) / 2.0;
                double x = Math.cos(rad) * r;
                double y = Math.sin(rad) * r;
                pose.translate((float)x, (float)y);
                pose.scale(size, size);
                switch (parts[0]) {
                    case "slot": {
                        LocalPlayer player = Minecraft.getInstance().player;
                        if (player != null) {
                            ItemStack item = player.getInventory().getItem(Integer.parseInt(parts[1]));
                            guiGraphics.renderItem(item, -8, -8);
                            guiGraphics.renderItemDecorations(this.font, item, -8, -8);
                            break;
                        }
                        break block12;
                    }
                    case "item": {
                        Item item = (Item)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)parts[1])).get()).value();
                        guiGraphics.renderItem(new ItemStack((ItemLike)item), -8, -8);
                        break;
                    }
                    case "image": {
                        ResourceLocation res = ResourceLocation.tryParse((String)parts[1]);
                        if (res == null) break;
                        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, res, -8, -8, 0.0f, 0.0f, 0, 16, 16, 16, 16);
                    }
                }
                break block12;
            }
            pose.scale(size, size);
            this.drawTextName(guiGraphics, name, color);
        }
        pose.popMatrix();
    }
}

