package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2257;
import net.minecraft.class_2338;
import net.minecraft.class_2453;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_7157;
import tools.redstone.redstonetools.utils.WorldEditUtils;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class BinaryBlockReadFeature {
	public static final BinaryBlockReadFeature INSTANCE = new BinaryBlockReadFeature();

	protected BinaryBlockReadFeature() {
	}

	public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
		dispatcher.register(
			method_9247("/read")
				.requires(source -> source.method_9259(2))
				.executes(getCommandForArgumentCount(0))
				.then(method_9244("offset", IntegerArgumentType.integer(1))
					.executes(getCommandForArgumentCount(1))
					.then(method_9244("onBlock", class_2257.method_9653(registryAccess))
						.executes(getCommandForArgumentCount(2))
						.then(method_9244("toBase", IntegerArgumentType.integer(2, 16))
							.executes(getCommandForArgumentCount(3))
							.then(method_9244("reverseBits", BoolArgumentType.bool())
								.executes(getCommandForArgumentCount(4)))))));
	}

	protected Command<class_2168> getCommandForArgumentCount(int argNum) {
		return context -> execute(context, argNum);
	}

	protected int execute(CommandContext<class_2168> context, int argCount) throws CommandSyntaxException {
		boolean reverseBits;
		int offset = argCount >= 1 ? IntegerArgumentType.getInteger(context, "offset") : 2;
		class_2680 onBlock = argCount >= 2 ?
			class_2257.method_9655(context, "onBlock").method_9494() :
			class_2246.field_10524.method_9564().method_11657(class_2453.field_11413, true);
		int toBase = argCount >= 3 ? IntegerArgumentType.getInteger(context, "toBase") : 10;
		reverseBits = argCount >= 4 && BoolArgumentType.getBool(context, "reverseBits");
		return execute(context, offset, onBlock, toBase, reverseBits);
	}

	protected int execute(CommandContext<class_2168> context, int offset, class_2680 onBlock, int toBase, boolean reverseBits) throws CommandSyntaxException {
		var source = context.getSource();
		Region selection = WorldEditUtils.getSelection(source.method_44023());

		var boundingBox = selection.getBoundingBox();
		var pos1 = boundingBox.getPos1();
		var pos2 = boundingBox.getPos2();
		var direction = pos2.subtract(pos1).normalize();

		// prevent infinite loop
		if (direction.lengthSq() == 0) {
			direction = BlockVector3.at(0, 0, 1);
		}

		var spacingVector = direction.multiply(offset);

		if (direction.x() + direction.y() + direction.z() > 1) {
			throw new SimpleCommandExceptionType(class_2561.method_30163("The selection must have 2 axis the same.")).create();
		}

		var bits = new StringBuilder();
		for (BlockVector3 point = pos1; boundingBox.contains(point); point = point.add(spacingVector)) {
			var pos = new class_2338(point.x(), point.y(), point.z());
			var actualState = source.method_9225().method_8320(pos);
			var matches = actualState.equals(onBlock) && actualState.method_11656().equals(onBlock.method_11656());

			bits.append(matches ? 1 : 0);
		}

		if (reverseBits) {
			bits.reverse();
		}

		var output = Integer.toString(Integer.parseInt(bits.toString(), 2), toBase);
		source.method_45068(class_2561.method_30163(output));
		return 0;
	}
}
