package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_5134;
import net.minecraft.class_634;
import net.minecraft.class_7157;


public class ReachClient {
	public static final ReachClient INSTANCE = new ReachClient();

	protected ReachClient() {
	}

	public void registerCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
			dispatcher.register(ClientCommandManager.literal("reach")
				.requires(source -> source.getPlayer().method_64475(2))
				.then(ClientCommandManager.argument("reach", FloatArgumentType.floatArg(0.0f))
					.executes(context -> execute(context, true, true))
				)
				.then(ClientCommandManager.literal("reset")
					.executes(context -> reset(context, true, true))
				)
				.then(ClientCommandManager.literal("block")
					.then(ClientCommandManager.argument("reach", FloatArgumentType.floatArg(0.0f))
						.suggests((context, builder) -> {
							builder.suggest(String.valueOf(class_5134.field_47758.comp_349().method_6169()));
							return builder.buildFuture();
						})
						.executes(context -> execute(context, true, false))
					)
				)
				.then(ClientCommandManager.literal("entity")
					.then(ClientCommandManager.argument("reach", FloatArgumentType.floatArg(0.0f))
						.suggests((context, builder) -> {
							builder.suggest(String.valueOf(class_5134.field_47759.comp_349().method_6169()));
							return builder.buildFuture();
						})
						.executes(context -> execute(context, false, true))
					)
				));
	}

	private int execute(CommandContext<FabricClientCommandSource> context, boolean block, boolean entity) {
		float reach = FloatArgumentType.getFloat(context, "reach");
		class_634 networkHandler = context.getSource().getPlayer().field_3944;
		if (block) networkHandler.method_45730("attribute @s minecraft:block_interaction_range base set " + reach);
		if (entity) networkHandler.method_45730("attribute @s minecraft:entity_interaction_range base set " + reach);
		return 0;
	}

	private int reset(CommandContext<FabricClientCommandSource> context, boolean block, boolean entity) {
		class_634 networkHandler = context.getSource().getPlayer().field_3944;
		if (block) networkHandler.method_45730("attribute @s minecraft:block_interaction_range base reset");
		if (entity) networkHandler.method_45730("attribute @s minecraft:entity_interaction_range base reset");
		return 0;
	}
}
